/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.ntask.core.impl;

import java.util.Map;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.ntask.core.Task;

public class TaskQuartzJobAdapter
implements Job {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(JobExecutionContext ctx) throws JobExecutionException {
        JobDataMap dataMap = ctx.getJobDetail().getJobDataMap();
        String taskClassName = dataMap.getString("__TASK_CLASS_NAME__");
        if (taskClassName == null) {
            throw new JobExecutionException("The task class is missing in the job data map");
        }
        try {
            Task task = (Task)Class.forName(taskClassName).newInstance();
            Map properties = (Map)dataMap.get((Object)"__TASK_PROPERTIES__");
            task.setProperties(properties);
            int tenantId = Integer.parseInt((String)properties.get("__TENANT_ID_PROP__"));
            try {
                PrivilegedCarbonContext.startTenantFlow();
                PrivilegedCarbonContext.getCurrentContext().setTenantId(tenantId, true);
                task.init();
                task.execute();
            }
            finally {
                PrivilegedCarbonContext.endTenantFlow();
            }
        }
        catch (Throwable e) {
            throw new JobExecutionException("Error in creating an object of task class: " + taskClassName, e);
        }
    }
}

