/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.coordination.core.sync.impl;

import java.util.Collections;
import java.util.List;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.wso2.carbon.coordination.common.CoordinationException;
import org.wso2.carbon.coordination.core.sync.Barrier;
import org.wso2.carbon.coordination.core.sync.impl.ZKSyncPrimitive;

public class ZKBarrier
extends ZKSyncPrimitive
implements Barrier {
    private int count;
    private String createdPath;

    public ZKBarrier(ZooKeeper zooKeeper, String barrierId, int count, int waitTimeout) throws CoordinationException {
        super(zooKeeper, Barrier.class.getCanonicalName(), barrierId, waitTimeout);
        this.count = count;
    }

    public int getCount() {
        return this.count;
    }

    public String getCreatedPath() {
        return this.createdPath;
    }

    public void setCreatedPath(String createdPath) {
        this.createdPath = createdPath;
    }

    @Override
    public void waitOnBarrier() throws CoordinationException {
        this.enter();
        this.leave();
    }

    @Override
    public void enter() throws CoordinationException {
        block5: {
            try {
                this.getZooKeeper().exists(this.getRootPath() + "/ready", (Watcher)this);
                String tmpPath = this.getZooKeeper().create(this.getRootPath() + "/node", new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL_SEQUENTIAL);
                this.setCreatedPath(tmpPath);
                List ids = this.getZooKeeper().getChildren(this.getRootPath(), false);
                Collections.sort(ids);
                if (ids.size() < this.getCount() || !this.getCreatedPath().endsWith((String)ids.get(ids.size() - 1))) {
                    do {
                        this.takeQueuedEvent();
                    } while (this.getZooKeeper().getChildren(this.getRootPath(), false).size() < this.getCount());
                    break block5;
                }
                this.getZooKeeper().create(this.getRootPath() + "/ready", new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL);
                return;
            }
            catch (CoordinationException e) {
                this.releaseResources();
                throw e;
            }
            catch (Exception e) {
                this.releaseResources();
                throw new CoordinationException(CoordinationException.ExceptionCode.GENERIC_ERROR, e);
            }
        }
    }

    @Override
    public void leave() throws CoordinationException {
        try {
            this.getZooKeeper().delete(this.getCreatedPath(), -1);
            if (this.getZooKeeper().getChildren(this.getRootPath(), (Watcher)this).size() > 1) {
                while (this.takeQueuedEvent() != null && this.getZooKeeper().getChildren(this.getRootPath(), (Watcher)this).size() > 1) {
                }
            }
        }
        catch (KeeperException e) {
            if (e.code() != KeeperException.Code.NONODE) {
                throw new CoordinationException(CoordinationException.ExceptionCode.GENERIC_ERROR, (Exception)((Object)e));
            }
        }
        catch (Exception e) {
            throw new CoordinationException(CoordinationException.ExceptionCode.GENERIC_ERROR, e);
        }
        finally {
            this.setCreatedPath(null);
        }
    }

    @Override
    public String getBarrierId() {
        return this.getId();
    }
}

