/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.indexing.service;

import java.util.Calendar;
import org.wso2.carbon.registry.common.ResourceData;
import org.wso2.carbon.registry.common.utils.CommonUtil;
import org.wso2.carbon.registry.core.Collection;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.secure.AuthorizationFailedException;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.registry.indexing.service.AdvancedResourceQuery;
import org.wso2.carbon.registry.indexing.service.AdvancedSearchResultsBean;

public class AdvancedSearchResultsBeanPopulator {
    public static AdvancedSearchResultsBean populate(UserRegistry registry, String resourceName, String authorName, String updaterName, String createdAfter, String createdBefore, String updatedAfter, String updatedBefore, String tags, String commentWords, String propertyName, String propertyValue, String content) {
        AdvancedSearchResultsBean advancedSearchResultsBean = new AdvancedSearchResultsBean();
        try {
            AdvancedResourceQuery query = new AdvancedResourceQuery();
            query.setResourceName(resourceName);
            query.setAuthorName(authorName);
            query.setUpdaterName(updaterName);
            query.setCreatedAfter(CommonUtil.computeDate((String)createdAfter));
            query.setCreatedBefore(CommonUtil.computeDate((String)createdBefore));
            query.setUpdatedAfter(CommonUtil.computeDate((String)updatedAfter));
            query.setUpdatedBefore(CommonUtil.computeDate((String)updatedBefore));
            query.setCommentWords(commentWords);
            query.setTags(tags);
            query.setPropertyName(propertyName);
            query.setPropertyValue(propertyValue);
            query.setContent(content);
            Resource qResults = query.execute((Registry)registry);
            String[] childPaths = (String[])qResults.getContent();
            int resultSize = childPaths.length;
            if (resultSize > 40) {
                resultSize = 40;
            }
            ResourceData[] resourceDataList = new ResourceData[resultSize];
            for (int i = 0; i < resultSize; ++i) {
                ResourceData resourceData = new ResourceData();
                resourceData.setResourcePath(childPaths[i]);
                if (childPaths[i] != null) {
                    if ("/".equals(childPaths[i])) {
                        resourceData.setName("root");
                    } else {
                        String[] parts = childPaths[i].split("/");
                        resourceData.setName(parts[parts.length - 1]);
                    }
                }
                try {
                    Resource child = registry.get(childPaths[i]);
                    resourceData.setResourceType(child instanceof Collection ? "collection" : "resource");
                    resourceData.setAuthorUserName(child.getAuthorUserName());
                    resourceData.setDescription(child.getDescription());
                    resourceData.setAverageRating(registry.getAverageRating(child.getPath()));
                    Calendar createdDateTime = Calendar.getInstance();
                    createdDateTime.setTime(child.getCreatedTime());
                    resourceData.setCreatedOn(createdDateTime);
                    CommonUtil.populateAverageStars((ResourceData)resourceData);
                    child.discard();
                    resourceDataList[i] = resourceData;
                    continue;
                }
                catch (AuthorizationFailedException e) {
                    // empty catch block
                }
            }
            advancedSearchResultsBean.setResourceDataList(resourceDataList);
        }
        catch (RegistryException e) {
            String msg = "Failed to get advanced search results. " + e.getMessage();
            advancedSearchResultsBean.setErrorMessage(msg);
        }
        return advancedSearchResultsBean;
    }
}

