/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.indexing;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.registry.core.Collection;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.registry.core.utils.RegistryUtils;
import org.wso2.carbon.registry.indexing.AsyncIndexer;
import org.wso2.carbon.registry.indexing.RegistryConfigLoader;
import org.wso2.carbon.registry.indexing.ResourceSubmitter;
import org.wso2.carbon.registry.indexing.Utils;
import org.wso2.carbon.registry.indexing.indexer.Indexer;
import org.wso2.carbon.registry.indexing.utils.IndexingUtils;

@SuppressWarnings(value={"EI_EXPOSE_REP", "EI_EXPOSE_REP2"})
public class IndexingManager {
    private static Log log = LogFactory.getLog(IndexingManager.class);
    private static volatile IndexingManager instance;
    private UserRegistry registry;
    private RegistryConfigLoader registryConfig;
    private AsyncIndexer indexer;
    private ScheduledExecutorService submittingExecutor;
    private ScheduledExecutorService indexingExecutor;
    private Date lastAccessTime;
    private volatile Pattern[] patterns = null;

    private IndexingManager() {
        try {
            this.registry = Utils.getRegistryService().getRegistry("wso2.system.user");
            this.registryConfig = new RegistryConfigLoader();
            this.indexer = new AsyncIndexer();
        }
        catch (RegistryException e) {
            log.error((Object)"Could not initialize registry for indexing", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static IndexingManager getInstance() {
        if (instance != null) return instance;
        Class<IndexingManager> clazz = IndexingManager.class;
        synchronized (IndexingManager.class) {
            instance = new IndexingManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public synchronized void startIndexing() {
        this.stopIndexing();
        this.submittingExecutor = Executors.newSingleThreadScheduledExecutor();
        this.submittingExecutor.scheduleWithFixedDelay(new ResourceSubmitter(this), this.getStartingDelayInSecs(), this.getIndexingFreqInSecs(), TimeUnit.SECONDS);
        this.indexingExecutor = Executors.newSingleThreadScheduledExecutor();
        this.indexingExecutor.schedule(this.indexer, this.getStartingDelayInSecs(), TimeUnit.SECONDS);
        this.readLastAccessTime();
    }

    public synchronized void restartIndexing() {
        this.stopIndexing();
        try {
            this.registry.delete(this.getLastAccessTimeLocation());
        }
        catch (RegistryException e) {
            log.error((Object)"Could not delete last activity time to restart indexing", (Throwable)e);
        }
        this.startIndexing();
    }

    public synchronized void stopIndexing() {
        if (this.submittingExecutor != null) {
            this.submittingExecutor.shutdownNow();
            this.submittingExecutor = null;
        }
        if (this.indexingExecutor != null) {
            this.indexingExecutor.shutdownNow();
            this.indexingExecutor = null;
        }
        this.writeLastAccessTime();
    }

    public long getStartingDelayInSecs() {
        return this.registryConfig.getStartingDelayInSecs();
    }

    public boolean canIndex(String path) {
        if (this.patterns == null) {
            this.patterns = this.registryConfig.getExclusionPatterns();
        }
        for (Pattern pattern : this.patterns) {
            if (!pattern.matcher(path).matches()) continue;
            return false;
        }
        return true;
    }

    public long getIndexingFreqInSecs() {
        return this.registryConfig.getIndexingFreqInSecs();
    }

    public String getLastAccessTimeLocation() {
        return this.registryConfig.getLastAccessTimeLocation();
    }

    private AsyncIndexer getIndexer() throws RegistryException {
        return this.indexer;
    }

    public void deleteFromIndex(String oldPath, int tenantId) throws RegistryException {
        this.getIndexer().getClient().deleteFromIndex(oldPath, tenantId);
    }

    public void submitFileForIndexing(Resource resource, String path, String sourceURL) throws RegistryException {
        if (resource.getMediaType() == null || this.getIndexerForMediaType(resource.getMediaType()) == null) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Submitting file " + path + " for Indexing"));
        }
        this.getIndexer().addFile(new AsyncIndexer.File2Index(IndexingUtils.getByteContent(resource, sourceURL), resource.getMediaType(), path, -1234));
        String symlinkPath = resource.getProperty("registry.resource.symlink.path");
        if (symlinkPath != null) {
            this.getIndexer().addFile(new AsyncIndexer.File2Index(IndexingUtils.getByteContent(resource, sourceURL), resource.getMediaType(), symlinkPath, -1234));
        }
    }

    public Indexer getIndexerForMediaType(String mimeType) {
        for (Map.Entry<String, Indexer> entry : this.registryConfig.getIndexerMap().entrySet()) {
            if (!Pattern.matches(entry.getKey(), mimeType)) continue;
            return entry.getValue();
        }
        return null;
    }

    public boolean isIndexable(Resource resource) {
        return resource != null && resource.getMediaType() != null && !(resource instanceof Collection) && IndexingManager.getInstance().getIndexerForMediaType(resource.getMediaType()) != null;
    }

    public UserRegistry getRegistry() {
        return this.registry;
    }

    public Date getLastAccessTime() {
        return this.lastAccessTime;
    }

    public void setLastAccessTime(Date lastAccessTime) {
        this.lastAccessTime = lastAccessTime;
    }

    private void writeLastAccessTime() {
        try {
            if (null != this.getLastAccessTime()) {
                Resource resource = this.registry.newResource();
                resource.setContent((Object)String.valueOf(this.getLastAccessTime().getTime()));
                this.registry.put(this.getLastAccessTimeLocation(), resource);
            }
        }
        catch (RegistryException e) {
            log.error((Object)"Could not write last activity time when stopping indexing", (Throwable)e);
        }
    }

    private void readLastAccessTime() {
        try {
            String lastAccessTimeLocation = this.getLastAccessTimeLocation();
            this.setLastAccessTime(this.registry.resourceExists(lastAccessTimeLocation) ? new Date(Long.parseLong(RegistryUtils.decodeBytes((byte[])((byte[])this.registry.get(lastAccessTimeLocation).getContent())))) : null);
        }
        catch (RegistryException e) {
            log.error((Object)"Could not read last activity time when starting indexing", (Throwable)e);
        }
    }
}

