/*
 * Decompiled with CFR 0.152.
 */
package org.h2.jaqu;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.h2.jaqu.Define;
import org.h2.jaqu.Query;
import org.h2.jaqu.Table;
import org.h2.jaqu.TableDefinition;
import org.h2.jaqu.TestCondition;
import org.h2.jaqu.Token;
import org.h2.jaqu.util.Utils;
import org.h2.jaqu.util.WeakIdentityHashMap;
import org.h2.util.JdbcUtils;

public class Db {
    private static final WeakIdentityHashMap<Object, Token> TOKENS = Utils.newWeakIdentityHashMap();
    private final Connection conn;
    private final Map<Class<?>, TableDefinition<?>> classMap = Utils.newHashMap();

    Db(Connection connection) {
        this.conn = connection;
    }

    static <X> X registerToken(X x, Token token) {
        TOKENS.put(x, token);
        return x;
    }

    static Token getToken(Object object) {
        return TOKENS.get(object);
    }

    private static <T> T instance(Class<T> clazz) {
        try {
            return clazz.newInstance();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public static Db open(String string, String string2, String string3) {
        try {
            Connection connection = JdbcUtils.getConnection(null, string, string2, string3);
            return new Db(connection);
        }
        catch (SQLException sQLException) {
            throw Db.convert(sQLException);
        }
    }

    public static Db open(String string, String string2, char[] cArray) {
        try {
            Properties properties = new Properties();
            properties.setProperty("user", string2);
            properties.put("password", cArray);
            Connection connection = JdbcUtils.getConnection(null, string, properties);
            return new Db(connection);
        }
        catch (SQLException sQLException) {
            throw Db.convert(sQLException);
        }
    }

    private static Error convert(Exception exception) {
        return new Error(exception);
    }

    public <T> void insert(T t) {
        Class<?> clazz = t.getClass();
        this.define(clazz).createTableIfRequired(this).insert(this, t);
    }

    public <T> void merge(T t) {
        Class<?> clazz = t.getClass();
        this.define(clazz).createTableIfRequired(this).merge(this, t);
    }

    public <T> void update(T t) {
        Class<?> clazz = t.getClass();
        this.define(clazz).createTableIfRequired(this).update(this, t);
    }

    public <T> Query<T> from(T t) {
        Class<?> clazz = t.getClass();
        this.define(clazz).createTableIfRequired(this);
        return Query.from(this, t);
    }

    <T> void createTable(Class<T> clazz) {
        this.define(clazz).createTableIfRequired(this);
    }

    <T> TableDefinition<T> define(Class<T> clazz) {
        TableDefinition<T> tableDefinition = this.getTableDefinition(clazz);
        if (tableDefinition == null) {
            tableDefinition = new TableDefinition<T>(clazz);
            tableDefinition.mapFields();
            this.classMap.put(clazz, tableDefinition);
            if (Table.class.isAssignableFrom(clazz)) {
                T t = Db.instance(clazz);
                Table table = (Table)t;
                Define.define(tableDefinition, table);
            }
        }
        return tableDefinition;
    }

    public void close() {
        try {
            this.conn.close();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public <A> TestCondition<A> test(A a) {
        return new TestCondition<A>(a);
    }

    public <T> void insertAll(List<T> list) {
        for (T t : list) {
            this.insert(t);
        }
    }

    PreparedStatement prepare(String string) {
        try {
            return this.conn.prepareStatement(string);
        }
        catch (SQLException sQLException) {
            throw new RuntimeException(sQLException);
        }
    }

    <T> TableDefinition<T> getTableDefinition(Class<T> clazz) {
        return this.classMap.get(clazz);
    }

    public ResultSet executeQuery(String string) {
        try {
            return this.conn.createStatement().executeQuery(string);
        }
        catch (SQLException sQLException) {
            throw new RuntimeException(sQLException);
        }
    }

    public int executeUpdate(String string) {
        try {
            Statement statement = this.conn.createStatement();
            int n = statement.executeUpdate(string);
            statement.close();
            return n;
        }
        catch (SQLException sQLException) {
            throw new RuntimeException(sQLException);
        }
    }
}

