/*
 * Decompiled with CFR 0.152.
 */
package org.jaggeryjs.scriptengine.cache;

import java.util.HashMap;
import java.util.Map;
import org.jaggeryjs.scriptengine.cache.CachingContext;
import org.jaggeryjs.scriptengine.cache.ContextWrapper;
import org.jaggeryjs.scriptengine.cache.PackageWrapper;
import org.jaggeryjs.scriptengine.cache.ScriptCachingContext;

public class TenantWrapper {
    private Map<String, ContextWrapper> contexts = new HashMap<String, ContextWrapper>();

    public Map<String, ContextWrapper> getContexts() {
        return this.contexts;
    }

    public ContextWrapper getContext(String context) {
        return this.contexts.get(context);
    }

    public ContextWrapper getContext(ScriptCachingContext sctx) {
        return this.getContext(sctx.getContext());
    }

    public PackageWrapper getPath(String context, String path) {
        ContextWrapper ctxWrapper = this.getContext(context);
        if (ctxWrapper == null) {
            return null;
        }
        return ctxWrapper.getPackage(path);
    }

    public PackageWrapper getPath(ScriptCachingContext sctx) {
        return this.getPath(sctx.getContext(), sctx.getPath());
    }

    public CachingContext getCachingContext(String context, String path, String cachingKey) {
        PackageWrapper packageWrapper = this.getPath(context, path);
        if (packageWrapper == null) {
            return null;
        }
        return packageWrapper.getCachingContext(cachingKey);
    }

    public CachingContext getCachingContext(ScriptCachingContext sctx) {
        return this.getCachingContext(sctx.getContext(), sctx.getPath(), sctx.getCacheKey());
    }

    public void removeContext(String context) {
        this.contexts.remove(context);
    }

    public void removePath(String context, String path) {
        ContextWrapper ctxWrapper = this.getContext(context);
        if (ctxWrapper == null) {
            return;
        }
        ctxWrapper.removePackage(path);
        if (ctxWrapper.getPathCount() == 0) {
            this.removeContext(context);
        }
    }

    public void removePath(ScriptCachingContext sctx) {
        this.removePath(sctx.getContext(), sctx.getPath());
    }

    public void removeCachingContext(String context, String path, String cachingKey) {
        ContextWrapper ctxWrapper = this.getContext(context);
        if (ctxWrapper == null) {
            return;
        }
        ctxWrapper.removeCachingContext(path, cachingKey);
        if (ctxWrapper.getPathCount() == 0) {
            this.removeContext(context);
        }
    }

    public void removeCachingContext(ScriptCachingContext sctx) {
        this.removeCachingContext(sctx.getContext(), sctx.getPath(), sctx.getCacheKey());
    }

    public void setContext(String context, ContextWrapper ctxWrapper) {
        this.contexts.put(context, ctxWrapper);
    }

    public void setContext(ScriptCachingContext sctx, ContextWrapper ctxWrapper) {
        this.setContext(sctx.getContext(), ctxWrapper);
    }

    public void setPath(String context, String path, PackageWrapper packageWrapper) {
        ContextWrapper ctxWrapper = this.getContext(context);
        if (ctxWrapper == null) {
            ctxWrapper = this.createContext(context);
        }
        ctxWrapper.setPackage(path, packageWrapper);
    }

    public void setPath(ScriptCachingContext sctx, PackageWrapper packageWrapper) {
        this.setPath(sctx.getContext(), sctx.getPath(), packageWrapper);
    }

    public void setCachingContext(String context, String path, String cacheKey, CachingContext ctx) {
        ContextWrapper ctxWrapper = this.getContext(context);
        if (ctxWrapper == null) {
            ctxWrapper = this.createContext(context);
        }
        ctxWrapper.setCachingContext(path, cacheKey, ctx);
    }

    public void setCachingContext(CachingContext ctx) {
        this.setCachingContext(ctx.getContext(), ctx.getPath(), ctx.getCacheKey(), ctx);
    }

    private ContextWrapper createContext(String context) {
        ContextWrapper ctxWrapper = new ContextWrapper(context);
        this.setContext(context, ctxWrapper);
        return ctxWrapper;
    }
}

