/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.internal.repository.tools;

import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.artifact.repository.CompositeArtifactRepository;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.internal.repository.tools.Messages;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.repository.artifact.ArtifactKeyQuery;
import org.eclipse.equinox.p2.repository.artifact.IArtifactDescriptor;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.equinox.p2.repository.tools.comparator.ArtifactComparatorFactory;
import org.eclipse.equinox.p2.repository.tools.comparator.IArtifactComparator;

public class ArtifactRepositoryValidator {
    private IArtifactComparator comparator;

    public ArtifactRepositoryValidator(String comparatorId) throws ProvisionException {
        this.comparator = ArtifactComparatorFactory.getArtifactComparator(comparatorId);
        if (comparatorId == null) {
            throw new ProvisionException(Messages.invalidComparatorId);
        }
    }

    public IStatus validateRepository(IArtifactRepository repository) {
        if (repository instanceof CompositeArtifactRepository) {
            return this.validateComposite((CompositeArtifactRepository)repository);
        }
        IQueryResult queryResult = repository.query((IQuery)ArtifactKeyQuery.ALL_KEYS, (IProgressMonitor)new NullProgressMonitor());
        Iterator iterator = queryResult.iterator();
        while (iterator.hasNext()) {
            IArtifactDescriptor[] descriptors = repository.getArtifactDescriptors((IArtifactKey)iterator.next());
            int i = 0;
            while (i < descriptors.length - 2) {
                IStatus compareResult = this.comparator.compare(repository, descriptors[i], repository, descriptors[i + 1]);
                if (!compareResult.isOK()) {
                    return compareResult;
                }
                ++i;
            }
        }
        return Status.OK_STATUS;
    }

    public IStatus validateComposite(CompositeArtifactRepository repository) {
        List repos = repository.getLoadedChildren();
        IQueryResult queryResult = repository.query((IQuery)ArtifactKeyQuery.ALL_KEYS, (IProgressMonitor)new NullProgressMonitor());
        Iterator iterator = queryResult.iterator();
        while (iterator.hasNext()) {
            IArtifactKey key = (IArtifactKey)iterator.next();
            IArtifactRepository firstRepo = null;
            Iterator iterator2 = repos.iterator();
            while (iterator2.hasNext()) {
                IArtifactDescriptor[] d2;
                IArtifactRepository child = (IArtifactRepository)iterator2.next();
                if (!child.contains(key)) continue;
                if (firstRepo == null) {
                    firstRepo = child;
                    continue;
                }
                IArtifactDescriptor[] d1 = firstRepo.getArtifactDescriptors(key);
                IStatus compareResult = this.comparator.compare(firstRepo, d1[0], child, (d2 = child.getArtifactDescriptors(key))[0]);
                if (compareResult.isOK()) continue;
                return compareResult;
            }
        }
        return Status.OK_STATUS;
    }

    public IStatus validateComposite(CompositeArtifactRepository composite, IArtifactRepository repository) {
        IQueryResult queryResult = repository.query((IQuery)ArtifactKeyQuery.ALL_KEYS, (IProgressMonitor)new NullProgressMonitor());
        Iterator iterator = queryResult.iterator();
        while (iterator.hasNext()) {
            IArtifactDescriptor[] d2;
            IArtifactDescriptor[] d1;
            IStatus compareResult;
            IArtifactKey key = (IArtifactKey)iterator.next();
            if (!composite.contains(key) || (compareResult = this.comparator.compare((IArtifactRepository)composite, (d1 = composite.getArtifactDescriptors(key))[0], repository, (d2 = repository.getArtifactDescriptors(key))[0])).isOK()) continue;
            return compareResult;
        }
        return Status.OK_STATUS;
    }
}

