/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.coordination.server.internal;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.service.component.ComponentContext;
import org.wso2.carbon.coordination.server.CoordinationServer;
import org.wso2.carbon.coordination.server.internal.CoordinationServerConfigHolder;
import org.wso2.carbon.coordination.server.service.CoordinationServerService;
import org.wso2.carbon.coordination.server.service.CoordinationServerServiceImpl;
import org.wso2.carbon.utils.CarbonUtils;

public class CoordinationServerDSComponent {
    private Log log = LogFactory.getLog(CoordinationServerDSComponent.class);
    private CoordinationServer server;
    public static String START_ZOOKEEPER_SERVER = "start_zk_server";

    public CoordinationServer getServer() {
        return this.server;
    }

    protected void activate(ComponentContext ctx) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Starting Coordination component initialization..");
        }
        try {
            if (this.getServer() == null) {
                String configPath = CarbonUtils.getCarbonConfigDirPath() + File.separator + "etc" + File.separator + "zoo.cfg";
                Properties properties = new Properties();
                byte[] configFileData = CarbonUtils.getBytesFromFile((File)new File(configPath));
                properties.load(new ByteArrayInputStream(configFileData));
                this.server = new CoordinationServer(new String(configFileData));
                CoordinationServerConfigHolder.getCoordinationServerConfigHolder().setCoordinationServer(this.server);
                CoordinationServerConfigHolder.getCoordinationServerConfigHolder().setConfigProperties(properties);
                CoordinationServerServiceImpl coordinationServerService = new CoordinationServerServiceImpl();
                ctx.getBundleContext().registerService(CoordinationServerService.class.getName(), (Object)coordinationServerService, null);
                if (properties.get(START_ZOOKEEPER_SERVER) == null || "true".equals(properties.get(START_ZOOKEEPER_SERVER))) {
                    this.server.start();
                }
            }
        }
        catch (Exception e) {
            this.log.error((Object)("Error while initializing Coordination component: " + e.getMessage()), (Throwable)e);
        }
    }

    protected void deactivate(ComponentContext ctx) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Coordination component deactivated");
        }
    }
}

