/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.coordination.core.sync.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.Stat;
import org.wso2.carbon.coordination.common.CoordinationException;
import org.wso2.carbon.coordination.core.services.impl.ZKCoordinationService;
import org.wso2.carbon.coordination.core.sync.Group;
import org.wso2.carbon.coordination.core.sync.GroupEventListener;
import org.wso2.carbon.coordination.core.sync.impl.ZKSyncPrimitive;
import org.wso2.carbon.coordination.core.utils.CoordinationUtils;

public class ZKGroup
extends ZKSyncPrimitive
implements Group {
    private static final Log log = LogFactory.getLog(ZKGroup.class);
    public static final String COMM_BASE_NAME = "__COMM__";
    public static final String GROUP_COMM_NODE_ID = "__COMM__/GROUP_COMMUNICATION";
    public static final String PEER_RESULTS_BASE_NAME = "__COMM__/PEER_RESULTS";
    public static final String PEER_REQUESTS_BASE_NAME = "__COMM__/PEER_REQUESTS";
    private GroupEventListener groupEventListener;
    private String memberPath;
    private String memberId;
    private List<String> lastProcessedMemberIds;
    private String leaderId;
    private boolean active;
    private CommunicationChannel groupCommChannel;
    private CommunicationChannel myRequestChannel;
    private Map<String, CommunicationChannel> peerRequestChannels;
    private static Marshaller peerRequestMarshaller;
    private static Marshaller peerResponseMarshaller;
    private static Unmarshaller peerRequestUnmarshaller;
    private static Unmarshaller peerResponseUnmarshaller;
    private Object memberArrivalCountLock = new Object();

    public ZKGroup(ZooKeeper zooKeeper, String groupId) throws CoordinationException {
        super(zooKeeper, ZKGroup.class.getCanonicalName(), groupId, -1);
        this.lastProcessedMemberIds = new ArrayList<String>();
        this.initMessageSerializers();
        this.peerRequestChannels = new HashMap<String, CommunicationChannel>();
        this.initGroupCommChannel();
        this.initPeerResults();
        this.join(this.getGroupId());
        this.initMyRequestCommChannel();
        this.active = true;
    }

    private void initMessageSerializers() throws CoordinationException {
        try {
            if (peerRequestMarshaller == null || peerRequestUnmarshaller == null || peerResponseMarshaller == null || peerRequestUnmarshaller == null) {
                JAXBContext requestCtx = JAXBContext.newInstance((Class[])new Class[]{PeerRequestMessage.class});
                JAXBContext responseCtx = JAXBContext.newInstance((Class[])new Class[]{PeerResponseMessage.class});
                peerRequestMarshaller = requestCtx.createMarshaller();
                peerRequestUnmarshaller = requestCtx.createUnmarshaller();
                peerResponseMarshaller = responseCtx.createMarshaller();
                peerResponseUnmarshaller = responseCtx.createUnmarshaller();
            }
        }
        catch (JAXBException e) {
            throw new CoordinationException("Error in initializing peer message serializers", CoordinationException.ExceptionCode.GENERIC_ERROR, (Exception)((Object)e));
        }
    }

    public static Marshaller getPeerRequestMarshaller() {
        return peerRequestMarshaller;
    }

    public static Marshaller getPeerResponseMarshaller() {
        return peerResponseMarshaller;
    }

    public static Unmarshaller getPeerRequestUnmarshaller() {
        return peerRequestUnmarshaller;
    }

    public static Unmarshaller getPeerResponseUnmarshaller() {
        return peerResponseUnmarshaller;
    }

    public Map<String, CommunicationChannel> getPeerRequestChannels() {
        return this.peerRequestChannels;
    }

    private CommunicationChannel createRequestChannelForPeer(String peerId) throws CoordinationException {
        return new CommunicationChannel(this.getRootPath() + "/" + PEER_REQUESTS_BASE_NAME + "/" + peerId, 1, false);
    }

    public CommunicationChannel retrievePeerRequestChannel(String peerId) throws CoordinationException {
        CommunicationChannel channel = this.getPeerRequestChannels().get(peerId);
        if (channel == null) {
            channel = this.createRequestChannelForPeer(peerId);
            this.getPeerRequestChannels().put(peerId, channel);
        }
        return channel;
    }

    public CommunicationChannel getGroupCommChannel() {
        return this.groupCommChannel;
    }

    public CommunicationChannel getMyRequestChannel() {
        return this.myRequestChannel;
    }

    private void initGroupCommChannel() throws CoordinationException {
        this.groupCommChannel = new CommunicationChannel(this.getRootPath() + "/" + GROUP_COMM_NODE_ID, 0, true);
    }

    private void initPeerResults() throws CoordinationException {
        this.createRecursive(this.getRootPath() + "/" + PEER_RESULTS_BASE_NAME);
    }

    private void initMyRequestCommChannel() throws CoordinationException {
        this.myRequestChannel = new CommunicationChannel(this.getRootPath() + "/" + PEER_REQUESTS_BASE_NAME + "/" + this.getMemberId(), 1, true);
        ZKCoordinationService.scheduleOnCloseZNodeDeletion(this.getMyRequestChannel().getCommRootPath());
    }

    public boolean isActive() {
        return this.active;
    }

    private void setActive(boolean active) {
        this.active = active;
    }

    public String getMemberPath() {
        return this.memberPath;
    }

    private void join(String groupId) throws CoordinationException {
        try {
            this.memberPath = this.getZooKeeper().create(this.getRootPath() + "/node", new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL_SEQUENTIAL);
            this.memberId = this.getMemberPath().substring(this.getMemberPath().lastIndexOf("/") + 1);
            this.processMemberNodes();
        }
        catch (CoordinationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CoordinationException(CoordinationException.ExceptionCode.GENERIC_ERROR, e);
        }
    }

    @Override
    public List<String> getMemberIds() throws CoordinationException {
        return this.lookupMemberIds(false);
    }

    public List<String> getLastProcessedMemberIds() {
        return this.lastProcessedMemberIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processMemberNodes() throws CoordinationException {
        List<String> oldMembers = this.getLastProcessedMemberIds();
        String oldLeaderId = this.getLeaderId();
        try {
            List<String> newMembers = this.lookupMemberIds(true);
            this.lastProcessedMemberIds = newMembers;
            this.processArrivals(oldMembers);
            this.processDepartures(oldMembers);
            this.processLeader(oldLeaderId);
            Object object = this.memberArrivalCountLock;
            synchronized (object) {
                this.memberArrivalCountLock.notifyAll();
            }
        }
        catch (Exception e) {
            throw new CoordinationException(CoordinationException.ExceptionCode.GENERIC_ERROR, e);
        }
    }

    private void processLeader(String oldLeaderId) throws CoordinationException {
        this.leaderId = this.getMemberIds().get(0);
        if (!this.leaderId.equals(oldLeaderId) && this.getGroupEventListener() != null) {
            this.getGroupEventListener().onLeaderChange(this.getLeaderId());
        }
    }

    private void processArrivals(List<String> oldMembers) throws CoordinationException {
        ArrayList<String> arrivedMembers = new ArrayList<String>(this.getMemberIds());
        if (oldMembers != null) {
            arrivedMembers.removeAll(oldMembers);
        }
        if (this.getGroupEventListener() != null) {
            for (String mid : arrivedMembers) {
                this.getGroupEventListener().onMemberArrival(mid);
            }
        }
    }

    private void processDepartures(List<String> oldMembers) throws CoordinationException {
        if (oldMembers == null) {
            return;
        }
        ArrayList<String> departedMembers = new ArrayList<String>(oldMembers);
        departedMembers.removeAll(this.getMemberIds());
        if (this.getGroupEventListener() != null) {
            for (String mid : departedMembers) {
                this.getGroupEventListener().onMemberDeparture(mid);
            }
        }
    }

    private String getPathFromMemberId(String memberId) {
        return this.getRootPath() + "/" + memberId;
    }

    @Override
    public String getLeaderId() {
        return this.leaderId;
    }

    @Override
    public void broadcast(byte[] data) throws CoordinationException {
        this.getGroupCommChannel().sendMessage(data);
    }

    @Override
    public byte[] sendReceive(String targetMemberId, byte[] data) throws CoordinationException {
        if (targetMemberId.equals(this.getMemberId())) {
            GroupEventListener listener = this.getGroupEventListener();
            if (listener == null) {
                throw new CoordinationException("No group event listener registerd to handle sendReceive");
            }
            return listener.onPeerMessage(data);
        }
        PeerRequestMessage msg = new PeerRequestMessage();
        String correlationId = UUID.randomUUID().toString();
        msg.setCorrelationId(correlationId);
        msg.setData(data);
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        try {
            ZKGroup.getPeerRequestMarshaller().marshal((Object)msg, (OutputStream)byteOut);
        }
        catch (JAXBException e) {
            throw new CoordinationException("Error in marshalling the peer request message", CoordinationException.ExceptionCode.GENERIC_ERROR, (Exception)((Object)e));
        }
        this.retrievePeerRequestChannel(targetMemberId).sendMessage(byteOut.toByteArray());
        String resultNodePath = this.getRootPath() + "/" + PEER_RESULTS_BASE_NAME + "/" + correlationId;
        String targetMemberPath = this.getPathFromMemberId(targetMemberId);
        try {
            PollingDataNode dataNode = new PollingDataNode(resultNodePath, targetMemberPath);
            if (dataNode.waitForData()) {
                return this.processDataNodeReply(dataNode.getData());
            }
            throw new CoordinationException("sendReceive failed in retrieving a reply from member with id: " + targetMemberId);
        }
        catch (Exception e) {
            throw new CoordinationException("Error in retrieving data from polling data node", CoordinationException.ExceptionCode.GENERIC_ERROR, e);
        }
    }

    private byte[] processDataNodeReply(byte[] data) throws CoordinationException {
        PeerResponseMessage responseMsg;
        ByteArrayInputStream byteIn = new ByteArrayInputStream(data);
        try {
            responseMsg = (PeerResponseMessage)ZKGroup.getPeerResponseUnmarshaller().unmarshal((InputStream)byteIn);
        }
        catch (JAXBException e) {
            throw new CoordinationException("Error in unmarshalling peer response message: " + e.getMessage(), CoordinationException.ExceptionCode.GENERIC_ERROR, (Exception)((Object)e));
        }
        if (!responseMsg.isSuccess()) {
            throw new CoordinationException("Error occured in target peer processing: " + responseMsg.getMessage(), CoordinationException.ExceptionCode.GENERIC_ERROR);
        }
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        for (String msgId : responseMsg.getMessageIds()) {
            try {
                byteOut.write(this.retrieveResultData(msgId));
            }
            catch (IOException e) {
                throw new CoordinationException("Error creating result buffer: " + e.getMessage(), CoordinationException.ExceptionCode.GENERIC_ERROR, (Exception)e);
            }
        }
        return byteOut.toByteArray();
    }

    private byte[] retrieveResultData(String id) throws CoordinationException {
        String path = this.getRootPath() + "/" + PEER_RESULTS_BASE_NAME + "/" + id;
        byte[] data = null;
        try {
            data = this.getZooKeeper().getData(path, false, null);
        }
        catch (KeeperException e) {
            throw new CoordinationException("Coordination error in retrieving peer result data", CoordinationException.ExceptionCode.GENERIC_ERROR, (Exception)((Object)e));
        }
        catch (Exception e) {
            throw new CoordinationException("Unknown error in retrieving peer result data", CoordinationException.ExceptionCode.GENERIC_ERROR, e);
        }
        try {
            this.getZooKeeper().delete(path, -1);
        }
        catch (Exception ignore) {
            // empty catch block
        }
        return data;
    }

    @Override
    public void leave() throws CoordinationException {
        this.setActive(false);
        try {
            this.getZooKeeper().delete(this.getMemberPath(), -1);
        }
        catch (Exception e) {
            throw new CoordinationException(CoordinationException.ExceptionCode.GENERIC_ERROR, e);
        }
    }

    @Override
    public GroupEventListener getGroupEventListener() {
        return this.groupEventListener;
    }

    @Override
    public void setGroupEventListener(GroupEventListener groupEventListener) {
        this.groupEventListener = groupEventListener;
    }

    @Override
    public String getMemberId() {
        return this.memberId;
    }

    @Override
    public String getGroupId() {
        return this.getId();
    }

    private boolean isCommPath(String path) {
        return path.startsWith(COMM_BASE_NAME);
    }

    @Override
    public void process(WatchedEvent event) {
        if (!this.isActive()) {
            return;
        }
        if (!this.isUsefulWatchedEvent(event)) {
            return;
        }
        String path = event.getPath();
        if (!this.isCommPath(path)) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    block2: {
                        try {
                            ZKGroup.this.processMemberNodes();
                        }
                        catch (Exception e) {
                            if (CoordinationUtils.isJVMShuttingDown()) break block2;
                            log.error((Object)("Error in processing WatchedEvent: " + e.getMessage()), (Throwable)e);
                        }
                    }
                }
            }).start();
        }
    }

    private List<String> lookupMemberIds(boolean notify) throws CoordinationException {
        try {
            ArrayList<String> ids = new ArrayList<String>();
            List childPaths = notify ? this.getZooKeeper().getChildren(this.getRootPath(), (Watcher)this) : this.getZooKeeper().getChildren(this.getRootPath(), false);
            for (String path : childPaths) {
                String tmpId = path.substring(path.lastIndexOf("/") + 1);
                if (tmpId.equals(COMM_BASE_NAME)) continue;
                ids.add(tmpId);
            }
            Collections.sort(ids);
            return ids;
        }
        catch (Exception e) {
            throw new CoordinationException(CoordinationException.ExceptionCode.GENERIC_ERROR, e);
        }
    }

    @Override
    public void clearGroupMessages() throws CoordinationException {
        this.getGroupCommChannel().clearMessages();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void waitForMemberCount(int count) throws CoordinationException {
        Object object = this.memberArrivalCountLock;
        synchronized (object) {
            while (this.getMemberIds().size() < count) {
                try {
                    this.memberArrivalCountLock.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    public class PollingDataNode
    implements Watcher {
        public static final int TOTAL_TIMEOUT = 120000;
        public static final int CHECK_ALIVE_TIMEOUT = 5000;
        private Object lock = new Object();
        private byte[] data;
        private boolean ready;
        private String dataPath;
        private String testPath;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public PollingDataNode(String dataPath, String testPath) throws Exception {
            this.dataPath = dataPath;
            this.testPath = testPath;
            Stat stat = ZKGroup.this.getZooKeeper().exists(this.getDataPath(), (Watcher)this);
            if (stat != null) {
                try {
                    this.data = ZKGroup.this.getZooKeeper().getData(dataPath, false, null);
                    this.ready = true;
                }
                finally {
                    try {
                        ZKGroup.this.getZooKeeper().delete(dataPath, -1);
                    }
                    catch (Exception ignore) {}
                }
            }
        }

        public String getDataPath() {
            return this.dataPath;
        }

        public String getTestPath() {
            return this.testPath;
        }

        public byte[] getData() {
            return this.data;
        }

        public boolean checkTestPath() {
            if (this.getTestPath() != null) {
                try {
                    return ZKGroup.this.getZooKeeper().exists(this.getTestPath(), false) != null;
                }
                catch (Exception e) {
                    return false;
                }
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean waitForData() throws Exception {
            int totalTime = 0;
            do {
                Object object = this.lock;
                synchronized (object) {
                    if (this.isReady()) {
                        return true;
                    }
                    this.lock.wait(5000L);
                    if (this.isReady()) {
                        return true;
                    }
                    if (!this.checkTestPath()) {
                        return false;
                    }
                }
            } while ((totalTime += 5000) <= 120000);
            this.cleanupDataNode();
            return false;
        }

        private void cleanupDataNode() {
            try {
                ZKGroup.this.getZooKeeper().create(this.getDataPath(), new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL);
            }
            catch (Exception ignore) {
                // empty catch block
            }
            try {
                ZKGroup.this.getZooKeeper().delete(this.getDataPath(), -1);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public boolean isReady() {
            return this.ready;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void process(WatchedEvent event) {
            if (!ZKGroup.this.isUsefulWatchedEvent(event)) {
                return;
            }
            Object object = this.lock;
            synchronized (object) {
                try {
                    this.data = ZKGroup.this.getZooKeeper().getData(this.getDataPath(), false, null);
                    ZKGroup.this.getZooKeeper().delete(this.dataPath, -1);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.ready = true;
                this.lock.notifyAll();
            }
        }
    }

    @XmlRootElement(name="peerResponseMessage")
    public static class PeerResponseMessage {
        private boolean success = true;
        private String message;
        private String[] messageIds;

        public String[] getMessageIds() {
            return this.messageIds;
        }

        public void setMessageIds(String[] messageIds) {
            this.messageIds = messageIds;
        }

        public boolean isSuccess() {
            return this.success;
        }

        public void setSuccess(boolean success) {
            this.success = success;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }
    }

    @XmlRootElement(name="peerRequestMessage")
    public static class PeerRequestMessage {
        private String correlationId;
        private byte[] data;

        public String getCorrelationId() {
            return this.correlationId;
        }

        public void setCorrelationId(String correlationId) {
            this.correlationId = correlationId;
        }

        public byte[] getData() {
            return this.data;
        }

        public void setData(byte[] data) {
            this.data = data;
        }
    }

    private class CommunicationChannel
    implements Watcher {
        public static final int CHANNEL_TYPE_BROADCAST = 0;
        public static final int CHANNEL_TYPE_PEER = 1;
        private String commRootPath;
        private String lastProcessedMessageId;
        private int channelType;
        private boolean incoming;

        public CommunicationChannel(String commRootPath, int channelType, boolean incoming) throws CoordinationException {
            this.commRootPath = commRootPath;
            this.channelType = channelType;
            this.incoming = incoming;
            ZKGroup.this.createRecursive(this.getCommRootPath());
            try {
                if (this.isIncoming()) {
                    ZKGroup.this.getZooKeeper().getData(this.getCommRootPath(), (Watcher)this, null);
                }
            }
            catch (Exception e) {
                throw new CoordinationException(CoordinationException.ExceptionCode.GENERIC_ERROR, e);
            }
        }

        public boolean isIncoming() {
            return this.incoming;
        }

        public int getChannelType() {
            return this.channelType;
        }

        public String getCommRootPath() {
            return this.commRootPath;
        }

        private byte[] validateAndReturnDataFromId(String msgId) throws Exception {
            String path = this.getCommRootPath() + "/" + msgId;
            byte[] data = null;
            try {
                data = ZKGroup.this.getZooKeeper().getData(path, false, null);
                if (this.getChannelType() == 1) {
                    ZKGroup.this.getZooKeeper().delete(path, -1);
                }
                return data;
            }
            catch (KeeperException e) {
                if (e.code() == KeeperException.Code.NONODE) {
                    return data;
                }
                throw e;
            }
        }

        private byte[] getNextMessage() throws Exception {
            List msgPaths = ZKGroup.this.getZooKeeper().getChildren(this.getCommRootPath(), false);
            Collections.sort(msgPaths);
            if (this.lastProcessedMessageId == null) {
                if (msgPaths.size() > 0) {
                    this.lastProcessedMessageId = (String)msgPaths.get(msgPaths.size() - 1);
                    return this.validateAndReturnDataFromId(this.lastProcessedMessageId);
                }
                return null;
            }
            for (String path : msgPaths) {
                if (path.compareTo(this.lastProcessedMessageId) <= 0) continue;
                this.lastProcessedMessageId = path;
                return this.validateAndReturnDataFromId(this.lastProcessedMessageId);
            }
            return null;
        }

        private void processMessageData(byte[] msgData) throws Exception {
            if (this.getChannelType() == 0) {
                this.handleBroadcastMessage(msgData);
            } else if (this.getChannelType() == 1) {
                this.handlePeerMessage(msgData);
            }
        }

        private void handleBroadcastMessage(byte[] data) {
            GroupEventListener listener = ZKGroup.this.getGroupEventListener();
            if (listener != null) {
                listener.onGroupMessage(data);
            }
        }

        private void handlePeerMessage(byte[] data) {
            block7: {
                String correlationId = null;
                try {
                    PeerRequestMessage requestMsg;
                    GroupEventListener listener = ZKGroup.this.getGroupEventListener();
                    if (listener == null) {
                        throw new CoordinationException("No listener registered for peer requests");
                    }
                    ByteArrayInputStream byteIn = new ByteArrayInputStream(data);
                    try {
                        requestMsg = (PeerRequestMessage)ZKGroup.getPeerRequestUnmarshaller().unmarshal((InputStream)byteIn);
                    }
                    catch (JAXBException e) {
                        throw new CoordinationException("Error in unmarshalling peer message", CoordinationException.ExceptionCode.GENERIC_ERROR, (Exception)((Object)e));
                    }
                    correlationId = requestMsg.getCorrelationId();
                    byte[] requestData = requestMsg.getData();
                    byte[] responseData = listener.onPeerMessage(requestData);
                    List<String> dataNodeIds = this.createResultDataNodesFromData(responseData);
                    PeerResponseMessage responseMsg = new PeerResponseMessage();
                    responseMsg.setMessageIds(dataNodeIds.toArray(new String[dataNodeIds.size()]));
                    responseMsg.setSuccess(true);
                    this.createResultDataNode(correlationId, this.marshalPeerResponse(responseMsg));
                }
                catch (Exception e) {
                    if (correlationId == null) break block7;
                    PeerResponseMessage responseMsg = new PeerResponseMessage();
                    responseMsg.setSuccess(false);
                    responseMsg.setMessage(e.getMessage());
                    try {
                        this.createResultDataNode(correlationId, this.marshalPeerResponse(responseMsg));
                    }
                    catch (Exception e2) {
                        log.error((Object)("Error in creating peer error result node: " + e2.getMessage()), (Throwable)e2);
                    }
                }
            }
        }

        private byte[] marshalPeerResponse(PeerResponseMessage responseMsg) throws Exception {
            ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
            ZKGroup.getPeerResponseMarshaller().marshal((Object)responseMsg, (OutputStream)byteOut);
            return byteOut.toByteArray();
        }

        private List<String> createResultDataNodesFromData(byte[] data) throws Exception {
            ArrayList<byte[]> dataList = new ArrayList<byte[]>();
            for (int i = 0; i < data.length; i += 819200) {
                byte[] tmpBuff = Arrays.copyOfRange(data, i, Math.min(data.length, i + 819200));
                dataList.add(tmpBuff);
            }
            ArrayList<String> idList = new ArrayList<String>();
            for (byte[] buff : dataList) {
                String tmpId = UUID.randomUUID().toString();
                this.createResultDataNode(tmpId, buff);
                idList.add(tmpId);
            }
            return idList;
        }

        private void createResultDataNode(String id, byte[] data) throws Exception {
            String path = ZKGroup.this.getZooKeeper().create(ZKGroup.this.getRootPath() + "/" + ZKGroup.PEER_RESULTS_BASE_NAME + "/" + id, data, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL);
            ZKCoordinationService.scheduleTimedZNodeDeletion(path);
        }

        public void process(WatchedEvent event) {
            block4: {
                if (!ZKGroup.this.isUsefulWatchedEvent(event)) {
                    return;
                }
                try {
                    byte[] msgData;
                    ZKGroup.this.getZooKeeper().getData(this.getCommRootPath(), (Watcher)this, null);
                    while ((msgData = this.getNextMessage()) != null) {
                        this.processMessageData(msgData);
                    }
                }
                catch (Exception e) {
                    if (CoordinationUtils.isJVMShuttingDown()) break block4;
                    log.error((Object)("Error in receiving group messages: " + e.getMessage()), (Throwable)e);
                }
            }
        }

        public void sendMessage(byte[] data) throws CoordinationException {
            try {
                String path = ZKGroup.this.getZooKeeper().create(this.getCommRootPath() + "/node", data, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL_SEQUENTIAL);
                ZKCoordinationService.scheduleTimedZNodeDeletion(path);
                ZKGroup.this.getZooKeeper().setData(this.getCommRootPath(), new byte[0], -1);
            }
            catch (Exception e) {
                throw new CoordinationException(CoordinationException.ExceptionCode.GENERIC_ERROR, e);
            }
        }

        public void clearMessages() throws CoordinationException {
            List msgIds;
            try {
                msgIds = ZKGroup.this.getZooKeeper().getChildren(this.getCommRootPath(), false);
            }
            catch (Exception e) {
                throw new CoordinationException(CoordinationException.ExceptionCode.GENERIC_ERROR, e);
            }
            for (String id : msgIds) {
                try {
                    ZKGroup.this.getZooKeeper().delete(this.getCommRootPath() + "/" + id, -1);
                }
                catch (KeeperException e) {
                    if (e.code() == KeeperException.Code.NONODE) continue;
                    throw new CoordinationException(CoordinationException.ExceptionCode.GENERIC_ERROR, (Exception)((Object)e));
                }
                catch (Exception e) {
                    throw new CoordinationException(CoordinationException.ExceptionCode.GENERIC_ERROR, e);
                }
            }
        }
    }
}

