/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.tomcat.internal;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.catalina.LifecycleException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.wso2.carbon.tomcat.internal.CarbonTomcat;
import org.wso2.securevault.SecretResolver;
import org.wso2.securevault.SecretResolverFactory;
import org.wso2.securevault.secret.SecretManager;
import org.xml.sax.SAXException;

public class ServerManager {
    private static Log log = LogFactory.getLog(ServerManager.class);
    private static CarbonTomcat tomcat;
    private InputStream inputStream;
    private SecretResolver resolver;
    static ClassLoader bundleCtxtClassLoader;

    public void init() {
        bundleCtxtClassLoader = Thread.currentThread().getContextClassLoader();
        String carbonHome = System.getProperty("carbon.home");
        String catalinaHome = new File(carbonHome).getAbsolutePath() + File.separator + "lib" + File.separator + "tomcat";
        String catalinaXML = new File(carbonHome).getAbsolutePath() + File.separator + "repository" + File.separator + "conf" + File.separator + "tomcat" + File.separator + "catalina-server.xml";
        try {
            this.inputStream = new FileInputStream(new File(catalinaXML));
        }
        catch (FileNotFoundException e) {
            log.error((Object)"could not locate the file catalina-server.xml", (Throwable)e);
        }
        if (System.getProperty("catalina.base") == null) {
            System.setProperty("catalina.base", System.getProperty("carbon.home") + File.separator + "lib" + File.separator + "tomcat");
        }
        tomcat = new CarbonTomcat();
        if (SecretManager.getInstance().isInitialized()) {
            Element config = ServerManager.inputStreamToDOM(this.inputStream);
            this.resolver = SecretResolverFactory.create((Element)config, (boolean)true);
            this.resolveSecuredConfig(config, null);
            InputStream newStream = this.domToInputStream(config);
            tomcat.configure(catalinaHome, newStream);
        } else {
            tomcat.configure(catalinaHome, this.inputStream);
        }
    }

    public synchronized void start() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Thread.currentThread().setContextClassLoader(bundleCtxtClassLoader);
                try {
                    tomcat.start();
                }
                catch (LifecycleException e) {
                    log.error((Object)"tomcat life-cycle exception", (Throwable)e);
                }
            }
        }).start();
    }

    public void stop() {
        try {
            tomcat.stop();
        }
        catch (LifecycleException e) {
            log.error((Object)"Error while stopping tomcat", (Throwable)e);
        }
    }

    CarbonTomcat getTomcatInstance() {
        return tomcat;
    }

    private void resolveSecuredConfig(Node root, String tempToken) {
        String token = null;
        NamedNodeMap nodeMap = root.getAttributes();
        tempToken = tempToken == null ? root.getNodeName() : tempToken + "." + root.getNodeName();
        if (nodeMap != null) {
            for (int j = 0; j < nodeMap.getLength(); ++j) {
                Node node = nodeMap.item(j);
                if (node == null) continue;
                String attributeName = node.getNodeName();
                token = tempToken + "." + attributeName;
                if (!this.resolver.isTokenProtected(token)) continue;
                node.setNodeValue(this.resolver.resolve(token));
            }
        }
        NodeList nodeList = root.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            this.resolveSecuredConfig(nodeList.item(i), tempToken);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Element inputStreamToDOM(InputStream inputStream) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        Element element = null;
        try {
            DocumentBuilder docBuilder = factory.newDocumentBuilder();
            Document doc = docBuilder.parse(inputStream);
            element = doc.getDocumentElement();
        }
        catch (SAXException e) {
            log.error((Object)"Error while creating DOM element : ", (Throwable)e);
        }
        catch (IOException e) {
            log.error((Object)"Error while creating DOM element : ", (Throwable)e);
        }
        catch (ParserConfigurationException e) {
            log.error((Object)"Error while creating DOM element : ", (Throwable)e);
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException e) {
                log.error((Object)"Error while closing input stream : ", (Throwable)e);
            }
        }
        return element;
    }

    private InputStream domToInputStream(Element root) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        StreamResult outputTarget = new StreamResult(outputStream);
        try {
            Transformer t = TransformerFactory.newInstance().newTransformer();
            t.transform(new DOMSource(root), outputTarget);
            return new ByteArrayInputStream(outputStream.toByteArray());
        }
        catch (TransformerConfigurationException e) {
            log.error((Object)"Error while creating input stream : ", (Throwable)e);
        }
        catch (TransformerException e) {
            log.error((Object)"Error while creating input stream : ", (Throwable)e);
        }
        return null;
    }
}

