/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record.formula.eval;

import org.apache.poi.hssf.record.formula.eval.ErrorEval;
import org.apache.poi.hssf.record.formula.eval.EvaluationException;
import org.apache.poi.hssf.record.formula.eval.NumberEval;
import org.apache.poi.hssf.record.formula.eval.OperandResolver;
import org.apache.poi.hssf.record.formula.eval.ValueEval;
import org.apache.poi.hssf.record.formula.functions.Function;

public abstract class TwoOperandNumericOperation
implements Function {
    public static final Function AddEval = new TwoOperandNumericOperation(){

        protected double evaluate(double d0, double d1) {
            return d0 + d1;
        }
    };
    public static final Function DivideEval = new TwoOperandNumericOperation(){

        protected double evaluate(double d0, double d1) throws EvaluationException {
            if (d1 == 0.0) {
                throw new EvaluationException(ErrorEval.DIV_ZERO);
            }
            return d0 / d1;
        }
    };
    public static final Function MultiplyEval = new TwoOperandNumericOperation(){

        protected double evaluate(double d0, double d1) {
            return d0 * d1;
        }
    };
    public static final Function PowerEval = new TwoOperandNumericOperation(){

        protected double evaluate(double d0, double d1) {
            return Math.pow(d0, d1);
        }
    };
    public static final Function SubtractEval = new SubtractEvalClass();

    protected final double singleOperandEvaluate(ValueEval arg, int srcCellRow, int srcCellCol) throws EvaluationException {
        ValueEval ve = OperandResolver.getSingleValue(arg, srcCellRow, srcCellCol);
        return OperandResolver.coerceValueToDouble(ve);
    }

    public final ValueEval evaluate(ValueEval[] args, int srcCellRow, short srcCellCol) {
        double result;
        try {
            double d0 = this.singleOperandEvaluate(args[0], srcCellRow, srcCellCol);
            double d1 = this.singleOperandEvaluate(args[1], srcCellRow, srcCellCol);
            result = this.evaluate(d0, d1);
            if (result == 0.0 && !(this instanceof SubtractEvalClass)) {
                return NumberEval.ZERO;
            }
            if (Double.isNaN(result) || Double.isInfinite(result)) {
                return ErrorEval.NUM_ERROR;
            }
        }
        catch (EvaluationException e) {
            return e.getErrorEval();
        }
        return new NumberEval(result);
    }

    protected abstract double evaluate(double var1, double var3) throws EvaluationException;

    private static final class SubtractEvalClass
    extends TwoOperandNumericOperation {
        protected double evaluate(double d0, double d1) {
            return d0 - d1;
        }
    }
}

