/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analysis;

import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.StopAnalyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.solr.analysis.BaseTokenFilterFactory;
import org.apache.solr.analysis.CommonGramsFilter;
import org.apache.solr.common.ResourceLoader;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.util.plugin.ResourceLoaderAware;

public class CommonGramsFilterFactory
extends BaseTokenFilterFactory
implements ResourceLoaderAware {
    private CharArraySet commonWords;
    private boolean ignoreCase;

    public void inform(ResourceLoader loader) {
        String commonWordFiles = (String)this.args.get("words");
        this.ignoreCase = this.getBoolean("ignoreCase", false);
        if (commonWordFiles != null) {
            try {
                List<String> files = StrUtils.splitFileNames(commonWordFiles);
                if (this.commonWords == null && files.size() > 0) {
                    this.commonWords = new CharArraySet(files.size() * 10, this.ignoreCase);
                }
                for (String file : files) {
                    List<String> wlist = loader.getLines(file.trim());
                    this.commonWords.addAll(CommonGramsFilter.makeCommonSet(wlist.toArray(new String[0]), this.ignoreCase));
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        } else {
            this.commonWords = CommonGramsFilter.makeCommonSet(StopAnalyzer.ENGLISH_STOP_WORDS, this.ignoreCase);
        }
    }

    public boolean isIgnoreCase() {
        return this.ignoreCase;
    }

    public Set getCommonWords() {
        return this.commonWords;
    }

    public CommonGramsFilter create(TokenStream input) {
        CommonGramsFilter commonGrams = new CommonGramsFilter(input, this.commonWords, this.ignoreCase);
        return commonGrams;
    }
}

