/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.ntask.solutions.webservice;

import java.util.Map;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.client.ServiceClient;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.ntask.core.AbstractTask;
import org.wso2.carbon.ntask.solutions.webservice.ServicePayloadHandler;

public class WebServiceCallTask
extends AbstractTask {
    private static final Log log = LogFactory.getLog(WebServiceCallTask.class);
    public static final String SERVICE_TARGET_EPR = "SERVICE_TARGET_EPR";
    public static final String SERVICE_ACTION = "SERVICE_ACTION";
    public static final String SERVICE_PAYLOAD_HANDLER_CLASS = "SERVICE_PAYLOAD_HANDLER_CLASS";
    public static final String SERVICE_MEP = "SERVICE_MEP";
    public static final String SERVICE_MEP_IN_ONLY = "IN_ONLY";
    public static final String SERVICE_MEP_IN_OUT = "IN_OUT";
    private ServiceClient serviceClient;
    private String serviceURL;
    private String serviceAction;
    private String serviceMEP;
    private int taskCount;
    private ServicePayloadHandler servicePayloadHandler;

    public void init() {
        try {
            String servicePayloadHandlerClass;
            String epr;
            this.serviceClient = new ServiceClient();
            this.serviceClient.getOptions().setCallTransportCleanup(true);
            Map props = this.getProperties();
            String action = (String)props.get(SERVICE_ACTION);
            if (action != null) {
                this.getServiceClient().getOptions().setAction(action);
            }
            if ((epr = (String)props.get(SERVICE_TARGET_EPR)) != null) {
                this.getServiceClient().setTargetEPR(new EndpointReference(epr));
            }
            if ((servicePayloadHandlerClass = (String)props.get(SERVICE_PAYLOAD_HANDLER_CLASS)) != null) {
                this.servicePayloadHandler = (ServicePayloadHandler)Class.forName(servicePayloadHandlerClass).newInstance();
            }
            this.serviceMEP = (String)props.get(SERVICE_MEP);
            if (this.getServiceMEP() == null) {
                this.serviceMEP = SERVICE_MEP_IN_ONLY;
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error while initializing the web service call task", e);
        }
    }

    public String getServiceMEP() {
        return this.serviceMEP;
    }

    public ServicePayloadHandler getServicePayloadHandler() {
        return this.servicePayloadHandler;
    }

    public ServiceClient getServiceClient() {
        return this.serviceClient;
    }

    public String getServiceURL() {
        return this.serviceURL;
    }

    public String getServiceAction() {
        return this.serviceAction;
    }

    public int getTaskCount() {
        return this.taskCount;
    }

    private OMElement extractInputPayload() {
        OMElement payload = this.getServicePayloadHandler() != null ? this.getServicePayloadHandler().getInputPayload(this) : null;
        return payload;
    }

    public void execute() {
        try {
            OMElement payload = this.extractInputPayload();
            if (SERVICE_MEP_IN_OUT.equals(this.getServiceMEP())) {
                OMElement data = this.getServiceClient().sendReceive(payload);
                if (this.getServicePayloadHandler() != null) {
                    this.getServicePayloadHandler().handleServiceResult(this, data);
                }
            } else {
                this.getServiceClient().sendRobust(payload);
            }
            ++this.taskCount;
        }
        catch (Exception e) {
            log.error((Object)("Error in executing web service call task: " + e.getMessage()), (Throwable)e);
        }
    }
}

