/*
 * Decompiled with CFR 0.152.
 */
package org.h2.store.fs;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.SequenceInputStream;
import java.util.ArrayList;
import org.h2.constant.SysProperties;
import org.h2.message.DbException;
import org.h2.store.fs.FileObject;
import org.h2.store.fs.FileObjectSplit;
import org.h2.store.fs.FileSystem;
import org.h2.util.New;

public class FileSystemSplit
extends FileSystem {
    private static final String PREFIX = "split:";
    private static final String PART_SUFFIX = ".part";
    private long defaultMaxSize = 1L << (int)SysProperties.SPLIT_FILE_SIZE_SHIFT;

    @Override
    public boolean canWrite(String string) {
        string = this.translateFileName(string);
        return this.getFileSystem(string).canWrite(string);
    }

    @Override
    public boolean setReadOnly(String string) {
        String string2;
        string = this.translateFileName(string);
        boolean bl = false;
        int n = 0;
        while (this.getFileSystem(string2 = FileSystemSplit.getFileName(string, n)).exists(string2)) {
            bl = this.getFileSystem(string2).setReadOnly(string2);
            ++n;
        }
        return bl;
    }

    @Override
    public void copy(String string, String string2) {
        String string3;
        string = this.translateFileName(string);
        string2 = this.translateFileName(string2);
        this.getFileSystem(string).copy(string, string2);
        int n = 1;
        while (this.getFileSystem(string3 = FileSystemSplit.getFileName(string, n)).exists(string3)) {
            String string4 = FileSystemSplit.getFileName(string2, n);
            this.getFileSystem(string3).copy(string3, string4);
            ++n;
        }
    }

    @Override
    public void createDirs(String string) {
        string = this.translateFileName(string);
        this.getFileSystem(string).createDirs(string);
    }

    @Override
    public boolean createNewFile(String string) {
        string = this.translateFileName(string);
        return this.getFileSystem(string).createNewFile(string);
    }

    @Override
    public String createTempFile(String string, String string2, boolean bl, boolean bl2) throws IOException {
        string = this.translateFileName(string);
        return PREFIX + this.getFileSystem(string).createTempFile(string, string2, bl, bl2);
    }

    @Override
    public void delete(String string) {
        string = this.translateFileName(string);
        int n = 0;
        while (true) {
            String string2 = FileSystemSplit.getFileName(string, n);
            if (!this.getFileSystem(string).exists(string2)) break;
            this.getFileSystem(string).delete(string2);
            ++n;
        }
    }

    @Override
    public void deleteRecursive(String string, boolean bl) {
        string = this.translateFileName(string);
        this.getFileSystem(string).deleteRecursive(string, bl);
    }

    @Override
    public boolean exists(String string) {
        string = this.translateFileName(string);
        return this.getFileSystem(string).exists(string);
    }

    @Override
    public boolean fileStartsWith(String string, String string2) {
        string = this.translateFileName(string);
        string2 = this.translateFileName(string2);
        return this.getFileSystem(string).fileStartsWith(string, string2);
    }

    @Override
    public String getAbsolutePath(String string) {
        string = this.translateFileName(string);
        return PREFIX + this.getFileSystem(string).getAbsolutePath(string);
    }

    @Override
    public String getFileName(String string) {
        string = this.translateFileName(string);
        return this.getFileSystem(string).getFileName(string);
    }

    @Override
    public long getLastModified(String string) {
        string = this.translateFileName(string);
        long l = 0L;
        int n = 0;
        while (true) {
            String string2 = FileSystemSplit.getFileName(string, n);
            if (!this.getFileSystem(string).exists(string2)) break;
            long l2 = this.getFileSystem(string).getLastModified(string);
            l = Math.max(l, l2);
            ++n;
        }
        return l;
    }

    @Override
    public String getParent(String string) {
        string = this.translateFileName(string);
        return PREFIX + this.getFileSystem(string).getParent(string);
    }

    @Override
    public boolean isAbsolute(String string) {
        string = this.translateFileName(string);
        return this.getFileSystem(string).isAbsolute(string);
    }

    @Override
    public boolean isDirectory(String string) {
        string = this.translateFileName(string);
        return this.getFileSystem(string).isDirectory(string);
    }

    @Override
    public boolean isReadOnly(String string) {
        string = this.translateFileName(string);
        return this.getFileSystem(string).isReadOnly(string);
    }

    @Override
    public long length(String string) {
        string = this.translateFileName(string);
        long l = 0L;
        int n = 0;
        while (true) {
            String string2 = FileSystemSplit.getFileName(string, n);
            if (!this.getFileSystem(string).exists(string2)) break;
            l += this.getFileSystem(string).length(string2);
            ++n;
        }
        return l;
    }

    @Override
    public String[] listFiles(String string) {
        string = this.translateFileName(string);
        String[] stringArray = this.getFileSystem(string).listFiles(string);
        ArrayList<String> arrayList = New.arrayList();
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            if (string2.endsWith(PART_SUFFIX)) continue;
            stringArray[i] = string2 = PREFIX + string2;
            arrayList.add(string2);
        }
        if (arrayList.size() != stringArray.length) {
            stringArray = new String[arrayList.size()];
            arrayList.toArray(stringArray);
        }
        return stringArray;
    }

    @Override
    public String normalize(String string) {
        string = this.translateFileName(string);
        return PREFIX + this.getFileSystem(string).normalize(string);
    }

    @Override
    public InputStream openFileInputStream(String string) throws IOException {
        String string2;
        string = this.translateFileName(string);
        InputStream inputStream = this.getFileSystem(string).openFileInputStream(string);
        int n = 1;
        while (this.getFileSystem(string2 = FileSystemSplit.getFileName(string, n)).exists(string2)) {
            InputStream inputStream2 = this.getFileSystem(string2).openFileInputStream(string2);
            inputStream = new SequenceInputStream(inputStream, inputStream2);
            ++n;
        }
        return inputStream;
    }

    @Override
    public FileObject openFileObject(String string, String string2) throws IOException {
        long l;
        string = this.translateFileName(string);
        ArrayList<FileObject> arrayList = New.arrayList();
        FileObject fileObject = this.getFileSystem(string).openFileObject(string, string2);
        arrayList.add(fileObject);
        int n = 1;
        while (true) {
            String string3 = FileSystemSplit.getFileName(string, n);
            if (!this.getFileSystem(string).exists(string3)) break;
            fileObject = this.getFileSystem(string3).openFileObject(string3, string2);
            arrayList.add(fileObject);
            ++n;
        }
        FileObject[] fileObjectArray = new FileObject[arrayList.size()];
        arrayList.toArray(fileObjectArray);
        long l2 = l = fileObjectArray[0].length();
        if (fileObjectArray.length == 1) {
            if (l < this.defaultMaxSize) {
                l = this.defaultMaxSize;
            }
        } else {
            for (int i = 1; i < fileObjectArray.length - 1; ++i) {
                fileObject = fileObjectArray[i];
                long l3 = fileObject.length();
                l2 += l3;
                if (l3 == l) continue;
                throw new IOException("Expected file length: " + l + " got: " + l3 + " for " + fileObject.getName());
            }
            fileObject = fileObjectArray[fileObjectArray.length - 1];
            long l4 = fileObject.length();
            l2 += l4;
            if (l4 > l) {
                throw new IOException("Expected file length: " + l + " got: " + l4 + " for " + fileObject.getName());
            }
        }
        FileObjectSplit fileObjectSplit = new FileObjectSplit(string, string2, fileObjectArray, l2, l);
        return fileObjectSplit;
    }

    @Override
    public OutputStream openFileOutputStream(String string, boolean bl) {
        string = this.translateFileName(string);
        return this.getFileSystem(string).openFileOutputStream(string, bl);
    }

    @Override
    public void rename(String string, String string2) {
        String string3;
        string = this.translateFileName(string);
        string2 = this.translateFileName(string2);
        int n = 0;
        while (this.getFileSystem(string3 = FileSystemSplit.getFileName(string, n)).exists(string3)) {
            String string4 = FileSystemSplit.getFileName(string2, n);
            this.getFileSystem(string4).rename(string3, string4);
            ++n;
        }
    }

    @Override
    public boolean tryDelete(String string) {
        string = this.translateFileName(string);
        int n = 0;
        while (true) {
            String string2 = FileSystemSplit.getFileName(string, n);
            if (!this.getFileSystem(string).exists(string2)) break;
            boolean bl = this.getFileSystem(string).tryDelete(string2);
            if (!bl) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private String translateFileName(String string) {
        if (!string.startsWith(PREFIX)) {
            DbException.throwInternalError(string + " doesn't start with " + PREFIX);
        }
        if ((string = string.substring(PREFIX.length())).length() > 0 && Character.isDigit(string.charAt(0))) {
            int n = string.indexOf(58);
            String string2 = string.substring(0, n);
            try {
                this.defaultMaxSize = 1L << Integer.decode(string2);
                string = string.substring(n + 1);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return string;
    }

    static String getFileName(String string, int n) {
        if (n > 0) {
            string = string + "." + n + PART_SUFFIX;
        }
        return string;
    }

    private FileSystem getFileSystem(String string) {
        return FileSystem.getInstance(string);
    }

    @Override
    protected boolean accepts(String string) {
        return string.startsWith(PREFIX);
    }

    static {
        FileSystem.register(new FileSystemSplit());
    }
}

