/*
 * Decompiled with CFR 0.152.
 */
package org.h2.index;

import java.lang.ref.SoftReference;
import java.util.Arrays;
import org.h2.constant.SysProperties;
import org.h2.engine.Session;
import org.h2.index.Cursor;
import org.h2.index.PageData;
import org.h2.index.PageDataCursor;
import org.h2.index.PageDataIndex;
import org.h2.index.PageDataNode;
import org.h2.index.PageDataOverflow;
import org.h2.message.DbException;
import org.h2.result.Row;
import org.h2.store.Data;
import org.h2.store.Page;
import org.h2.store.PageStore;

public class PageDataLeaf
extends PageData {
    private int[] offsets;
    private Row[] rows;
    private SoftReference<Row> rowRef;
    private int firstOverflowPageId;
    private int start;
    private int overflowRowSize;
    private int columnCount;
    private int memoryData;

    private PageDataLeaf(PageDataIndex pageDataIndex, int n, Data data) {
        super(pageDataIndex, n, data);
    }

    static PageDataLeaf create(PageDataIndex pageDataIndex, int n, int n2) {
        PageDataLeaf pageDataLeaf = new PageDataLeaf(pageDataIndex, n, pageDataIndex.getPageStore().createData());
        pageDataIndex.getPageStore().logUndo(pageDataLeaf, null);
        pageDataLeaf.parentPageId = n2;
        pageDataLeaf.columnCount = pageDataIndex.getTable().getColumns().length;
        pageDataLeaf.writeHead();
        pageDataLeaf.start = pageDataLeaf.data.length();
        return pageDataLeaf;
    }

    public static Page read(PageDataIndex pageDataIndex, Data data, int n) {
        PageDataLeaf pageDataLeaf = new PageDataLeaf(pageDataIndex, n, data);
        pageDataLeaf.read();
        return pageDataLeaf;
    }

    private void read() {
        this.data.reset();
        byte by = this.data.readByte();
        this.data.readShortInt();
        this.parentPageId = this.data.readInt();
        int n = this.data.readVarInt();
        if (n != this.index.getId()) {
            throw DbException.get(90030, "page:" + this.getPos() + " expected table:" + this.index.getId() + " got:" + n + " type:" + by);
        }
        this.columnCount = this.data.readVarInt();
        this.entryCount = this.data.readShortInt();
        this.offsets = new int[this.entryCount];
        this.keys = new long[this.entryCount];
        this.rows = new Row[this.entryCount];
        if (by == 1) {
            if (this.entryCount != 1) {
                DbException.throwInternalError("entries: " + this.entryCount);
            }
            this.firstOverflowPageId = this.data.readInt();
        }
        for (int i = 0; i < this.entryCount; ++i) {
            this.keys[i] = this.data.readVarLong();
            this.offsets[i] = this.data.readShortInt();
        }
        this.start = this.data.length();
        this.written = true;
    }

    private int getRowLength(Row row) {
        int n = 0;
        for (int i = 0; i < this.columnCount; ++i) {
            n += this.data.getValueLen(row.getValue(i));
        }
        return n;
    }

    private int findInsertionPoint(long l) {
        int n = this.find(l);
        if (n < this.keys.length && this.keys[n] == l) {
            throw this.index.getDuplicateKeyException();
        }
        return n;
    }

    @Override
    int addRowTry(Row row) {
        int n;
        int n2;
        this.index.getPageStore().logUndo(this, this.data);
        int n3 = this.getRowLength(row);
        int n4 = this.index.getPageStore().getPageSize();
        int n5 = this.entryCount == 0 ? n4 : this.offsets[this.entryCount - 1];
        int n6 = 2 + Data.getVarLongLen(row.getKey());
        if (this.entryCount > 0 && n5 - n3 < this.start + n6) {
            int n7 = this.findInsertionPoint(row.getKey());
            if (this.entryCount > 1) {
                if (this.entryCount < 5) {
                    return this.entryCount / 2;
                }
                if (this.index.isSortedInsertMode()) {
                    return n7 < 2 ? 1 : (n7 > this.entryCount - 1 ? this.entryCount - 1 : n7);
                }
                int n8 = this.entryCount / 3;
                return n7 < n8 ? n8 : (n7 >= 2 * n8 ? 2 * n8 : n7);
            }
            return n7;
        }
        this.index.getPageStore().logUndo(this, this.data);
        int n9 = n5 - n3;
        int[] nArray = new int[this.entryCount + 1];
        long[] lArray = new long[this.entryCount + 1];
        Row[] rowArray = new Row[this.entryCount + 1];
        if (this.entryCount == 0) {
            n2 = 0;
        } else {
            this.readAllRows();
            n2 = this.findInsertionPoint(row.getKey());
            System.arraycopy(this.offsets, 0, nArray, 0, n2);
            System.arraycopy(this.keys, 0, lArray, 0, n2);
            System.arraycopy(this.rows, 0, rowArray, 0, n2);
            if (n2 < this.entryCount) {
                for (n = n2; n < this.entryCount; ++n) {
                    nArray[n + 1] = this.offsets[n] - n3;
                }
                System.arraycopy(this.keys, n2, lArray, n2 + 1, this.entryCount - n2);
                System.arraycopy(this.rows, n2, rowArray, n2 + 1, this.entryCount - n2);
            }
        }
        this.written = false;
        this.changeCount = this.index.getPageStore().getChangeCount();
        n5 = n2 == 0 ? n4 : this.offsets[n2 - 1];
        n9 = n5 - n3;
        ++this.entryCount;
        this.start += n6;
        nArray[n2] = n9;
        lArray[n2] = row.getKey();
        rowArray[n2] = row;
        this.offsets = nArray;
        this.keys = lArray;
        this.rows = rowArray;
        this.index.getPageStore().update(this);
        if (n9 < this.start) {
            int n10;
            int n11;
            if (this.entryCount > 1) {
                DbException.throwInternalError();
            }
            this.start += 4;
            n = n3 - (n4 - this.start);
            this.offsets[n2] = n9 = this.start;
            int n12 = this.getPos();
            int n13 = n4;
            this.firstOverflowPageId = n11 = this.index.getPageStore().allocatePage();
            this.overflowRowSize = n4 + n3;
            this.writeData();
            Row row2 = this.rows[0];
            this.rowRef = new SoftReference<Row>(row2);
            this.rows[0] = null;
            Data data = this.index.getPageStore().createData();
            data.checkCapacity(this.data.length());
            data.write(this.data.getBytes(), 0, this.data.length());
            this.data.truncate(this.index.getPageStore().getPageSize());
            do {
                int n14;
                int n15;
                if (n <= n4 - 9) {
                    n15 = 19;
                    n10 = n;
                    n14 = 0;
                } else {
                    n15 = 3;
                    n10 = n4 - 11;
                    n14 = this.index.getPageStore().allocatePage();
                }
                PageDataOverflow pageDataOverflow = PageDataOverflow.create(this.index.getPageStore(), n11, n15, n12, n14, data, n13, n10);
                this.index.getPageStore().update(pageDataOverflow);
                n13 += n10;
                n12 = n11;
                n11 = n14;
            } while ((n -= n10) > 0);
        }
        if (this.rowRef == null) {
            this.memoryChange(true, row);
        } else {
            this.memoryChange(true, null);
        }
        return -1;
    }

    private void removeRow(int n) {
        this.index.getPageStore().logUndo(this, this.data);
        this.written = false;
        this.changeCount = this.index.getPageStore().getChangeCount();
        this.readAllRows();
        Row row = this.rows[n];
        if (row != null) {
            this.memoryChange(false, row);
        }
        --this.entryCount;
        if (this.entryCount < 0) {
            DbException.throwInternalError();
        }
        this.freeOverflow();
        this.firstOverflowPageId = 0;
        this.overflowRowSize = 0;
        this.rowRef = null;
        int n2 = 2 + Data.getVarLongLen(this.keys[n]);
        int[] nArray = new int[this.entryCount];
        long[] lArray = new long[this.entryCount];
        Row[] rowArray = new Row[this.entryCount];
        System.arraycopy(this.offsets, 0, nArray, 0, n);
        System.arraycopy(this.keys, 0, lArray, 0, n);
        System.arraycopy(this.rows, 0, rowArray, 0, n);
        int n3 = n > 0 ? this.offsets[n - 1] : this.index.getPageStore().getPageSize();
        int n4 = n3 - this.offsets[n];
        int n5 = this.offsets[this.entryCount];
        Arrays.fill(this.data.getBytes(), n5, n5 + n4, (byte)0);
        for (int i = n; i < this.entryCount; ++i) {
            nArray[i] = this.offsets[i + 1] + n4;
        }
        System.arraycopy(this.keys, n + 1, lArray, n, this.entryCount - n);
        System.arraycopy(this.rows, n + 1, rowArray, n, this.entryCount - n);
        this.start -= n2;
        this.offsets = nArray;
        this.keys = lArray;
        this.rows = rowArray;
    }

    @Override
    Cursor find(Session session, long l, long l2, boolean bl) {
        int n = this.find(l);
        return new PageDataCursor(session, this, n, l2, bl);
    }

    Row getRowAt(int n) {
        Row row = this.rows[n];
        if (row == null) {
            if (this.firstOverflowPageId == 0) {
                this.data.setPos(this.offsets[n]);
                row = this.index.readRow(this.data, this.columnCount);
            } else {
                PageDataOverflow pageDataOverflow;
                if (this.rowRef != null && (row = this.rowRef.get()) != null) {
                    return row;
                }
                PageStore pageStore = this.index.getPageStore();
                Data data = pageStore.createData();
                int n2 = pageStore.getPageSize();
                int n3 = this.offsets[n];
                data.write(this.data.getBytes(), n3, n2 - n3);
                int n4 = this.firstOverflowPageId;
                while ((n4 = (pageDataOverflow = this.index.getPageOverflow(n4)).readInto(data)) != 0) {
                }
                this.overflowRowSize = n2 + data.length();
                data.setPos(0);
                row = this.index.readRow(data, this.columnCount);
            }
            row.setKey(this.keys[n]);
            if (this.firstOverflowPageId != 0) {
                this.rowRef = new SoftReference<Row>(row);
            } else {
                this.rows[n] = row;
                this.memoryChange(true, row);
            }
        }
        return row;
    }

    int getEntryCount() {
        return this.entryCount;
    }

    @Override
    PageData split(int n) {
        int n2 = this.index.getPageStore().allocatePage();
        PageDataLeaf pageDataLeaf = PageDataLeaf.create(this.index, n2, this.parentPageId);
        int n3 = n;
        while (n3 < this.entryCount) {
            int n4 = pageDataLeaf.addRowTry(this.getRowAt(n));
            if (n4 != -1) {
                DbException.throwInternalError("split " + n4);
            }
            this.removeRow(n);
        }
        return pageDataLeaf;
    }

    @Override
    long getLastKey() {
        if (this.entryCount == 0) {
            return 0L;
        }
        return this.getRowAt(this.entryCount - 1).getKey();
    }

    PageDataLeaf getNextPage() {
        if (this.parentPageId == 0) {
            return null;
        }
        PageDataNode pageDataNode = (PageDataNode)this.index.getPage(this.parentPageId, -1);
        return pageDataNode.getNextPage(this.keys[this.entryCount - 1]);
    }

    @Override
    PageDataLeaf getFirstLeaf() {
        return this;
    }

    @Override
    protected void remapChildren(int n) {
        if (this.firstOverflowPageId == 0) {
            return;
        }
        PageDataOverflow pageDataOverflow = this.index.getPageOverflow(this.firstOverflowPageId);
        pageDataOverflow.setParentPageId(this.getPos());
        this.index.getPageStore().update(pageDataOverflow);
    }

    @Override
    boolean remove(long l) {
        int n = this.find(l);
        if (this.keys[n] != l) {
            throw DbException.get(90112, this.index.getSQL() + ": " + l + " " + this.keys[n]);
        }
        this.index.getPageStore().logUndo(this, this.data);
        if (this.entryCount == 1) {
            this.freeRecursive();
            return true;
        }
        this.removeRow(n);
        this.index.getPageStore().update(this);
        return false;
    }

    @Override
    void freeRecursive() {
        this.index.getPageStore().logUndo(this, this.data);
        this.index.getPageStore().free(this.getPos());
        this.freeOverflow();
    }

    private void freeOverflow() {
        if (this.firstOverflowPageId != 0) {
            PageDataOverflow pageDataOverflow;
            int n = this.firstOverflowPageId;
            do {
                pageDataOverflow = this.index.getPageOverflow(n);
                pageDataOverflow.free();
            } while ((n = pageDataOverflow.getNextOverflow()) != 0);
        }
    }

    @Override
    Row getRow(long l) {
        int n = this.find(l);
        return this.getRowAt(n);
    }

    @Override
    int getRowCount() {
        return this.entryCount;
    }

    @Override
    void setRowCountStored(int n) {
    }

    @Override
    public void write() {
        this.writeData();
        this.index.getPageStore().writePage(this.getPos(), this.data);
        this.data.truncate(this.index.getPageStore().getPageSize());
    }

    private void readAllRows() {
        for (int i = 0; i < this.entryCount; ++i) {
            this.getRowAt(i);
        }
    }

    private void writeHead() {
        this.data.reset();
        int n = this.firstOverflowPageId == 0 ? 17 : 1;
        this.data.writeByte((byte)n);
        this.data.writeShortInt(0);
        if (SysProperties.CHECK2 && this.data.length() != 3) {
            DbException.throwInternalError();
        }
        this.data.writeInt(this.parentPageId);
        this.data.writeVarInt(this.index.getId());
        this.data.writeVarInt(this.columnCount);
        this.data.writeShortInt(this.entryCount);
    }

    private void writeData() {
        int n;
        if (this.written) {
            return;
        }
        this.readAllRows();
        this.writeHead();
        if (this.firstOverflowPageId != 0) {
            this.data.writeInt(this.firstOverflowPageId);
            this.data.checkCapacity(this.overflowRowSize);
        }
        for (n = 0; n < this.entryCount; ++n) {
            this.data.writeVarLong(this.keys[n]);
            this.data.writeShortInt(this.offsets[n]);
        }
        for (n = 0; n < this.entryCount; ++n) {
            this.data.setPos(this.offsets[n]);
            Row row = this.getRowAt(n);
            for (int i = 0; i < this.columnCount; ++i) {
                this.data.writeValue(row.getValue(i));
            }
        }
        this.written = true;
    }

    public String toString() {
        return "page[" + this.getPos() + "] data leaf table:" + this.index.getId() + " entries:" + this.entryCount + " parent:" + this.parentPageId + (this.firstOverflowPageId == 0 ? "" : " overflow:" + this.firstOverflowPageId) + " keys:" + Arrays.toString(this.keys) + " offsets:" + Arrays.toString(this.offsets);
    }

    @Override
    public void moveTo(Session session, int n) {
        PageStore pageStore = this.index.getPageStore();
        if (this.parentPageId != 0) {
            pageStore.getPage(this.parentPageId);
        }
        pageStore.logUndo(this, this.data);
        PageDataLeaf pageDataLeaf = PageDataLeaf.create(this.index, n, this.parentPageId);
        this.readAllRows();
        pageDataLeaf.keys = this.keys;
        pageDataLeaf.overflowRowSize = this.overflowRowSize;
        pageDataLeaf.firstOverflowPageId = this.firstOverflowPageId;
        pageDataLeaf.rowRef = this.rowRef;
        pageDataLeaf.rows = this.rows;
        if (this.firstOverflowPageId != 0) {
            pageDataLeaf.rows[0] = this.getRowAt(0);
        }
        pageDataLeaf.entryCount = this.entryCount;
        pageDataLeaf.offsets = this.offsets;
        pageDataLeaf.start = this.start;
        pageDataLeaf.remapChildren(this.getPos());
        pageDataLeaf.writeData();
        pageDataLeaf.data.truncate(this.index.getPageStore().getPageSize());
        pageStore.update(pageDataLeaf);
        pageStore.free(this.getPos());
        if (this.parentPageId == 0) {
            this.index.setRootPageId(session, n);
        } else {
            PageDataNode pageDataNode = (PageDataNode)pageStore.getPage(this.parentPageId);
            pageDataNode.moveChild(this.getPos(), n);
        }
    }

    void setOverflow(int n, int n2) {
        if (SysProperties.CHECK && n != this.firstOverflowPageId) {
            DbException.throwInternalError("move " + this + " " + this.firstOverflowPageId);
        }
        this.index.getPageStore().logUndo(this, this.data);
        this.firstOverflowPageId = n2;
        if (this.written) {
            this.changeCount = this.index.getPageStore().getChangeCount();
            this.writeHead();
            this.data.writeInt(this.firstOverflowPageId);
        }
        this.index.getPageStore().update(this);
    }

    private void memoryChange(boolean bl, Row row) {
        int n = row == null ? 0 : 20 + row.getMemory();
        this.memoryData += bl ? n : -n;
        this.index.memoryChange(240 + this.memoryData + this.index.getPageStore().getPageSize() >> 2);
    }
}

