/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.utils.multitenancy;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.base.ServerConfiguration;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.utils.CarbonUtils;

public class MultitenantUtils {
    private static final Log log = LogFactory.getLog(MultitenantUtils.class);
    private static Map<Integer, String> tenantIdToAxisRepoMap = new HashMap<Integer, String>();

    public static String getTenantAwareUsername(String username) {
        ServerConfiguration serverConfig = ServerConfiguration.getInstance();
        if (username.contains("@") && !MultitenantUtils.isEmailUserName()) {
            username = username.substring(0, username.lastIndexOf(64));
        }
        return username;
    }

    public static String getTenantDomain(HttpServletRequest request) {
        String tenantDomain = (String)request.getAttribute("tenantDomain");
        if (tenantDomain == null || tenantDomain.trim().length() == 0) {
            tenantDomain = MultitenantUtils.getTenantDomainFromRequestURL(request.getRequestURI());
        }
        return tenantDomain;
    }

    public static String getTenantDomain(String username) {
        String tenantDomain = "carbon.super";
        if (username.contains("@") && !MultitenantUtils.isEmailUserName()) {
            tenantDomain = username.substring(username.lastIndexOf(64) + 1);
        }
        return tenantDomain;
    }

    public static String getDomainNameFromOpenId(String openId) {
        openId = openId.trim();
        String hostName = null;
        if (openId.indexOf(64) > 0) {
            hostName = openId.substring(openId.indexOf(64) + 1);
            return hostName;
        }
        return hostName;
    }

    public static String getTenantDomainFromRequestURL(String requestURI) {
        String domain = null;
        if (requestURI.contains("/t/")) {
            int index = requestURI.indexOf("/t/");
            int endIndex = requestURI.indexOf("/", index + 3);
            domain = endIndex != -1 ? requestURI.substring(index + 3, endIndex) : requestURI.substring(index + 3);
        }
        return domain;
    }

    private static String getHostName() {
        ServerConfiguration serverConfig = ServerConfiguration.getInstance();
        if (serverConfig.getFirstProperty("HostName") != null) {
            return serverConfig.getFirstProperty("HostName");
        }
        return "localhost";
    }

    public static String getTenantDomainFromUrl(String url) {
        int tenantDelimiterIndex = url.indexOf("/t/");
        if (tenantDelimiterIndex != -1) {
            String temp = url.substring(tenantDelimiterIndex + 3);
            int indexOfSlash = temp.indexOf(47);
            String tenant = indexOfSlash != -1 ? temp.substring(0, indexOfSlash) : temp;
            return tenant;
        }
        return url;
    }

    public static int getTenantId(ConfigurationContext configCtx) {
        return PrivilegedCarbonContext.getCurrentContext(configCtx).getTenantId();
    }

    public static String getAxis2RepositoryPath(int tenantId) {
        String repoPath;
        if (tenantIdToAxisRepoMap.containsKey(tenantId)) {
            return tenantIdToAxisRepoMap.get(tenantId);
        }
        if (tenantId == -1234) {
            repoPath = ServerConfiguration.getInstance().getFirstProperty("Axis2Config.RepositoryLocation");
        } else {
            File tenantDir = new File(CarbonUtils.getCarbonTenantsDirPath() + File.separator + tenantId);
            repoPath = tenantDir.getAbsolutePath();
        }
        tenantIdToAxisRepoMap.put(tenantId, repoPath);
        return repoPath;
    }

    public static boolean isEmailUserName() {
        String enableEmailUserName = ServerConfiguration.getInstance().getFirstProperty("EnableEmailUserName");
        return enableEmailUserName != null && "true".equals(enableEmailUserName.trim());
    }
}

