/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.context;

import java.net.URI;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import net.sf.jsr107cache.Cache;
import net.sf.jsr107cache.CacheManager;
import org.wso2.carbon.base.CarbonBaseUtils;
import org.wso2.carbon.context.RegistryType;
import org.wso2.carbon.context.internal.CarbonContextDataHolder;
import org.wso2.carbon.queuing.CarbonQueue;
import org.wso2.carbon.queuing.CarbonQueueManager;
import org.wso2.carbon.registry.api.Registry;
import org.wso2.carbon.user.api.UserRealm;

public class CarbonContext {
    private CarbonContextDataHolder carbonContextHolder = null;

    protected CarbonContext(CarbonContextDataHolder carbonContextHolder) {
        this.carbonContextHolder = carbonContextHolder != null ? carbonContextHolder : CarbonContextDataHolder.getCurrentCarbonContextHolder();
    }

    protected CarbonContextDataHolder getCarbonContextDataHolder() {
        if (this.carbonContextHolder == null) {
            return CarbonContextDataHolder.getCurrentCarbonContextHolder();
        }
        return this.carbonContextHolder;
    }

    public static CarbonContext getCurrentContext() {
        return new CarbonContext(null);
    }

    public static CarbonContext getThreadLocalCarbonContext() {
        return new CarbonContext(CarbonContextDataHolder.getThreadLocalCarbonContextHolder());
    }

    public int getTenantId() {
        CarbonBaseUtils.checkSecurity();
        return this.getCarbonContextDataHolder().getTenantId();
    }

    public String getUsername() {
        return this.getCarbonContextDataHolder().getUsername();
    }

    public String getTenantDomain() {
        return this.getCarbonContextDataHolder().getTenantDomain();
    }

    public Registry getRegistry(RegistryType type) {
        CarbonContextDataHolder carbonContextDataHolder = this.getCarbonContextDataHolder();
        switch (type) {
            case USER_CONFIGURATION: {
                return carbonContextDataHolder.getConfigUserRegistry();
            }
            case SYSTEM_CONFIGURATION: {
                return carbonContextDataHolder.getConfigSystemRegistry();
            }
            case USER_GOVERNANCE: {
                return carbonContextDataHolder.getGovernanceUserRegistry();
            }
            case SYSTEM_GOVERNANCE: {
                return carbonContextDataHolder.getGovernanceSystemRegistry();
            }
            case LOCAL_REPOSITORY: {
                return carbonContextDataHolder.getLocalRepository();
            }
        }
        return null;
    }

    public UserRealm getUserRealm() {
        return this.getCarbonContextDataHolder().getUserRealm();
    }

    public Cache getCache(String cacheName) {
        return CacheManager.getInstance().getCache(cacheName);
    }

    public Cache getCache() {
        return CacheManager.getInstance().getCache(null);
    }

    public CarbonQueue<?> getQueue(String name) {
        return CarbonQueueManager.getInstance().getQueue(name);
    }

    public Context getJNDIContext(Hashtable properties) throws NamingException {
        return new InitialContext(properties);
    }

    public Context getJNDIContext() throws NamingException {
        return new InitialContext();
    }

    public String[] discover(URI[] scopes) {
        try {
            return CarbonContextDataHolder.getDiscoveryServiceProvider().probe(null, scopes, null, this.getCarbonContextDataHolder().getTenantId());
        }
        catch (Exception ignored) {
            return new String[0];
        }
    }

    public String getApplicationName() {
        return this.getCarbonContextDataHolder().getApplicationName();
    }
}

