/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bridge;

import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLStreamHandlerFactory;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import org.wso2.carbon.bridge.BridgeUtils;
import org.wso2.carbon.bridge.FrameworkLauncher;
import org.wso2.carbon.bridge.HttpSessionManager;

public class EquinoxFrameworkLauncher
implements FrameworkLauncher {
    private static final String WS_DELIM = " \t\n\r\f";
    protected static final String FILE_SCHEME = "file:";
    protected static final String FRAMEWORK_BUNDLE_NAME = "org.eclipse.osgi";
    protected static final String STARTER = "org.eclipse.core.runtime.adaptor.EclipseStarter";
    protected static final String FRAMEWORKPROPERTIES = "org.eclipse.osgi.framework.internal.core.FrameworkProperties";
    protected static final String NULL_IDENTIFIER = "@null";
    protected static final String OSGI_FRAMEWORK = "osgi.framework";
    protected static final String OSGI_INSTANCE_AREA = "osgi.instance.area";
    protected static final String OSGI_CONFIGURATION_AREA = "osgi.configuration.area";
    protected static final String OSGI_INSTALL_AREA = "osgi.install.area";
    protected static final String OSGI_FORCED_RESTART = "osgi.forcedRestart";
    protected static final String RESOURCE_BASE = "/WEB-INF/eclipse/";
    protected static final String LAUNCH_INI = "launch.ini";
    private static final String ENABLE_OSGI_CONSOLE = "osgiConsole";
    private static final String ENABLE_OSGI_DEBUG = "osgiDebugOptions";
    private static final String BUNDLE_CREATORS = "bundleCreators";
    private static final String APPLY_PATCHES = "applyPatches";
    private static final String BUNDLE_BACKUP_DIR = "patch0000";
    private boolean isRunning;
    static final PermissionCollection allPermissions = new PermissionCollection(){
        private static final long serialVersionUID = 482874725021998286L;
        Permission allPermission = new AllPermission();

        @Override
        public void add(Permission permission) {
        }

        @Override
        public boolean implies(Permission permission) {
            return true;
        }

        public Enumeration elements() {
            return new Enumeration(){
                int cur = 0;

                @Override
                public boolean hasMoreElements() {
                    return this.cur < 1;
                }

                public Object nextElement() {
                    if (this.cur == 0) {
                        this.cur = 1;
                        return allPermission;
                    }
                    throw new NoSuchElementException();
                }
            };
        }
    };
    protected ServletConfig servletConfig;
    protected ServletContext context;
    private File platformDirectory;
    private ClassLoader frameworkContextClassLoader;
    private URLClassLoader frameworkClassLoader;

    @Override
    public void init(ServletConfig servletConfig) {
        this.servletConfig = servletConfig;
        this.context = servletConfig.getServletContext();
        this.init();
    }

    public void init() {
        System.setProperty("wso2carbon.start.time", String.valueOf(System.currentTimeMillis()));
    }

    public void destroy() {
    }

    @Override
    public synchronized void deploy() {
        this.platformDirectory = this.getCarbonComponentRepo();
        File plugins = new File(this.platformDirectory, "plugins");
        File patchesDir = new File(this.platformDirectory, "patches");
        File dropinsFolder = new File(this.platformDirectory, "dropins");
        String applyPatches = System.getProperty(APPLY_PATCHES);
        if (applyPatches != null) {
            try {
                this.applyPatches(patchesDir, plugins);
            }
            catch (IOException e) {
                this.context.log("Error occurred while applying patches", (Throwable)e);
            }
        }
    }

    @Override
    public synchronized void undeploy() {
        if (this.platformDirectory == null) {
            this.context.log("Undeploy unnecessary. - (not deployed)");
            return;
        }
        if (this.frameworkClassLoader != null) {
            throw new IllegalStateException("Could not undeploy Framework - (not stopped)");
        }
        EquinoxFrameworkLauncher.deleteDirectory(new File(this.platformDirectory, "configuration"));
        EquinoxFrameworkLauncher.deleteDirectory(new File(this.platformDirectory, "features"));
        EquinoxFrameworkLauncher.deleteDirectory(new File(this.platformDirectory, "plugins"));
        EquinoxFrameworkLauncher.deleteDirectory(new File(this.platformDirectory, "workspace"));
        EquinoxFrameworkLauncher.deleteDirectory(new File(this.platformDirectory, "p2"));
        if (!new File(this.platformDirectory, ".eclipseproduct").delete()) {
            this.context.log("Failed to deleted the directory: .eclipseproduct");
        }
        if (!new File(this.platformDirectory, "artifacts.xml").delete()) {
            this.context.log("Failed to deleted the file: artifacts.xml");
        }
        if (!new File(this.platformDirectory, "eclipse.ini").delete()) {
            this.context.log("Failed to deleted the file: eclipse.ini");
        }
        this.platformDirectory = null;
    }

    @Override
    public synchronized void start() {
        this.platformDirectory = this.getCarbonComponentRepo();
        if (this.platformDirectory == null) {
            throw new IllegalStateException("Could not start the Framework - (not deployed)");
        }
        if (this.frameworkClassLoader != null) {
            this.context.log("Framework is already started");
            return;
        }
        Map<String, String> initialPropsMap = this.buildInitialPropertyMap();
        String[] args = this.getArgs();
        ClassLoader original = Thread.currentThread().getContextClassLoader();
        try {
            System.setProperty("osgi.framework.useSystemProperties", "false");
            this.frameworkClassLoader = new ChildFirstURLClassLoader(new URL[]{new URL(initialPropsMap.get(OSGI_FRAMEWORK))}, this.getClass().getClassLoader());
            Class<?> clazz = this.frameworkClassLoader.loadClass(STARTER);
            Method setInitialProperties = clazz.getMethod("setInitialProperties", Map.class);
            setInitialProperties.invoke(null, initialPropsMap);
            this.registerRestartHandler(clazz);
            Method runMethod = clazz.getMethod("startup", String[].class, Runnable.class);
            runMethod.invoke(null, new Object[]{args, null});
            this.frameworkContextClassLoader = Thread.currentThread().getContextClassLoader();
            this.isRunning = true;
        }
        catch (InvocationTargetException ite) {
            Throwable t = ite.getTargetException();
            if (t == null) {
                t = ite;
            }
            this.context.log("Error while starting Framework", t);
            throw new RuntimeException(t.getMessage());
        }
        catch (Exception e) {
            this.context.log("Error while starting Framework", (Throwable)e);
            throw new RuntimeException(e.getMessage());
        }
        finally {
            Thread.currentThread().setContextClassLoader(original);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void stop() {
        this.isRunning = false;
        if (this.platformDirectory == null) {
            this.context.log("Shutdown unnecessary. (not deployed)");
            return;
        }
        if (this.frameworkClassLoader == null) {
            this.context.log("Framework is already shutdown");
            return;
        }
        ClassLoader original = Thread.currentThread().getContextClassLoader();
        try {
            Class<?> clazz = this.frameworkClassLoader.loadClass(STARTER);
            Method method = clazz.getDeclaredMethod("shutdown", null);
            Thread.currentThread().setContextClassLoader(this.frameworkContextClassLoader);
            method.invoke(clazz, (Object[])null);
            HttpSessionManager.invalidateSessions();
            try {
                clazz = this.getClass().getClassLoader().loadClass("org.apache.commons.logging.LogFactory");
                method = clazz.getDeclaredMethod("release", ClassLoader.class);
                method.invoke(clazz, this.frameworkContextClassLoader);
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
        }
        catch (Exception e) {
            this.context.log("Error while stopping Framework", (Throwable)e);
            return;
        }
        finally {
            this.frameworkClassLoader = null;
            this.frameworkContextClassLoader = null;
            Thread.currentThread().setContextClassLoader(original);
        }
    }

    @Override
    public boolean isRunning() {
        return this.isRunning;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void copyResource(String resourcePath, File target) {
        if (resourcePath.endsWith("/")) {
            Set paths;
            if (!target.mkdir()) {
                this.context.log("Fail to create the directory: " + target.getAbsolutePath());
            }
            if ((paths = this.context.getResourcePaths(resourcePath)) == null) {
                return;
            }
            for (String path : paths) {
                File newFile = new File(target, path.substring(resourcePath.length()));
                this.copyResource(path, newFile);
            }
            return;
        }
        try {
            if (!target.createNewFile()) return;
            InputStream is = null;
            OutputStream os = null;
            try {
                is = this.context.getResourceAsStream(resourcePath);
                if (is == null) {
                    return;
                }
                os = new FileOutputStream(target);
                byte[] buffer = new byte[8192];
                int bytesRead = is.read(buffer);
                while (bytesRead != -1) {
                    os.write(buffer, 0, bytesRead);
                    bytesRead = is.read(buffer);
                }
                return;
            }
            finally {
                try {
                    is.close();
                }
                catch (IOException e) {
                    this.context.log("Unable to close the InputStream " + e.getMessage(), (Throwable)e);
                }
                try {
                    if (os != null) {
                        os.close();
                    }
                }
                catch (IOException e) {
                    this.context.log("Unable to close the OutputStream " + e.getMessage(), (Throwable)e);
                }
            }
        }
        catch (IOException e) {
            this.context.log("Error copying resources", (Throwable)e);
        }
    }

    protected void extractFeatures(String compressFilesPath, File target) {
        if (compressFilesPath.endsWith("/")) {
            Set paths;
            if (!target.mkdir()) {
                this.context.log("Fail to create the directory: " + target.getAbsolutePath());
            }
            if ((paths = this.context.getResourcePaths(compressFilesPath)) == null) {
                return;
            }
            for (Object path1 : paths) {
                String path = (String)path1;
                this.extractFeatures(path, target);
            }
        } else if (compressFilesPath.endsWith(".jar")) {
            File tmpJarFilePath = new File(compressFilesPath);
            String featureName = tmpJarFilePath.getName().substring(0, tmpJarFilePath.getName().length() - 4);
            File featureFolder = new File(target.getPath() + File.separator + "features" + File.separator + featureName);
            this.extractResource(compressFilesPath, featureFolder);
        } else {
            this.extractResource(compressFilesPath, target);
        }
    }

    protected void extractResource(String compressFilePath, File target) {
        try {
            String entryName;
            File newFile;
            String directory;
            byte[] buf = new byte[1024];
            ZipInputStream zipinputstream = new ZipInputStream(this.context.getResourceAsStream(compressFilePath));
            ZipEntry zipentry = zipinputstream.getNextEntry();
            while (!(zipentry == null || (directory = (newFile = new File(entryName = zipentry.getName())).getParent()) == null && newFile.isDirectory())) {
                int n;
                if (zipentry.isDirectory()) {
                    zipinputstream.closeEntry();
                    zipentry = zipinputstream.getNextEntry();
                    continue;
                }
                if (newFile.isDirectory()) break;
                File outputFile = new File(target.getPath(), entryName);
                if (outputFile.getParentFile() != null && !outputFile.getParentFile().mkdirs()) {
                    throw new IOException("Fail to create the directory: " + outputFile.getParentFile().getAbsolutePath());
                }
                FileOutputStream fileoutputstream = new FileOutputStream(outputFile);
                while ((n = zipinputstream.read(buf, 0, 1024)) > -1) {
                    fileoutputstream.write(buf, 0, n);
                }
                fileoutputstream.close();
                zipinputstream.closeEntry();
                zipentry = zipinputstream.getNextEntry();
            }
            zipinputstream.close();
        }
        catch (Exception ignored) {
            this.context.log(ignored.getMessage(), (Throwable)ignored);
        }
    }

    protected static boolean deleteDirectory(File directory) {
        if (directory.exists() && directory.isDirectory()) {
            File[] files;
            for (File file : files = directory.listFiles()) {
                if (file.isDirectory()) {
                    EquinoxFrameworkLauncher.deleteDirectory(file);
                    continue;
                }
                if (file.delete()) continue;
                System.err.println("Fail to create the directory: " + file.getAbsolutePath());
            }
        }
        return directory.delete();
    }

    @Override
    public synchronized ClassLoader getFrameworkContextClassLoader() {
        return this.frameworkContextClassLoader;
    }

    protected synchronized File getPlatformDirectory() {
        return this.platformDirectory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Properties loadProperties(String resource) {
        Properties result = new Properties();
        InputStream in = null;
        try {
            URL location = this.context.getResource(resource);
            if (location != null) {
                in = location.openStream();
                result.load(in);
            }
        }
        catch (MalformedURLException e) {
        }
        catch (IOException e) {
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {}
            }
        }
        return result;
    }

    protected String searchFor(final String target, String start) {
        FileFilter filter = new FileFilter(){

            @Override
            public boolean accept(File candidate) {
                return candidate.getName().equals(target) || candidate.getName().startsWith(target + "_");
            }
        };
        File[] candidates = new File(start).listFiles(filter);
        if (candidates == null) {
            return null;
        }
        String[] arrays = new String[candidates.length];
        for (int i = 0; i < arrays.length; ++i) {
            arrays[i] = candidates[i].getName();
        }
        int result = this.findMax(arrays);
        if (result == -1) {
            return null;
        }
        return candidates[result].getAbsolutePath().replace(File.separatorChar, '/') + (candidates[result].isDirectory() ? "/" : "");
    }

    protected int findMax(String[] candidates) {
        int result = -1;
        Object[] maxVersion = null;
        for (int i = 0; i < candidates.length; ++i) {
            String name = candidates[i];
            String version = "";
            int index = name.indexOf(95);
            if (index != -1) {
                version = name.substring(index + 1);
            }
            Object[] currentVersion = this.getVersionElements(version);
            if (maxVersion == null) {
                result = i;
                maxVersion = currentVersion;
                continue;
            }
            if (this.compareVersion(maxVersion, currentVersion) >= 0) continue;
            result = i;
            maxVersion = currentVersion;
        }
        return result;
    }

    private int compareVersion(Object[] left, Object[] right) {
        int result = ((Integer)left[0]).compareTo((Integer)right[0]);
        if (result != 0) {
            return result;
        }
        result = ((Integer)left[1]).compareTo((Integer)right[1]);
        if (result != 0) {
            return result;
        }
        result = ((Integer)left[2]).compareTo((Integer)right[2]);
        if (result != 0) {
            return result;
        }
        return ((String)left[3]).compareTo((String)right[3]);
    }

    private Object[] getVersionElements(String version) {
        if (version.endsWith(".jar")) {
            version = version.substring(0, version.length() - 4);
        }
        Object[] result = new Object[]{0, 0, 0, ""};
        StringTokenizer t = new StringTokenizer(version, ".");
        int i = 0;
        while (t.hasMoreTokens() && i < 4) {
            String token = t.nextToken();
            if (i < 3) {
                try {
                    result[i++] = new Integer(token);
                    continue;
                }
                catch (Exception e) {
                    break;
                }
            }
            result[i++] = token;
        }
        return result;
    }

    protected void applyPatches(File patchesDir, File pluginsDir) throws IOException {
        File bundleBackupDir = new File(patchesDir, BUNDLE_BACKUP_DIR);
        if (!bundleBackupDir.exists()) {
            File[] plugins;
            for (File plugin : plugins = pluginsDir.listFiles()) {
                BridgeUtils.copyFileToDir(plugin, bundleBackupDir);
            }
        }
        this.copyPatches(patchesDir, pluginsDir);
    }

    protected void copyPatches(File source, File target) throws IOException {
        if (source.isDirectory()) {
            Object[] files = source.listFiles();
            Arrays.sort(files);
            for (Object file : files) {
                this.copyPatches((File)file, target);
            }
        } else {
            BridgeUtils.copyFileToDir(source, target);
        }
    }

    private File getCarbonComponentRepo() {
        String carbonComponentsRepository;
        File componentRepo;
        String carbonRepo = System.getenv("CARBON_REPOSITORY");
        if (carbonRepo == null) {
            carbonRepo = System.getProperty("carbon.repository");
        }
        if (carbonRepo == null) {
            carbonRepo = System.getProperty("carbon.home") + File.separator + "repository";
        }
        if (!(componentRepo = new File(carbonComponentsRepository = carbonRepo + File.separator + "components")).exists() && !componentRepo.mkdirs()) {
            System.err.println("Fail to create the directory: " + componentRepo.getAbsolutePath());
        }
        return componentRepo;
    }

    private void registerRestartHandler(Class starterClazz) throws NoSuchMethodException, ClassNotFoundException, IllegalAccessException, InvocationTargetException {
        Method registerFrameworkShutdownHandler;
        try {
            registerFrameworkShutdownHandler = starterClazz.getDeclaredMethod("internalAddFrameworkShutdownHandler", Runnable.class);
        }
        catch (NoSuchMethodException e) {
            this.context.log(starterClazz.getName() + " does not support setting a shutdown handler. Restart handling is disabled.");
            return;
        }
        if (!registerFrameworkShutdownHandler.isAccessible()) {
            registerFrameworkShutdownHandler.setAccessible(true);
        }
        Runnable restartHandler = this.createRestartHandler();
        registerFrameworkShutdownHandler.invoke(null, restartHandler);
    }

    private Runnable createRestartHandler() throws ClassNotFoundException, NoSuchMethodException {
        Class<?> frameworkPropertiesClazz = this.frameworkClassLoader.loadClass(FRAMEWORKPROPERTIES);
        final Method getProperty = frameworkPropertiesClazz.getMethod("getProperty", String.class);
        Runnable restartHandler = new Runnable(){

            @Override
            public void run() {
                try {
                    String forcedRestart = (String)getProperty.invoke(null, EquinoxFrameworkLauncher.OSGI_FORCED_RESTART);
                    if (Boolean.valueOf(forcedRestart).booleanValue()) {
                        EquinoxFrameworkLauncher.this.stop();
                        EquinoxFrameworkLauncher.this.start();
                    }
                }
                catch (InvocationTargetException ite) {
                    Throwable t = ite.getTargetException();
                    if (t == null) {
                        t = ite;
                    }
                    throw new RuntimeException(t.getMessage());
                }
                catch (Exception e) {
                    throw new RuntimeException(e.getMessage());
                }
            }
        };
        return restartHandler;
    }

    private Map<String, String> buildInitialPropertyMap() {
        HashMap<String, String> initialPropertyMap = new HashMap<String, String>();
        Properties launchProperties = this.loadProperties("/WEB-INF/eclipse/launch.ini");
        Iterator<Map.Entry<Object, Object>> i$ = launchProperties.entrySet().iterator();
        while (i$.hasNext()) {
            Map.Entry<Object, Object> o;
            Map.Entry<Object, Object> entry = o = i$.next();
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (key.endsWith("*")) {
                if (!value.equals(NULL_IDENTIFIER)) continue;
                EquinoxFrameworkLauncher.clearPrefixedSystemProperties(key.substring(0, key.length() - 1), initialPropertyMap);
                continue;
            }
            if (value.equals(NULL_IDENTIFIER)) {
                initialPropertyMap.put(key, null);
                continue;
            }
            initialPropertyMap.put((String)entry.getKey(), (String)entry.getValue());
        }
        try {
            if (initialPropertyMap.get(OSGI_INSTALL_AREA) == null) {
                initialPropertyMap.put(OSGI_INSTALL_AREA, this.platformDirectory.toURL().toExternalForm());
            }
            if (initialPropertyMap.get(OSGI_CONFIGURATION_AREA) == null) {
                File configurationDirectory = new File(this.platformDirectory, "configuration");
                if (!configurationDirectory.exists() && !configurationDirectory.mkdirs()) {
                    this.context.log("Fail to create the directory: " + configurationDirectory.getAbsolutePath());
                }
                initialPropertyMap.put(OSGI_CONFIGURATION_AREA, configurationDirectory.toURL().toExternalForm());
            }
            if (initialPropertyMap.get(OSGI_INSTANCE_AREA) == null) {
                File workspaceDirectory = new File(this.platformDirectory, "workspace");
                if (!workspaceDirectory.exists() && !workspaceDirectory.mkdirs()) {
                    this.context.log("Failed to create the directory: " + workspaceDirectory.getAbsoluteFile());
                }
                initialPropertyMap.put(OSGI_INSTANCE_AREA, workspaceDirectory.toURL().toExternalForm());
            }
            if (initialPropertyMap.get(OSGI_FRAMEWORK) == null) {
                String installArea = (String)initialPropertyMap.get(OSGI_INSTALL_AREA);
                if (installArea.startsWith(FILE_SCHEME)) {
                    installArea = installArea.substring(FILE_SCHEME.length());
                }
                String path = new File(installArea, "plugins").toString();
                if ((path = this.searchFor(FRAMEWORK_BUNDLE_NAME, path)) == null) {
                    throw new RuntimeException("Could not find framework");
                }
                initialPropertyMap.put(OSGI_FRAMEWORK, new File(path).toURL().toExternalForm());
            }
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Error establishing location");
        }
        return initialPropertyMap;
    }

    private static void clearPrefixedSystemProperties(String prefix, Map<String, String> targetPropertyMap) {
        for (Object o : System.getProperties().keySet()) {
            String propertyName = (String)o;
            if (!propertyName.startsWith(prefix) || targetPropertyMap.containsKey(propertyName)) continue;
            targetPropertyMap.put(propertyName, null);
        }
    }

    private String[] getArgs() {
        String enableOsgiDebug;
        ArrayList<String> args = new ArrayList<String>();
        String enableOsgiConsole = System.getProperty(ENABLE_OSGI_CONSOLE);
        if (enableOsgiConsole == null) {
            enableOsgiConsole = this.servletConfig.getInitParameter(ENABLE_OSGI_CONSOLE);
        } else if (!enableOsgiConsole.toLowerCase().equals("true")) {
            try {
                enableOsgiConsole = "-console " + String.valueOf(Integer.parseInt(enableOsgiConsole));
            }
            catch (NumberFormatException ignored) {
                enableOsgiConsole = "-console";
            }
        } else {
            enableOsgiConsole = "-console";
        }
        if (enableOsgiConsole != null) {
            StringTokenizer tokenizer = new StringTokenizer(enableOsgiConsole, WS_DELIM);
            while (tokenizer.hasMoreTokens()) {
                String remainingArg;
                String arg = tokenizer.nextToken();
                if (arg.startsWith("\"")) {
                    if (arg.endsWith("\"")) {
                        if (arg.length() >= 2) {
                            arg = arg.substring(1, arg.length() - 1);
                        }
                    } else {
                        remainingArg = tokenizer.nextToken("\"");
                        arg = arg.substring(1) + remainingArg;
                        tokenizer.nextToken(WS_DELIM);
                    }
                } else if (arg.startsWith("'")) {
                    if (arg.endsWith("'")) {
                        if (arg.length() >= 2) {
                            arg = arg.substring(1, arg.length() - 1);
                        }
                    } else {
                        remainingArg = tokenizer.nextToken("'");
                        arg = arg.substring(1) + remainingArg;
                        tokenizer.nextToken(WS_DELIM);
                    }
                }
                args.add(arg);
            }
            System.out.println("OSGi console has been enabled with options: " + enableOsgiConsole);
        }
        if ((enableOsgiDebug = System.getProperty(ENABLE_OSGI_DEBUG)) == null) {
            enableOsgiDebug = this.servletConfig.getInitParameter(ENABLE_OSGI_DEBUG);
        } else if (enableOsgiDebug.toLowerCase().equals("true")) {
            enableOsgiDebug = "lib/core/WEB-INF/eclipse/osgi-debug.options";
        }
        if (enableOsgiDebug != null) {
            args.add("-debug");
            args.add(enableOsgiDebug);
            System.out.println("OSGi debugging has been enabled with options: " + enableOsgiDebug);
        }
        return args.toArray(new String[0]);
    }

    static {
        if (allPermissions.elements() == null) {
            throw new IllegalStateException();
        }
    }

    protected class ChildFirstURLClassLoader
    extends URLClassLoader {
        public ChildFirstURLClassLoader(URL[] urls) {
            super(urls);
        }

        public ChildFirstURLClassLoader(URL[] urls, ClassLoader parent) {
            super(urls, parent);
        }

        public ChildFirstURLClassLoader(URL[] urls, ClassLoader parent, URLStreamHandlerFactory factory) {
            super(urls, parent, factory);
        }

        @Override
        public URL getResource(String name) {
            ClassLoader parent;
            URL resource = this.findResource(name);
            if (resource == null && (parent = this.getParent()) != null) {
                resource = parent.getResource(name);
            }
            return resource;
        }

        protected synchronized Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
            Class<?> clazz = this.findLoadedClass(name);
            if (clazz == null) {
                try {
                    clazz = this.findClass(name);
                }
                catch (ClassNotFoundException e) {
                    ClassLoader parent = this.getParent();
                    clazz = parent != null ? parent.loadClass(name) : ChildFirstURLClassLoader.getSystemClassLoader().loadClass(name);
                }
            }
            if (resolve) {
                this.resolveClass(clazz);
            }
            return clazz;
        }

        @Override
        protected PermissionCollection getPermissions(CodeSource codesource) {
            return allPermissions;
        }
    }
}

