/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.RangeFilter;

public class ConstantScoreRangeQuery
extends Query {
    private final String fieldName;
    private final String lowerVal;
    private final String upperVal;
    private final boolean includeLower;
    private final boolean includeUpper;

    public ConstantScoreRangeQuery(String fieldName, String lowerVal, String upperVal, boolean includeLower, boolean includeUpper) {
        if (lowerVal == null) {
            includeLower = true;
        } else if (includeLower && lowerVal.equals("")) {
            lowerVal = null;
        }
        if (upperVal == null) {
            includeUpper = true;
        }
        this.fieldName = fieldName.intern();
        this.lowerVal = lowerVal;
        this.upperVal = upperVal;
        this.includeLower = includeLower;
        this.includeUpper = includeUpper;
    }

    public String getField() {
        return this.fieldName;
    }

    public String getLowerVal() {
        return this.lowerVal;
    }

    public String getUpperVal() {
        return this.upperVal;
    }

    public boolean includesLower() {
        return this.includeLower;
    }

    public boolean includesUpper() {
        return this.includeUpper;
    }

    public Query rewrite(IndexReader reader) throws IOException {
        RangeFilter rangeFilt = new RangeFilter(this.fieldName, this.lowerVal != null ? this.lowerVal : "", this.upperVal, this.lowerVal == "" ? false : this.includeLower, this.upperVal == null ? false : this.includeUpper);
        ConstantScoreQuery q = new ConstantScoreQuery(rangeFilt);
        q.setBoost(this.getBoost());
        return q;
    }

    public String toString(String field) {
        StringBuffer buffer = new StringBuffer();
        if (!this.getField().equals(field)) {
            buffer.append(this.getField());
            buffer.append(":");
        }
        buffer.append(this.includeLower ? (char)'[' : '{');
        buffer.append(this.lowerVal != null ? this.lowerVal : "*");
        buffer.append(" TO ");
        buffer.append(this.upperVal != null ? this.upperVal : "*");
        buffer.append(this.includeUpper ? (char)']' : '}');
        if (this.getBoost() != 1.0f) {
            buffer.append("^");
            buffer.append(Float.toString(this.getBoost()));
        }
        return buffer.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ConstantScoreRangeQuery)) {
            return false;
        }
        ConstantScoreRangeQuery other = (ConstantScoreRangeQuery)o;
        if (this.fieldName != other.fieldName || this.includeLower != other.includeLower || this.includeUpper != other.includeUpper) {
            return false;
        }
        if (this.lowerVal != null ? !this.lowerVal.equals(other.lowerVal) : other.lowerVal != null) {
            return false;
        }
        if (this.upperVal != null ? !this.upperVal.equals(other.upperVal) : other.upperVal != null) {
            return false;
        }
        return this.getBoost() == other.getBoost();
    }

    public int hashCode() {
        int h = Float.floatToIntBits(this.getBoost()) ^ this.fieldName.hashCode();
        h ^= this.lowerVal != null ? this.lowerVal.hashCode() : -1772448166;
        h ^= h << 17 | h >>> 16;
        h ^= this.upperVal != null ? this.upperVal.hashCode() : 1516853865;
        return h ^= (this.includeLower ? 1716885930 : 0) ^ (this.includeUpper ? -1716890266 : 0);
    }
}

