/*
 * Decompiled with CFR 0.152.
 */
package org.jaggeryjs.hostobjects.file;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jaggeryjs.hostobjects.file.JavaScriptFile;
import org.jaggeryjs.hostobjects.file.JavaScriptFileImpl;
import org.jaggeryjs.hostobjects.file.JavaScriptFileManager;
import org.jaggeryjs.scriptengine.exceptions.ScriptException;

public class JavaScriptFileManagerImpl
implements JavaScriptFileManager {
    private static final Log log = LogFactory.getLog(JavaScriptFileManagerImpl.class);

    @Override
    public JavaScriptFile getJavaScriptFile(Object object) throws ScriptException {
        if (object instanceof String) {
            return new JavaScriptFileImpl(this.getFile((String)object).getAbsolutePath());
        }
        String msg = "Unsupported parameter to the File constructor : " + object.getClass();
        log.error((Object)msg);
        throw new ScriptException(msg);
    }

    @Override
    public File getFile(String path) throws ScriptException {
        File file;
        if (path.startsWith("file://")) {
            try {
                file = FileUtils.toFile((URL)new URL(path));
            }
            catch (MalformedURLException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                throw new ScriptException((Exception)e);
            }
        } else {
            String oldPath = path;
            if ((path = FilenameUtils.normalizeNoEndSeparator((String)path)) == null) {
                String msg = "Invalid file path : " + oldPath;
                log.error((Object)msg);
                throw new ScriptException(msg);
            }
            file = new File(path);
        }
        return file;
    }
}

