/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om.impl.dom;

import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.impl.OMNodeEx;
import org.apache.axiom.om.impl.dom.DocumentImpl;
import org.apache.axiom.om.impl.dom.NodeImpl;
import org.apache.axiom.om.impl.dom.ParentNode;
import org.w3c.dom.Node;

public abstract class ChildNode
extends NodeImpl {
    protected ChildNode previousSibling;
    protected ChildNode nextSibling;
    protected ParentNode parentNode;

    protected ChildNode(DocumentImpl ownerDocument, OMFactory factory) {
        super(ownerDocument, factory);
    }

    protected ChildNode(OMFactory factory) {
        super(factory);
    }

    @Override
    public OMNode getNextOMSibling() throws OMException {
        while (this.nextSibling == null && this.parentNode != null && !this.parentNode.done) {
            this.parentNode.buildNext();
        }
        return this.nextSibling;
    }

    @Override
    public OMNode getNextOMSiblingIfAvailable() {
        return this.nextSibling;
    }

    @Override
    public Node getNextSibling() {
        return (Node)((Object)this.getNextOMSibling());
    }

    @Override
    public OMNode getPreviousOMSibling() {
        return this.previousSibling;
    }

    @Override
    public Node getPreviousSibling() {
        return this.previousSibling;
    }

    @Override
    public void setNextOMSibling(OMNode node) {
        if (node == null) {
            this.nextSibling = null;
            return;
        }
        if (!(node instanceof ChildNode)) {
            throw new OMException("The node is not a " + ChildNode.class);
        }
        this.nextSibling = (ChildNode)node;
    }

    @Override
    public void setPreviousOMSibling(OMNode node) {
        if (node == null) {
            this.previousSibling = null;
            return;
        }
        if (!(node instanceof ChildNode)) {
            throw new OMException("The node is not a " + ChildNode.class);
        }
        this.previousSibling = (ChildNode)node;
    }

    @Override
    public OMContainer getParent() throws OMException {
        return this.parentNode;
    }

    @Override
    public Node getParentNode() {
        return this.parentNode;
    }

    @Override
    public void setParent(OMContainer element) {
        if (element != null && !(element instanceof ParentNode)) {
            throw new OMException("The given parent is not of the type " + ParentNode.class);
        }
        this.parentNode = (ParentNode)element;
    }

    @Override
    public OMNode detach() throws OMException {
        if (this.parentNode == null) {
            throw new OMException("Parent level elements cannot be detached");
        }
        if (!this.done) {
            this.build();
        }
        this.getNextOMSibling();
        if (this.previousSibling == null) {
            if (this.nextSibling != null) {
                this.parentNode.setFirstChild(this.nextSibling);
            } else {
                this.parentNode.firstChild = null;
                this.parentNode.lastChild = null;
            }
        } else {
            this.previousSibling.setNextOMSibling(this.nextSibling);
            if (this.nextSibling == null) {
                this.previousSibling.parentNode.done = true;
            }
        }
        if (this.nextSibling != null) {
            this.nextSibling.setPreviousOMSibling(this.previousSibling);
        }
        if (this.parentNode != null && this.parentNode.lastChild == this) {
            this.parentNode.lastChild = this.previousSibling;
        }
        this.parentNode = null;
        return this;
    }

    @Override
    public void discard() throws OMException {
        throw new UnsupportedOperationException("Cannot discard this node");
    }

    @Override
    public void insertSiblingAfter(OMNode sibling) throws OMException {
        ChildNode domSibling;
        if (this.parentNode == null) {
            throw new OMException("Parent can not be null");
        }
        if (this == sibling) {
            throw new OMException("Inserting self as the sibling is not allowed");
        }
        ((OMNodeEx)sibling).setParent(this.parentNode);
        if (sibling instanceof ChildNode) {
            domSibling = (ChildNode)sibling;
            domSibling.previousSibling = this;
            if (this.nextSibling == null) {
                this.parentNode.setLastChild(sibling);
            } else {
                this.nextSibling.previousSibling = domSibling;
            }
        } else {
            throw new OMException("The given child is not of type " + ChildNode.class);
        }
        domSibling.nextSibling = this.nextSibling;
        this.nextSibling = domSibling;
    }

    @Override
    public void insertSiblingBefore(OMNode sibling) throws OMException {
        ChildNode siblingImpl;
        if (this.parentNode == null) {
            throw new OMException("Parent can not be null");
        }
        if (this == sibling) {
            throw new OMException("Inserting self as the sibling is not allowed");
        }
        if (sibling instanceof ChildNode) {
            siblingImpl = (ChildNode)sibling;
            siblingImpl.nextSibling = this;
            if (this.previousSibling == null) {
                this.parentNode.setFirstChild(siblingImpl);
                siblingImpl.previousSibling = null;
            } else {
                siblingImpl.setParent(this.parentNode);
                this.previousSibling.setNextOMSibling(siblingImpl);
                siblingImpl.setPreviousOMSibling(this.previousSibling);
            }
        } else {
            throw new OMException("The given child is not of type " + ChildNode.class);
        }
        this.previousSibling = siblingImpl;
    }

    @Override
    public Node cloneNode(boolean deep) {
        ChildNode newnode = (ChildNode)super.cloneNode(deep);
        newnode.previousSibling = null;
        newnode.nextSibling = null;
        newnode.isFirstChild(false);
        newnode.parentNode = null;
        return newnode;
    }
}

