/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.common.utils;

import java.io.IOException;
import java.io.PrintWriter;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.context.MessageContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.registry.common.ResourceData;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.securevault.SecretResolver;

public class CommonUtil {
    private static final Log log = LogFactory.getLog(CommonUtil.class);
    private static final String ERROR_TITILE = "<strong>Error while processing the request</strong><br/>";
    private static String LOGGED_USER = "logged-user";
    private static final long ONEMINUTE = 60000L;
    private static final long ONEHOUR = 3600000L;
    private static final long ONEDAY = 86400000L;

    public static UserRegistry getUserRegistry(HttpServletRequest request) throws RegistryException {
        UserRegistry userRegistry = (UserRegistry)request.getSession().getAttribute("user_registry");
        if (userRegistry == null) {
            String msg = "User's Registry instance is not found. Users have to login to retrieve a registry instance. ";
            log.error((Object)msg);
            throw new RegistryException(msg);
        }
        return userRegistry;
    }

    public static String getServiceVersion(OMElement element) {
        OMElement overview = element.getFirstChildWithName(new QName("Overview"));
        if (overview != null && overview.getFirstChildWithName(new QName("Version")) != null) {
            return overview.getFirstChildWithName(new QName("Version")).getText();
        }
        overview = element.getFirstChildWithName(new QName("http://www.wso2.org/governance/metadata", "overview"));
        if (overview != null && overview.getFirstChildWithName(new QName("http://www.wso2.org/governance/metadata", "version")) != null) {
            return overview.getFirstChildWithName(new QName("http://www.wso2.org/governance/metadata", "version")).getText();
        }
        return "";
    }

    public static UserRegistry getUserRegistry(RegistryService registryService) throws RegistryException {
        MessageContext messageContext = MessageContext.getCurrentMessageContext();
        if (messageContext == null) {
            String msg = "Could not get the user's Registry session. Message context not found.";
            log.error((Object)msg);
            throw new RegistryException(msg);
        }
        HttpServletRequest request = (HttpServletRequest)messageContext.getProperty("transport.http.servletRequest");
        return CommonUtil.getUserRegistry(registryService, request);
    }

    public static UserRegistry getUserRegistry(RegistryService registryService, HttpServletRequest request) throws RegistryException {
        UserRegistry registry = (UserRegistry)request.getSession().getAttribute("user_registry");
        if (registry == null) {
            String msg = "User's Registry instance is not found. Users have to login to retrieve a registry instance. ";
            log.error((Object)msg);
            throw new RegistryException(msg);
        }
        return registry;
    }

    public static UserRegistry getUserRegistry(RegistryService registryService, HttpSession session) throws RegistryException {
        String loggedUser;
        UserRegistry registry = (UserRegistry)session.getAttribute("user_registry");
        if (registry == null && (loggedUser = (String)session.getAttribute("logged-user")) != null) {
            registry = registryService.getUserRegistry(loggedUser);
            session.setAttribute("user_registry", (Object)registry);
        }
        if (registry == null) {
            String msg = "User's Registry instance is not found. Users have to login to retrieve a registry instance. ";
            log.error((Object)msg);
            throw new RegistryException(msg);
        }
        return registry;
    }

    public static void invalidateAllSessions(HttpServletRequest request) {
        request.getSession().invalidate();
    }

    public static void sendContent(HttpServletResponse response, String msg) {
        try {
            PrintWriter out = response.getWriter();
            out.println(msg);
            out.flush();
            out.close();
        }
        catch (IOException e) {
            String sendError = "Failed to send message. Caused by " + e.getMessage() + "\nFollowing message was not send to the UI\n" + msg;
            log.error((Object)sendError, (Throwable)e);
        }
    }

    public static void sendErrorContent(HttpServletResponse response, String msg) {
        try {
            PrintWriter out = response.getWriter();
            out.println(ERROR_TITILE);
            out.println(msg);
            out.flush();
            out.close();
        }
        catch (IOException e) {
            String sendError = "Failed to send error content. Caused by " + e.getMessage() + "\nFollowing error was not send to the UI\n" + msg;
            log.error((Object)sendError, (Throwable)e);
        }
    }

    public static void addErrorMessage(HttpServletRequest request, String msg) {
        String errorMessage = (String)request.getSession().getAttribute("error.message");
        errorMessage = errorMessage == null ? "<li>" + msg + "</li>" : errorMessage + "<li>" + msg + "</li>";
        request.getSession().setAttribute("error.message", (Object)errorMessage);
    }

    public static void forwardToPage(HttpServletRequest request, HttpServletResponse response, String url) {
        String errorMsg = (String)request.getSession().getAttribute("error.message");
        if (errorMsg != null) {
            errorMsg = "<strong>Errors have occured while processing the request.</strong><br/><ul>" + errorMsg + "</ul>";
            request.getSession().setAttribute("error.message", (Object)errorMsg);
        }
        try {
            request.getRequestDispatcher(url).forward((ServletRequest)request, (ServletResponse)response);
        }
        catch (Exception e) {
            String msg = "Failed to generate the page " + url + ". " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
        }
    }

    public static void redirect(HttpServletResponse response, String url) {
        try {
            response.sendRedirect(url);
        }
        catch (IOException e) {
            String msg = "Failed to redirect to the URL " + url + ". \nCaused by " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
        }
    }

    public static String formatDate(Date dateToParse) {
        if (dateToParse == null) {
            return null;
        }
        Calendar now = Calendar.getInstance();
        Calendar date = Calendar.getInstance();
        date.setTime(dateToParse);
        String value = "";
        long timeDifference = now.getTimeInMillis() - date.getTimeInMillis();
        if (timeDifference > 0L && timeDifference < 86400000L) {
            long hours = 0L;
            if (now.getTimeInMillis() - date.getTimeInMillis() > 3600000L) {
                hours = (now.getTimeInMillis() - date.getTimeInMillis()) / 3600000L;
                value = value + hours + "h ";
            }
            if (hours < 6L) {
                long minutes = (now.getTimeInMillis() - date.getTimeInMillis()) / 60000L;
                value = value + (minutes - hours * 60L) + "m ";
            }
            value = value + "ago";
        } else {
            SimpleDateFormat formatter = new SimpleDateFormat("dd MMM HH:MM:ss");
            value = formatter.format(dateToParse);
            if (date.get(1) != now.get(1)) {
                formatter = new SimpleDateFormat("yyyy");
                value = value + " " + formatter.format(dateToParse);
            }
            value = "on " + value;
        }
        return value;
    }

    public static Date computeDate(String dateString) throws RegistryException {
        if (dateString == null || dateString.length() == 0) {
            return null;
        }
        SimpleDateFormat formatter = new SimpleDateFormat("MM/dd/yyyy");
        try {
            return formatter.parse(dateString);
        }
        catch (ParseException e) {
            String msg = "Date format is invalid: " + dateString;
            throw new RegistryException(msg, (Throwable)e);
        }
    }

    public static void populateAverageStars(ResourceData resourceData) {
        float tempRating = resourceData.getAverageRating() * 1000.0f;
        tempRating = Math.round(tempRating);
        resourceData.setAverageRating(tempRating /= 1000.0f);
        float averageRating = resourceData.getAverageRating();
        String[] averageStars = new String[5];
        for (int i = 0; i < 5; ++i) {
            float fraction;
            averageStars[i] = averageRating >= (float)(i + 1) ? "04" : (averageRating <= (float)i ? "00" : ((double)(fraction = averageRating - (float)i) <= 0.125 ? "00" : ((double)fraction > 0.125 && (double)fraction <= 0.375 ? "01" : ((double)fraction > 0.375 && (double)fraction <= 0.625 ? "02" : ((double)fraction > 0.625 && (double)fraction <= 0.875 ? "03" : "04")))));
        }
        resourceData.setAverageStars(averageStars);
    }

    public static String getServerBaseURL(HttpServletRequest request) {
        String reqURL = request.getRequestURL().toString();
        return reqURL.substring(0, reqURL.indexOf("/wso2registry"));
    }

    public static String generateOptionsFor(String value, String[] options) {
        StringBuffer ret = new StringBuffer();
        for (String option : options) {
            ret.append("<option value=\"");
            ret.append(option);
            ret.append("\"");
            if (option.equalsIgnoreCase(value)) {
                ret.append(" selected");
            }
            ret.append(">");
            ret.append(option);
            ret.append("</option>\n");
        }
        return ret.toString();
    }

    public static boolean isLatestVersion(String currentVersion, String lastUpdatedVersion) {
        return Long.parseLong(lastUpdatedVersion) == Long.parseLong(currentVersion);
    }

    public static Map<String, String> attributeArrayToMap(String[] array) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        if (array != null) {
            for (String item : array) {
                if (item == null) continue;
                String[] pair = item.split("\\|");
                map.put(pair[0], pair[1]);
            }
        }
        return map;
    }

    public static String[] mapToAttributeArray(Map<String, String> map) {
        LinkedList<String> list = new LinkedList<String>();
        for (Map.Entry<String, String> e : map.entrySet()) {
            list.add(e.getKey() + "|" + e.getValue());
        }
        return list.toArray(new String[list.size()]);
    }

    public static String getResolvedPassword(SecretResolver secretResolver, String configName, String password) {
        if (secretResolver != null && secretResolver.isInitialized()) {
            if (secretResolver.isTokenProtected("wso2registry." + configName + ".password")) {
                return secretResolver.resolve("wso2registry." + configName + ".password");
            }
            return password;
        }
        return password;
    }
}

