/*
 * Decompiled with CFR 0.152.
 */
package org.h2.java;

import java.util.ArrayList;
import org.h2.java.ClassObj;
import org.h2.java.Expr;
import org.h2.java.JavaParser;
import org.h2.java.MethodObj;
import org.h2.java.Type;

class NewExpr
implements Expr {
    ClassObj classObj;
    ArrayList<Expr> arrayInitExpr = new ArrayList();
    ArrayList<Expr> args = new ArrayList();
    final JavaParser context;

    NewExpr(JavaParser javaParser) {
        this.context = javaParser;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.arrayInitExpr.size() > 0) {
            if (this.classObj.isPrimitive) {
                stringBuilder.append("NEW_ARRAY(sizeof(" + this.classObj + ")");
                stringBuilder.append(", 1 ");
                for (Expr expr : this.arrayInitExpr) {
                    stringBuilder.append("* ").append(expr);
                }
                stringBuilder.append(")");
            } else {
                stringBuilder.append("NEW_OBJ_ARRAY(1 ");
                for (Expr expr : this.arrayInitExpr) {
                    stringBuilder.append("* ").append(expr);
                }
                stringBuilder.append(")");
            }
        } else {
            MethodObj methodObj = this.classObj.getMethod("init_obj", this.args);
            stringBuilder.append(JavaParser.toC(this.classObj.toString() + "." + methodObj.name)).append("(");
            int n = 0;
            for (Expr expr : this.args) {
                if (n++ > 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(expr);
            }
            stringBuilder.append(")");
        }
        return stringBuilder.toString();
    }

    @Override
    public Type getType() {
        Type type = new Type();
        type.classObj = this.classObj;
        type.arrayLevel = this.arrayInitExpr.size();
        return type;
    }
}

