/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.user.core.common;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.user.api.RealmConfiguration;
import org.wso2.carbon.user.core.AuthorizationManager;
import org.wso2.carbon.user.core.UserRealm;
import org.wso2.carbon.user.core.UserStoreException;
import org.wso2.carbon.user.core.UserStoreManager;
import org.wso2.carbon.user.core.claim.ClaimManager;
import org.wso2.carbon.user.core.claim.ClaimMapping;
import org.wso2.carbon.user.core.claim.DefaultClaimManager;
import org.wso2.carbon.user.core.claim.builder.ClaimBuilder;
import org.wso2.carbon.user.core.claim.builder.ClaimBuilderException;
import org.wso2.carbon.user.core.claim.dao.ClaimDAO;
import org.wso2.carbon.user.core.config.RealmConfigXMLProcessor;
import org.wso2.carbon.user.core.profile.DefaultProfileConfigurationManager;
import org.wso2.carbon.user.core.profile.ProfileConfiguration;
import org.wso2.carbon.user.core.profile.ProfileConfigurationManager;
import org.wso2.carbon.user.core.profile.builder.ProfileBuilderException;
import org.wso2.carbon.user.core.profile.builder.ProfileConfigurationBuilder;
import org.wso2.carbon.user.core.profile.dao.ProfileConfigDAO;
import org.wso2.carbon.user.core.util.DatabaseUtil;

public class DefaultRealm
implements UserRealm {
    private static Log log = LogFactory.getLog(DefaultRealm.class);
    private ClaimManager claimMan = null;
    private ProfileConfigurationManager profileMan = null;
    private DataSource dataSource = null;
    private RealmConfiguration realmConfig = null;
    private int tenantId;
    private UserStoreManager userStoreManager = null;
    private AuthorizationManager authzManager = null;
    private Map<String, Object> properties = null;

    @Override
    public void init(RealmConfiguration configBean, Map<String, ClaimMapping> claimMappings, Map<String, ProfileConfiguration> profileConfigs, int tenantId) throws UserStoreException {
        if (claimMappings == null) {
            claimMappings = this.loadDefaultClaimMapping();
        }
        if (profileConfigs == null) {
            profileConfigs = this.loadDefaultProfileConfiguration();
        }
        this.realmConfig = configBean;
        this.properties = new Hashtable<String, Object>();
        this.tenantId = tenantId;
        this.dataSource = DatabaseUtil.getRealmDataSource(this.realmConfig);
        this.properties.put("um.datasource", this.dataSource);
        this.claimMan = new DefaultClaimManager(claimMappings, this.dataSource, tenantId);
        this.profileMan = new DefaultProfileConfigurationManager(profileConfigs, this.dataSource, tenantId);
        this.initializeObjects();
    }

    @Override
    public void init(RealmConfiguration configBean, Map<String, Object> propertiesMap, int tenantId) throws UserStoreException {
        if (configBean == null) {
            configBean = this.loadDefaultRealmConfigs();
        }
        this.realmConfig = configBean;
        this.properties = new Hashtable<String, Object>();
        this.tenantId = tenantId;
        this.properties = propertiesMap;
        this.dataSource = (DataSource)this.properties.get("um.datasource");
        HashMap<String, ClaimMapping> claimMappings = new HashMap<String, ClaimMapping>();
        HashMap<String, ProfileConfiguration> profileConfigs = new HashMap<String, ProfileConfiguration>();
        this.populateProfileAndClaimMaps(claimMappings, profileConfigs);
        this.claimMan = new DefaultClaimManager(claimMappings, this.dataSource, tenantId);
        this.profileMan = new DefaultProfileConfigurationManager(profileConfigs, this.dataSource, tenantId);
        this.initializeObjects();
    }

    @Override
    public UserStoreManager getUserStoreManager() throws UserStoreException {
        return this.userStoreManager;
    }

    @Override
    public AuthorizationManager getAuthorizationManager() throws UserStoreException {
        return this.authzManager;
    }

    @Override
    public ClaimManager getClaimManager() throws UserStoreException {
        return this.claimMan;
    }

    @Override
    public ProfileConfigurationManager getProfileConfigurationManager() throws UserStoreException {
        return this.profileMan;
    }

    @Override
    public void cleanUp() throws UserStoreException {
    }

    @Override
    public RealmConfiguration getRealmConfiguration() throws UserStoreException {
        return this.realmConfig;
    }

    private void initializeObjects() throws UserStoreException {
        try {
            String value = this.realmConfig.getUserStoreClass();
            if (value == null) {
                log.info((Object)"System is functioning without user store writering ability. User add/edit/delete will not work");
            } else {
                this.userStoreManager = (UserStoreManager)this.createObjectWithOptions(value);
            }
            value = this.realmConfig.getAuthorizationManagerClass();
            if (value == null) {
                String message = "System cannot continue. Authorization writer is null";
                log.error((Object)message);
                throw new UserStoreException(message);
            }
            this.authzManager = (AuthorizationManager)this.createObjectWithOptions(value);
        }
        catch (UserStoreException e) {
            throw e;
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new UserStoreException(e.getMessage(), e);
        }
    }

    private Object createObjectWithOptions(String className) throws UserStoreException {
        Class[] initClassOpt1 = new Class[]{RealmConfiguration.class, Map.class, ClaimManager.class, ProfileConfigurationManager.class, UserRealm.class, Integer.class};
        Object[] initObjOpt1 = new Object[]{this.realmConfig, this.properties, this.claimMan, this.profileMan, this, this.tenantId};
        Class[] initClassOpt2 = new Class[]{RealmConfiguration.class, Map.class, ClaimManager.class, ProfileConfigurationManager.class, UserRealm.class};
        Object[] initObjOpt2 = new Object[]{this.realmConfig, this.properties, this.claimMan, this.profileMan, this};
        Class[] initClassOpt3 = new Class[]{RealmConfiguration.class, Map.class};
        Object[] initObjOpt3 = new Object[]{this.realmConfig, this.properties};
        try {
            Class<?> clazz = Class.forName(className);
            Constructor<?> constructor = null;
            Object newObject = null;
            if (log.isDebugEnabled()) {
                log.debug((Object)"Start initializing class with the first option");
            }
            try {
                constructor = clazz.getConstructor(initClassOpt1);
                newObject = constructor.newInstance(initObjOpt1);
                return newObject;
            }
            catch (NoSuchMethodException e) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Cannont initialize " + className + " using the option 1"));
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)"End initializing class with the first option");
                }
                try {
                    constructor = clazz.getConstructor(initClassOpt2);
                    newObject = constructor.newInstance(initObjOpt2);
                    return newObject;
                }
                catch (NoSuchMethodException e2) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Cannont initialize " + className + " using the option 2"));
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"End initializing class with the second option");
                    }
                    try {
                        constructor = clazz.getConstructor(initClassOpt3);
                        newObject = constructor.newInstance(initObjOpt3);
                        return newObject;
                    }
                    catch (NoSuchMethodException e3) {
                        String message = "Cannot initialize " + className + ". Error " + e3.getMessage();
                        log.error((Object)message);
                        throw new UserStoreException(message);
                    }
                }
            }
        }
        catch (Throwable e) {
            log.error((Object)("Cannot create " + className), e);
            throw new UserStoreException(e.getMessage() + "Type " + e.getClass(), e);
        }
    }

    private RealmConfiguration loadDefaultRealmConfigs() throws UserStoreException {
        RealmConfigXMLProcessor processor = new RealmConfigXMLProcessor();
        RealmConfiguration config = processor.buildRealmConfigurationFromFile();
        return config;
    }

    private Map<String, ClaimMapping> loadDefaultClaimMapping() throws UserStoreException {
        try {
            ClaimBuilder claimBuilder = new ClaimBuilder(this.tenantId);
            Map<String, ClaimMapping> claimMapping = claimBuilder.buildClaimMappingsFromConfigFile();
            return claimMapping;
        }
        catch (ClaimBuilderException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new UserStoreException(e.getMessage(), e);
        }
    }

    private Map<String, ProfileConfiguration> loadDefaultProfileConfiguration() throws UserStoreException {
        try {
            ProfileConfigurationBuilder profilBuilder = new ProfileConfigurationBuilder(this.tenantId);
            Map<String, ProfileConfiguration> profileConfig = profilBuilder.buildProfileConfigurationFromConfigFile();
            return profileConfig;
        }
        catch (ProfileBuilderException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new UserStoreException(e.getMessage(), e);
        }
    }

    private void populateProfileAndClaimMaps(Map<String, ClaimMapping> claimMappings, Map<String, ProfileConfiguration> profileConfigs) throws UserStoreException {
        ClaimDAO claimDAO = new ClaimDAO(this.dataSource, this.tenantId);
        ProfileConfigDAO profileDAO = new ProfileConfigDAO(this.dataSource, this.tenantId);
        ClaimBuilder claimBuilder = new ClaimBuilder(this.tenantId);
        ProfileConfigurationBuilder profileBilder = new ProfileConfigurationBuilder(this.tenantId);
        int count = claimDAO.getDialectCount();
        if (count == 0) {
            try {
                claimMappings.putAll(claimBuilder.buildClaimMappingsFromConfigFile());
            }
            catch (ClaimBuilderException e) {
                String msg = "Error in building claims.";
                log.error((Object)msg);
                throw new UserStoreException(msg, e);
            }
            claimDAO.addCliamMappings(claimMappings.values().toArray(new ClaimMapping[claimMappings.size()]));
            try {
                profileConfigs.putAll(profileBilder.buildProfileConfigurationFromConfigFile());
            }
            catch (ProfileBuilderException e) {
                String msg = "Error in building the profile.";
                log.error((Object)msg);
                throw new UserStoreException(msg, e);
            }
            profileDAO.addProfileConfig(profileConfigs.values().toArray(new ProfileConfiguration[profileConfigs.size()]));
        } else {
            try {
                claimMappings.putAll(claimBuilder.buildClaimMappingsFromDatabase(this.dataSource, "Internal"));
            }
            catch (ClaimBuilderException e) {
                String msg = "Error in building claims.";
                log.error((Object)msg);
                throw new UserStoreException(msg, e);
            }
            try {
                profileConfigs.putAll(profileBilder.buildProfileConfigurationFromDatabase(this.dataSource, "Internal"));
            }
            catch (ProfileBuilderException e) {
                String msg = "Error in building the profile.";
                log.error((Object)msg);
                throw new UserStoreException(msg, e);
            }
        }
    }
}

