/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.core.persistence;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.util.AXIOMUtil;
import org.apache.axiom.om.xpath.AXIOMXPath;
import org.apache.axis2.AxisFault;
import org.apache.axis2.description.AxisDescription;
import org.apache.axis2.description.AxisModule;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.neethi.Policy;
import org.apache.neethi.PolicyEngine;
import org.jaxen.JaxenException;
import org.wso2.carbon.CarbonException;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.context.RegistryType;
import org.wso2.carbon.core.persistence.ModulePersistenceManager;
import org.wso2.carbon.core.persistence.OperationPersistenceManager;
import org.wso2.carbon.core.persistence.PersistenceDataNotFoundException;
import org.wso2.carbon.core.persistence.PersistenceException;
import org.wso2.carbon.core.persistence.PersistenceFactory;
import org.wso2.carbon.core.persistence.PersistenceUtils;
import org.wso2.carbon.core.persistence.ServiceGroupPersistenceManager;
import org.wso2.carbon.core.persistence.ServicePersistenceManager;
import org.wso2.carbon.core.persistence.file.AbstractFilePersistenceManager;
import org.wso2.carbon.core.persistence.file.ModuleFilePersistenceManager;
import org.wso2.carbon.core.persistence.file.ServiceGroupFilePersistenceManager;
import org.wso2.carbon.core.util.ParameterUtil;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;

public abstract class AbstractPersistenceManager {
    private static final Log log = LogFactory.getLog(AbstractPersistenceManager.class);
    protected static final Object WRITE_LOCK = new Object();
    protected Registry configRegistry;
    protected AxisConfiguration axisConfig;
    protected PersistenceFactory pf;
    protected AbstractFilePersistenceManager fpm;
    protected OMFactory omFactory = OMAbstractFactory.getOMFactory();

    protected AbstractPersistenceManager(AxisConfiguration axisConfig, AbstractFilePersistenceManager fpm, PersistenceFactory pf) throws AxisFault {
        this.axisConfig = axisConfig;
        this.pf = pf;
        this.fpm = fpm;
        try {
            this.configRegistry = (Registry)PrivilegedCarbonContext.getCurrentContext((AxisConfiguration)axisConfig).getRegistry(RegistryType.SYSTEM_CONFIGURATION);
        }
        catch (Exception e) {
            log.error((Object)"Error while retrieving config registry from Axis configuration", (Throwable)e);
        }
        if (this.configRegistry == null) {
            throw new AxisFault("Configuration Registry is not available");
        }
    }

    protected AbstractPersistenceManager(AxisConfiguration axisConfig) throws AxisFault {
        this.axisConfig = axisConfig;
        try {
            this.configRegistry = (Registry)PrivilegedCarbonContext.getCurrentContext((AxisConfiguration)axisConfig).getRegistry(RegistryType.SYSTEM_CONFIGURATION);
        }
        catch (Exception e) {
            log.error((Object)"Error while retrieving config registry from Axis configuration", (Throwable)e);
        }
        if (this.configRegistry == null) {
            throw new AxisFault("Configuration Registry is not available");
        }
    }

    public void updateParameter(String resourceId, Parameter parameter, String xpathStrOfParent) throws XMLStreamException, IOException, PersistenceException, JaxenException {
        String paramName = parameter.getName();
        int paramType = parameter.getParameterType();
        boolean locked = parameter.isLocked();
        if (paramName != null && paramName.trim().length() != 0) {
            if (parameter.getParameterElement() == null && parameter.getValue() != null && parameter.getValue() instanceof String) {
                try {
                    parameter = ParameterUtil.createParameter(paramName.trim(), (String)parameter.getValue(), locked);
                }
                catch (AxisFault ignore) {
                    // empty catch block
                }
            }
            if (parameter.getParameterElement() != null) {
                boolean isTransactionStarted = this.getCurrentFPM().isTransactionStarted(resourceId);
                if (!isTransactionStarted) {
                    this.getCurrentFPM().beginTransaction(resourceId);
                }
                String paramXPath = xpathStrOfParent.equals("/") ? xpathStrOfParent + "parameter" + PersistenceUtils.getXPathAttrPredicate("name", paramName) : xpathStrOfParent + "/" + "parameter" + PersistenceUtils.getXPathAttrPredicate("name", paramName);
                OMElement paramElement = (OMElement)this.getCurrentFPM().get(resourceId, paramXPath);
                if (paramElement == null) {
                    paramElement = parameter.getParameterElement().cloneOMElement();
                    Iterator itr = paramElement.getAllDeclaredNamespaces();
                    while (itr.hasNext()) {
                        itr.next();
                        itr.remove();
                    }
                } else {
                    String name = paramElement.getAttributeValue(new QName("name"));
                    String type = paramElement.getAttributeValue(new QName("type"));
                    String content = paramElement.toString();
                    if (name != null && name.equals(paramName) && type != null && type.equals(Integer.toString(paramType)) && content != null && content.equals(parameter.getParameterElement().toString())) {
                        if (!isTransactionStarted) {
                            this.getCurrentFPM().rollbackTransaction(resourceId);
                        }
                        return;
                    }
                    if (parameter.getParameterType() == 1) {
                        paramElement.setText(parameter.getValue().toString());
                    } else if (parameter.getParameterType() == 2) {
                        paramElement.addChild((OMNode)((OMElement)parameter.getValue()));
                    } else if (parameter.getValue() instanceof OMNode) {
                        paramElement.addChild((OMNode)parameter.getValue());
                    } else {
                        log.error((Object)("Not persisting the parameter because parameter is not recognized " + paramName + paramType));
                    }
                }
                paramElement.addAttribute("name", paramName, null);
                paramElement.addAttribute("type", Integer.toString(paramType), null);
                if (parameter.isLocked()) {
                    paramElement.addAttribute("locked", Boolean.TRUE.toString(), null);
                }
                this.getCurrentFPM().put(resourceId, paramElement, xpathStrOfParent);
                if (!isTransactionStarted) {
                    this.getCurrentFPM().commitTransaction(resourceId);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String convertStreamToString(InputStream is) {
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader(is));
            String string = reader.readLine();
            return string;
        }
        catch (IOException e) {
            log.error((Object)"Error while reading Input Stream");
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return null;
    }

    protected void removeParameter(String resourceId, String paramName, String xpathStr) throws Exception {
        this.removeResource(resourceId, xpathStr + "/" + "parameter" + PersistenceUtils.getXPathAttrPredicate("name", paramName));
    }

    protected void removeResource(String resourceId, String xpathStr) throws Exception {
        try {
            this.getCurrentFPM().beginTransaction(resourceId);
            if (this.getCurrentFPM().elementExists(resourceId, xpathStr)) {
                this.getCurrentFPM().delete(resourceId, xpathStr);
            }
            this.getCurrentFPM().commitTransaction(resourceId);
        }
        catch (Throwable e) {
            this.handleExceptionWithRollback(resourceId, "Unable to remove the resource " + resourceId, e);
        }
    }

    protected void handleModuleForAxisDescription(String serviceGroupId, AxisModule module, String xpathStr, boolean engage) throws Exception {
        boolean isStarted = this.getServiceGroupFilePM().isTransactionStarted(serviceGroupId);
        if (!isStarted) {
            this.getServiceGroupFilePM().beginTransaction(serviceGroupId);
        }
        String version = PersistenceUtils.getModuleVersion(module);
        if (engage) {
            OMElement moduleElement = PersistenceUtils.createModule(module.getName(), version, "engagedModules");
            this.getServiceGroupFilePM().put(serviceGroupId, moduleElement, xpathStr);
        } else {
            OMElement moduleElement = (OMElement)this.getServiceGroupFilePM().get(serviceGroupId, xpathStr + "/" + "module" + PersistenceUtils.getXPathAttrPredicate("name", module.getName()) + PersistenceUtils.getXPathAttrPredicate("version", version));
            moduleElement.detach();
            this.getServiceGroupFilePM().setMetaFileModification(serviceGroupId);
        }
        if (!isStarted) {
            this.getServiceGroupFilePM().commitTransaction(serviceGroupId);
        }
    }

    protected void loadParameters(String resourceId, AxisDescription ad, String xpathStrOfParameter) throws Exception {
        if (this.getCurrentFPM().fileExists(resourceId)) {
            AXIOMXPath xpathExpression = new AXIOMXPath(xpathStrOfParameter);
            List matchedNodes = xpathExpression.selectNodes((Object)this.getCurrentFPM().get(resourceId));
            for (Object node : matchedNodes) {
                OMElement paramEl = (OMElement)node;
                Parameter parameter = ParameterUtil.createParameter(paramEl);
                Parameter p = ad.getParameter(paramEl.getAttributeValue(new QName("name")));
                if (p != null && p.isLocked()) continue;
                ad.addParameter(parameter);
            }
        }
    }

    protected void writeParameters(String resourceId, ArrayList<Parameter> paramList, String xpathStrOfParent) throws Exception {
        for (Parameter o : paramList) {
            Parameter parameter = o;
            String paramName = parameter.getName();
            if (paramName == null || paramName.trim().length() == 0) continue;
            if (parameter.getParameterElement() == null && parameter.getValue() != null && parameter.getValue() instanceof String) {
                parameter = ParameterUtil.createParameter(paramName.trim(), (String)parameter.getValue());
            }
            if (parameter.getParameterElement() == null) continue;
            OMElement paramElement = parameter.getParameterElement().cloneOMElement();
            Iterator itr = paramElement.getAllDeclaredNamespaces();
            while (itr.hasNext()) {
                itr.next();
                itr.remove();
            }
            paramElement.setText(parameter.getParameterElement().getText());
            paramElement.addAttribute("name", parameter.getName(), null);
            this.getCurrentFPM().put(resourceId, paramElement, xpathStrOfParent);
        }
    }

    protected void writeAxisDescription(String serviceGroupId, AxisDescription ad, String nameProperty, String xpathStr) throws PersistenceException {
        OMElement opParent = (OMElement)this.getServiceGroupFilePM().get(serviceGroupId, xpathStr);
        OMElement operation = this.omFactory.createOMElement("operation", null);
        String doc = ad.getDocumentation();
        if (doc != null) {
            operation.addAttribute("serviceDocumentation", doc, null);
        }
        operation.addAttribute("name", nameProperty, null);
        opParent.addChild((OMNode)operation);
    }

    protected List getPropertyValues(String resourcePath, String property) throws RegistryException {
        return null;
    }

    protected void loadDocumentation(String serviceGroupId, AxisDescription ad, String resourceXPath) throws RegistryException, PersistenceDataNotFoundException {
        OMAttribute docAttr = this.getServiceGroupFilePM().getAttribute(serviceGroupId, resourceXPath + "/@" + "serviceDocumentation");
        if (docAttr != null) {
            String documentation = docAttr.getAttributeValue();
            try {
                ad.setDocumentation((OMNode)AXIOMUtil.stringToOM((String)documentation));
            }
            catch (Exception e) {
                ad.setDocumentation(documentation);
            }
        }
    }

    protected void loadPolicies(String serviceGroupId, AxisDescription ad, List policyIdList, String serviceXPath) throws RegistryException, PersistenceDataNotFoundException {
        if (ad == null) {
            return;
        }
        ad.getPolicySubject().clear();
        if (policyIdList != null) {
            for (Object node : policyIdList) {
                OMElement servicePolicyEl = (OMElement)node;
                String currentPolicyUUID = servicePolicyEl.getText();
                String policyResourcePath = serviceXPath + "/" + "policies" + "/" + "policy" + PersistenceUtils.getXPathTextPredicate("policyUUID", currentPolicyUUID);
                OMElement policyElement = (OMElement)this.getServiceGroupFilePM().get(serviceGroupId, policyResourcePath);
                if (policyElement != null) {
                    Policy policy = PolicyEngine.getPolicy((OMElement)policyElement.getFirstChildWithName(new QName("http://schemas.xmlsoap.org/ws/2004/09/policy", "Policy")));
                    ad.getPolicySubject().attachPolicy(policy);
                    continue;
                }
                log.error((Object)("Failed to load Policy with ID " + currentPolicyUUID + ". The Policy does not exist. " + serviceGroupId));
            }
        }
    }

    protected boolean isGloballyEngaged(String moduleName, String moduleVersion) {
        if (this.getModuleFilePM().fileExists(moduleName)) {
            if (moduleVersion == null) {
                moduleVersion = "undefined";
            }
            try {
                OMElement module = (OMElement)this.getModuleFilePM().get(moduleName, "/version" + PersistenceUtils.getXPathAttrPredicate("id", moduleVersion));
                return Boolean.parseBoolean(module.getAttributeValue(new QName("globallyEngaged")));
            }
            catch (PersistenceDataNotFoundException e) {
                log.error((Object)("Couldn't retrieve data for " + moduleName + moduleVersion), (Throwable)e);
                return false;
            }
        }
        return false;
    }

    protected AxisModule getExistingAxisModule(String moduleName, String moduleVersion) throws Exception {
        AxisModule existingModule = null;
        ModuleFilePersistenceManager mpm = this.pf.getModuleFilePM();
        if (moduleVersion == null) {
            moduleVersion = "undefined";
        }
        if (mpm.fileExists(moduleName)) {
            OMElement module = (OMElement)mpm.get(moduleName, "/version" + PersistenceUtils.getXPathAttrPredicate("id", moduleVersion));
            existingModule = this.getAxisModule(moduleName, module);
        }
        if (existingModule == null) {
            Object node;
            OMElement module;
            List moduleVersionsList = mpm.getAll(moduleName, "/version");
            Iterator i$ = moduleVersionsList.iterator();
            while (i$.hasNext() && (existingModule = this.getAxisModule(moduleName, module = (OMElement)(node = i$.next()))) == null) {
            }
        }
        if (existingModule == null) {
            throw new CarbonException("Axis Module not found for : " + moduleName + "-" + moduleVersion);
        }
        return existingModule;
    }

    protected void handleExceptionWithRollback(String resourceId, String msg, Throwable e) throws PersistenceException {
        log.error((Object)msg, e);
        this.getCurrentFPM().rollbackTransaction(resourceId);
        throw new PersistenceException(msg, e);
    }

    protected void handleException(String msg, Throwable e) throws PersistenceException {
        log.error((Object)msg, e);
        throw new PersistenceException(msg, e);
    }

    protected void handleException(String msg) throws PersistenceException {
        log.error((Object)msg);
        throw new PersistenceException(msg);
    }

    private AxisModule getAxisModule(String moduleName, OMElement moduleElement) {
        String moduleVersion = null;
        String tmp = moduleElement.getAttributeValue(new QName("version"));
        if (!"undefined".equals(tmp)) {
            moduleVersion = tmp;
        }
        return this.axisConfig.getModule(moduleName, moduleVersion);
    }

    public String getProperty(OMElement resource, String xpathStr) {
        try {
            AXIOMXPath xpathExpression = new AXIOMXPath(xpathStr);
            OMAttribute attr = (OMAttribute)xpathExpression.selectSingleNode((Object)resource);
            return attr.getAttributeValue();
        }
        catch (JaxenException e) {
            log.error((Object)("XPath evaluation failed for " + xpathStr), (Throwable)e);
            return null;
        }
    }

    public AbstractFilePersistenceManager getCurrentFPM() {
        return this.fpm;
    }

    public ServiceGroupFilePersistenceManager getServiceGroupFilePM() {
        if (this instanceof ServiceGroupPersistenceManager || this instanceof ServicePersistenceManager || this instanceof OperationPersistenceManager) {
            return (ServiceGroupFilePersistenceManager)this.fpm;
        }
        return this.pf.getServiceGroupFilePM();
    }

    public ModuleFilePersistenceManager getModuleFilePM() {
        if (this instanceof ModulePersistenceManager) {
            return (ModuleFilePersistenceManager)this.fpm;
        }
        return this.pf.getModuleFilePM();
    }

    public void persistPolicyToRegistry(Policy policy, String policyType, String servicePath) throws RegistryException, XMLStreamException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Persisting caching policy in the registry");
        }
        Resource policyResource = PersistenceUtils.createPolicyResource(this.configRegistry, policy, policy.getId(), policyType);
        String policyResourcePath = servicePath + "/policies/" + policy.getId();
        try {
            this.configRegistry.put(policyResourcePath, policyResource);
        }
        catch (Exception e) {
            String msg = "Error persisting caching policy in the configRegistry.";
            log.error((Object)msg, (Throwable)e);
            this.configRegistry.rollbackTransaction();
            throw new RegistryException(e.getMessage(), (Throwable)e);
        }
    }
}

