/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.core.dispatchers;

import java.io.File;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.deployment.DeploymentException;
import org.apache.axis2.deployment.repository.util.DeploymentFileData;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.HandlerDescription;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.AbstractDispatcher;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.Handler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.CarbonConstants;
import org.wso2.carbon.core.util.GhostDispatcherUtils;
import org.wso2.carbon.utils.CarbonUtils;
import org.wso2.carbon.utils.deployment.GhostDeployer;
import org.wso2.carbon.utils.deployment.GhostDeployerUtils;

public class GhostDispatcher
extends AbstractDispatcher {
    private static Log log = LogFactory.getLog(GhostDispatcher.class);
    private static final String NAME = "GhostDispatcher";

    public Handler.InvocationResponse invoke(MessageContext msgctx) throws AxisFault {
        if (msgctx.getAxisService() == null) {
            AxisService transitService = GhostDeployerUtils.dispatchServiceFromTransitGhosts((MessageContext)msgctx);
            if (transitService != null) {
                this.handleTransitGhostService(transitService, msgctx);
            }
            return Handler.InvocationResponse.CONTINUE;
        }
        AxisService service = this.findService(msgctx);
        if (service != null) {
            this.findOperation(service, msgctx);
        }
        if (msgctx.getAxisService() != null) {
            GhostDeployerUtils.updateLastUsedTime((AxisService)msgctx.getAxisService());
        }
        return Handler.InvocationResponse.CONTINUE;
    }

    public AxisOperation findOperation(AxisService service, MessageContext messageContext) {
        AxisOperation existingOperation;
        AxisOperation newOperation = null;
        if (service != null && messageContext.getAxisOperation() != null && (newOperation = service.getOperation((existingOperation = messageContext.getAxisOperation()).getName())) != null) {
            messageContext.setAxisOperation(newOperation);
        }
        return newOperation;
    }

    public AxisService findService(MessageContext messageContext) throws AxisFault {
        AxisService dispatchedService = messageContext.getAxisService();
        AxisService newService = null;
        if (GhostDeployerUtils.isGhostService((AxisService)dispatchedService)) {
            AxisConfiguration axisConfig = messageContext.getConfigurationContext().getAxisConfiguration();
            if (CarbonUtils.isDepSyncEnabled() && CarbonUtils.isWorkerNode()) {
                GhostDispatcherUtils.handleDepSynchUpdate(axisConfig, dispatchedService);
            }
            try {
                newService = GhostDeployerUtils.deployActualService((AxisConfiguration)axisConfig, (AxisService)dispatchedService);
                this.deployServiceMetaFile(newService, axisConfig);
            }
            catch (AxisFault e) {
                log.error((Object)"Error deploying service. ", (Throwable)e);
                throw e;
            }
            if (newService != null) {
                messageContext.setAxisService(newService);
                messageContext.removeProperty("AxisBindingMessage");
            }
        }
        return newService;
    }

    private void deployServiceMetaFile(AxisService axisService, AxisConfiguration axisConfig) {
        String axisRepo = axisConfig.getRepository().getPath();
        if (axisRepo.contains(CarbonConstants.TENANTS_REPO)) {
            String serviceMetaFileDirPath = axisRepo + File.separator + "servicemetafiles";
            String serviceMetaFilePath = serviceMetaFileDirPath + File.separator + axisService.getAxisServiceGroup().getServiceGroupName() + ".xml";
            GhostDeployer ghostDeployer = GhostDeployerUtils.getGhostDeployer((AxisConfiguration)axisConfig);
            File serviceMetaFile = new File(serviceMetaFilePath);
            if (serviceMetaFile.exists()) {
                DeploymentFileData metaFileDFD = new DeploymentFileData(serviceMetaFile);
                metaFileDFD.setDeployer(ghostDeployer.getDeployer("servicemetafiles", "xml"));
                try {
                    metaFileDFD.deploy();
                }
                catch (DeploymentException e) {
                    log.error((Object)("Error while deploying service metafile : " + serviceMetaFile));
                }
            }
        }
    }

    public void initDispatcher() {
        this.init(new HandlerDescription(NAME));
    }

    private void findServiceAndOperation(String serviceName, MessageContext msgctx) throws AxisFault {
        AxisService newService = null;
        AxisConfiguration axisConfig = msgctx.getConfigurationContext().getAxisConfiguration();
        AxisService ghostService = axisConfig.getService(serviceName);
        Parameter dispatchedGhostParam = ghostService.getParameter("GhostService");
        if (dispatchedGhostParam != null && "true".equals(dispatchedGhostParam.getValue()) && (newService = GhostDeployerUtils.deployActualService((AxisConfiguration)axisConfig, (AxisService)ghostService)) != null) {
            msgctx.setAxisService(newService);
            msgctx.removeProperty("AxisBindingMessage");
        }
        if (newService != null) {
            this.findOperation(newService, msgctx);
        }
        if (msgctx.getAxisService() != null) {
            GhostDeployerUtils.updateLastUsedTime((AxisService)msgctx.getAxisService());
        }
    }

    private void handleTransitGhostService(AxisService transitService, MessageContext msgctx) throws AxisFault {
        Parameter isUnloadingParam = transitService.getParameter("isBeingUnloaded");
        if (isUnloadingParam != null && "true".equals(isUnloadingParam.getValue())) {
            GhostDeployerUtils.waitForServiceToLeaveTransit((String)transitService.getName(), (AxisConfiguration)msgctx.getConfigurationContext().getAxisConfiguration());
            this.findServiceAndOperation(transitService.getName(), msgctx);
        } else {
            GhostDeployerUtils.waitForServiceToLeaveTransit((String)transitService.getName(), (AxisConfiguration)msgctx.getConfigurationContext().getAxisConfiguration());
        }
    }
}

