/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.core.deployment;

import java.util.UUID;
import org.apache.axis2.clustering.ClusteringAgent;
import org.apache.axis2.clustering.ClusteringFault;
import org.apache.axis2.clustering.ClusteringMessage;
import org.apache.axis2.deployment.RepositoryListener;
import org.apache.axis2.deployment.scheduler.SchedulerTask;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.core.deployment.DeploymentSynchronizer;
import org.wso2.carbon.core.deployment.SynchronizeRepositoryRequest;
import org.wso2.carbon.core.internal.CarbonCoreDataHolder;
import org.wso2.carbon.utils.CarbonUtils;
import org.wso2.carbon.utils.deployment.GhostDeployerUtils;
import org.wso2.carbon.utils.deployment.GhostMetaArtifactsLoader;

public class CarbonDeploymentSchedulerTask
extends SchedulerTask {
    private static final Log log = LogFactory.getLog(CarbonDeploymentSchedulerTask.class);
    private int tenantId;
    private String tenantDomain;
    private boolean isInitialUpdateDone;
    private boolean isRepoUpdateFailed;
    private AxisConfiguration axisConfig;

    public CarbonDeploymentSchedulerTask(RepositoryListener listener, AxisConfiguration axisConfig, int tenantId, String tenantDomain) {
        super(listener, axisConfig);
        this.tenantId = tenantId;
        this.tenantDomain = tenantDomain;
        this.axisConfig = axisConfig;
    }

    public synchronized void runAxisDeployment() {
        super.run();
        if (GhostDeployerUtils.isGhostOn() && CarbonUtils.isWorkerNode() && this.tenantId > 0) {
            this.doInitialGhostArtifactDeployement();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doInitialGhostArtifactDeployement() {
        BundleContext bundleContext = CarbonCoreDataHolder.getInstance().getBundleContext();
        ServiceReference reference = bundleContext.getServiceReference(GhostMetaArtifactsLoader.class.getName());
        if (reference != null) {
            ServiceTracker serviceTracker = new ServiceTracker(bundleContext, GhostMetaArtifactsLoader.class.getName(), null);
            try {
                serviceTracker.open();
                for (Object obj : serviceTracker.getServices()) {
                    GhostMetaArtifactsLoader artifactsLoader = (GhostMetaArtifactsLoader)obj;
                    artifactsLoader.loadArtifacts(this.axisConfig, this.tenantDomain);
                }
            }
            catch (Throwable t) {
                log.error((Object)("Ghost meta artifacts loading for tenant " + this.tenantId + " failed"), t);
            }
            finally {
                serviceTracker.close();
            }
        }
    }

    public synchronized void run() {
        try {
            PrivilegedCarbonContext carbonContext = PrivilegedCarbonContext.getThreadLocalCarbonContext();
            carbonContext.setTenantId(this.tenantId);
            carbonContext.setTenantDomain(this.tenantDomain);
            carbonContext.setApplicationName(null);
            this.deploymentSyncUpdate();
            this.runAxisDeployment();
            boolean isRepoChanged = this.deploymentSyncCommit();
            if (isRepoChanged) {
                this.sendRepositorySyncMessage();
            }
        }
        catch (Throwable t) {
            log.error((Object)"Error while running deployment synchronizer", t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deploymentSyncUpdate() {
        BundleContext bundleContext;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Running deployment synchronizer update...");
        }
        if ((bundleContext = CarbonCoreDataHolder.getInstance().getBundleContext()) == null) {
            return;
        }
        ServiceReference reference = bundleContext.getServiceReference(DeploymentSynchronizer.class.getName());
        if (reference != null) {
            ServiceTracker serviceTracker = new ServiceTracker(bundleContext, DeploymentSynchronizer.class.getName(), null);
            try {
                serviceTracker.open();
                for (Object obj : serviceTracker.getServices()) {
                    DeploymentSynchronizer depsync = (DeploymentSynchronizer)obj;
                    if (this.isInitialUpdateDone && !this.isRepoUpdateFailed) continue;
                    depsync.update(this.tenantId);
                    this.isInitialUpdateDone = true;
                    this.isRepoUpdateFailed = false;
                }
            }
            catch (Exception e) {
                log.error((Object)("Deployment synchronization update for tenant " + this.tenantId + " failed"), (Throwable)e);
            }
            finally {
                serviceTracker.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean deploymentSyncCommit() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Running deployment synchronizer commit...");
        }
        boolean isFilesCommitted = false;
        BundleContext bundleContext = CarbonCoreDataHolder.getInstance().getBundleContext();
        ServiceReference reference = bundleContext.getServiceReference(DeploymentSynchronizer.class.getName());
        if (reference != null) {
            ServiceTracker serviceTracker = new ServiceTracker(bundleContext, DeploymentSynchronizer.class.getName(), null);
            try {
                serviceTracker.open();
                for (Object obj : serviceTracker.getServices()) {
                    DeploymentSynchronizer depsync = (DeploymentSynchronizer)obj;
                    isFilesCommitted = depsync.commit(this.tenantId);
                    if (!isFilesCommitted) continue;
                    break;
                }
            }
            catch (Exception e) {
                log.error((Object)("Deployment synchronization commit for tenant " + this.tenantId + " failed"), (Throwable)e);
            }
            finally {
                serviceTracker.close();
            }
        }
        return isFilesCommitted;
    }

    private void sendRepositorySyncMessage() {
        ClusteringAgent clusteringAgent = CarbonCoreDataHolder.getInstance().getMainServerConfigContext().getAxisConfiguration().getClusteringAgent();
        if (clusteringAgent != null) {
            int numberOfRetries = 0;
            UUID messageId = UUID.randomUUID();
            SynchronizeRepositoryRequest request = new SynchronizeRepositoryRequest(this.tenantId, this.tenantDomain, messageId);
            while (numberOfRetries < 60) {
                try {
                    clusteringAgent.sendMessage((ClusteringMessage)request, true);
                    log.info((Object)("Sent [" + (Object)((Object)request) + "]"));
                    break;
                }
                catch (ClusteringFault e) {
                    if (++numberOfRetries < 60) {
                        log.warn((Object)("Could not send SynchronizeRepositoryRequest for tenant " + this.tenantId + ". Retry will be attempted in 2s. Request: " + (Object)((Object)request)), (Throwable)e);
                    } else {
                        log.error((Object)("Could not send SynchronizeRepositoryRequest for tenant " + this.tenantId + ". Several retries failed. Request:" + (Object)((Object)request)), (Throwable)e);
                    }
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException ignored) {}
                }
            }
        }
    }

    public void setRepoUpdateFailed() {
        this.isRepoUpdateFailed = true;
    }
}

