/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.synchronization;

import java.io.File;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.registry.synchronization.SynchronizationException;
import org.wso2.carbon.registry.synchronization.operation.CheckInCommand;
import org.wso2.carbon.registry.synchronization.operation.CheckOutCommand;
import org.wso2.carbon.registry.synchronization.operation.UpdateCommand;

public final class RegistrySynchronizer {
    private RegistrySynchronizer() {
    }

    public static void checkIn(UserRegistry registry, String filePath, String registryPath, boolean silentUpdate, boolean forcedCheckIn) throws SynchronizationException {
        CheckInCommand operation = new CheckInCommand(null, filePath, registryPath, registry.getUserName(), true, silentUpdate, !forcedCheckIn);
        operation.execute(registry);
    }

    public static void checkIn(UserRegistry registry, String filePath, String registryPath, boolean silentUpdate) throws SynchronizationException {
        RegistrySynchronizer.checkIn(registry, filePath, registryPath, silentUpdate, false);
    }

    public static void checkIn(UserRegistry registry, String filePath, String registryPath) throws SynchronizationException {
        RegistrySynchronizer.checkIn(registry, filePath, registryPath, false);
    }

    public static void checkIn(UserRegistry registry, String filePath) throws SynchronizationException {
        RegistrySynchronizer.checkIn(registry, filePath, null);
    }

    public static void checkIn(UserRegistry registry, String filePath, boolean silentUpdate) throws SynchronizationException {
        RegistrySynchronizer.checkIn(registry, filePath, null, silentUpdate);
    }

    public static void checkOut(UserRegistry registry, String filePath, String resourcePath) throws SynchronizationException {
        CheckOutCommand operation = new CheckOutCommand(null, filePath, resourcePath, registry.getUserName(), false);
        operation.execute(registry);
    }

    public static void update(UserRegistry registry, String filePath) throws SynchronizationException {
        RegistrySynchronizer.update(registry, filePath, false);
    }

    public static void update(UserRegistry registry, String filePath, boolean silentUpdate) throws SynchronizationException {
        UpdateCommand operation = new UpdateCommand(null, filePath, null, silentUpdate, registry.getUserName(), false);
        operation.execute(registry);
    }

    public static boolean isCheckedOut(String directoryPath) {
        return new File(directoryPath + File.separator + ".meta").exists();
    }
}

