/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.core;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.wso2.carbon.registry.core.CollectionImpl;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.ResourceIDImpl;
import org.wso2.carbon.registry.core.config.RegistryContext;
import org.wso2.carbon.registry.core.dao.ResourceDAO;
import org.wso2.carbon.registry.core.dataaccess.DataAccessManager;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.jdbc.dataobjects.ResourceDO;
import org.wso2.carbon.registry.core.session.CurrentSession;
import org.wso2.carbon.registry.core.utils.RegistryUtils;
import org.wso2.carbon.user.core.UserRealm;

public class ResourceImpl
implements Resource {
    protected String id;
    protected long snapshotID;
    protected long versionNumber;
    protected String authorUserName;
    protected long createdTime;
    protected String lastUpdaterUserName;
    protected long lastModified;
    protected String description;
    protected String path;
    protected long matchingSnapshotID;
    protected String permanentPath;
    protected String mediaType;
    protected String parentPath;
    protected boolean contentModified;
    protected boolean propertiesModified;
    protected boolean versionableChange;
    protected int state;
    protected Properties properties = new Properties();
    protected int dbBasedContentID = -1;
    protected Object content;
    protected boolean directory = false;
    protected DataAccessManager dataAccessManager;
    protected String userName;
    protected UserRealm userRealm;
    protected int tenantId;
    protected ResourceDAO resourceDAO;
    protected int pathID;
    protected String name;
    protected String uuid;

    public ResourceImpl() {
        this.dataAccessManager = RegistryContext.getBaseInstance() != null ? RegistryContext.getBaseInstance().getDataAccessManager() : null;
        if (this.dataAccessManager != null) {
            this.resourceDAO = this.dataAccessManager.getDAOManager().getResourceDAO();
        }
        this.id = null;
        this.snapshotID = -1L;
        this.matchingSnapshotID = -1L;
    }

    public ResourceImpl(String path, ResourceDO resourceDO) {
        this.id = path;
        this.snapshotID = -1L;
        this.versionNumber = resourceDO.getVersion();
        this.authorUserName = resourceDO.getAuthor();
        this.createdTime = resourceDO.getCreatedOn();
        this.lastUpdaterUserName = resourceDO.getLastUpdater();
        this.lastModified = resourceDO.getLastUpdatedOn();
        this.description = resourceDO.getDescription();
        this.path = path;
        this.matchingSnapshotID = -1L;
        this.mediaType = resourceDO.getMediaType();
        this.parentPath = RegistryUtils.getParentPath(path);
        this.contentModified = true;
        this.propertiesModified = true;
        this.versionableChange = true;
        this.state = -1;
        this.dbBasedContentID = resourceDO.getContentID();
        this.content = null;
        this.dataAccessManager = RegistryContext.getBaseInstance() != null ? RegistryContext.getBaseInstance().getDataAccessManager() : null;
        if (this.dataAccessManager != null) {
            this.resourceDAO = this.dataAccessManager.getDAOManager().getResourceDAO();
        }
        this.userName = null;
        this.userRealm = null;
        this.pathID = resourceDO.getPathID();
        this.name = resourceDO.getName();
        this.uuid = resourceDO.getUUID();
    }

    public ResourceImpl(ResourceImpl resource) {
        this.id = resource.id;
        this.snapshotID = resource.snapshotID;
        this.versionNumber = resource.versionNumber;
        this.authorUserName = resource.authorUserName;
        this.createdTime = resource.createdTime;
        this.lastUpdaterUserName = resource.lastUpdaterUserName;
        this.lastModified = resource.lastModified;
        this.description = resource.description;
        this.path = resource.path;
        this.matchingSnapshotID = resource.matchingSnapshotID;
        this.permanentPath = resource.permanentPath;
        this.mediaType = resource.mediaType;
        this.parentPath = resource.parentPath;
        this.contentModified = resource.contentModified;
        this.propertiesModified = resource.propertiesModified;
        this.versionableChange = resource.versionableChange;
        this.state = resource.state;
        this.directory = resource.directory;
        this.userName = resource.userName;
        this.tenantId = resource.tenantId;
        this.pathID = resource.pathID;
        this.name = resource.name;
        this.dbBasedContentID = resource.dbBasedContentID;
        this.properties.putAll((Map<?, ?>)resource.properties);
        this.content = resource.content;
        this.dataAccessManager = resource.dataAccessManager;
        this.userRealm = resource.userRealm;
        this.resourceDAO = resource.resourceDAO;
        this.uuid = resource.getUUID();
    }

    @Override
    public String getUUID() {
        return this.uuid;
    }

    @Override
    public void setUUID(String uuid) {
        this.uuid = uuid;
    }

    public void setDataAccessManager(DataAccessManager dataAccessManager) {
        this.dataAccessManager = dataAccessManager;
        if (dataAccessManager != null) {
            this.resourceDAO = dataAccessManager.getDAOManager().getResourceDAO();
        }
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public void setUserRealm(UserRealm userRealm) {
        this.userRealm = userRealm;
    }

    public void setTenantId(int tenantId) {
        this.tenantId = tenantId;
    }

    @Override
    public String getId() {
        return this.path;
    }

    public void setId(String id) {
        this.path = id;
    }

    public long getSnapshotID() {
        return this.snapshotID;
    }

    public void setSnapshotID(long snapshotID) {
        this.snapshotID = snapshotID;
    }

    public long getVersionNumber() {
        return this.versionNumber;
    }

    public void setVersionNumber(long versionNumber) {
        this.versionNumber = versionNumber;
    }

    @Override
    public String getAuthorUserName() {
        return this.authorUserName;
    }

    public void setAuthorUserName(String authorUserName) {
        this.authorUserName = authorUserName;
    }

    @Override
    public Date getCreatedTime() {
        return new Date(this.createdTime);
    }

    public void setCreatedTime(Date createdTime) {
        this.createdTime = createdTime.getTime();
    }

    @Override
    public Date getLastModified() {
        return new Date(this.lastModified);
    }

    public void setLastModified(Date lastModified) {
        this.lastModified = lastModified.getTime();
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
        this.versionableChange = true;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path == null ? null : this.preparePath(path);
    }

    public long getMatchingSnapshotID() {
        return this.matchingSnapshotID;
    }

    public void setMatchingSnapshotID(long matchingSnapshotID) {
        this.matchingSnapshotID = matchingSnapshotID;
        this.permanentPath = matchingSnapshotID == -1L ? null : this.path + ";" + "version:" + matchingSnapshotID;
    }

    @Override
    public String getPermanentPath() {
        return this.permanentPath;
    }

    @Override
    public String getMediaType() {
        return this.mediaType;
    }

    @Override
    public void setMediaType(String mediaType) {
        if (mediaType != null) {
            mediaType = mediaType.trim().equals("") ? null : mediaType;
        }
        this.mediaType = mediaType;
        this.versionableChange = true;
    }

    @Override
    public String getParentPath() {
        if (this.parentPath != null) {
            return this.parentPath;
        }
        if (this.path == null || this.path.length() == 1) {
            return null;
        }
        int i = this.path.lastIndexOf(47);
        return this.path.substring(0, i);
    }

    public void setParentPath(String parentPath) {
        this.parentPath = parentPath;
    }

    @Override
    public int getState() {
        return this.state;
    }

    public void setState(int state) {
        this.state = state;
    }

    @Override
    public String getProperty(String key) {
        List<String> propValues = this.getPropertyValues(key);
        if (propValues == null) {
            return null;
        }
        return propValues.get(0);
    }

    @Override
    public List<String> getPropertyValues(String key) {
        return (List)this.properties.get(key);
    }

    @Override
    public Properties getProperties() {
        return this.properties;
    }

    @Override
    public void removeProperty(String key) {
        this.removePropertyWithNoUpdate(key);
        this.setPropertiesModified(true);
    }

    public void removePropertyWithNoUpdate(String key) {
        if (key != null) {
            this.properties.remove(key);
        }
    }

    @Override
    public void removePropertyValue(String key, String value) {
        List<String> propValues = this.getPropertyValues(key);
        if (propValues != null) {
            propValues.remove(value);
            this.setPropertiesModified(true);
        }
    }

    @Override
    public void editPropertyValue(String key, String oldValue, String newValue) {
        List<String> propValues = this.getPropertyValues(key);
        if (propValues != null) {
            propValues.remove(oldValue);
            propValues.add(newValue);
            this.setPropertiesModified(true);
        }
    }

    @Override
    public void setProperty(String key, String value) {
        ArrayList<String> propValues = new ArrayList<String>();
        propValues.add(value);
        this.properties.put(key, propValues);
    }

    @Override
    public void setProperty(String key, List<String> value) {
        this.setPropertyWithNoUpdate(key, value);
        this.setPropertiesModified(true);
    }

    private void setPropertyWithNoUpdate(String key, List<String> value) {
        this.properties.put(key, value);
    }

    @Override
    public void addProperty(String key, String value) {
        this.addPropertyWithNoUpdate(key, value);
        this.setPropertiesModified(true);
    }

    public void addPropertyWithNoUpdate(String key, String value) {
        List<String> propValues = this.getPropertyValues(key);
        if (propValues != null) {
            propValues.add(value);
        } else {
            propValues = new ArrayList<String>();
            propValues.add(value);
            this.setPropertyWithNoUpdate(key, propValues);
        }
    }

    @Override
    public void setProperties(Properties properties) {
        if (properties != null) {
            this.properties = properties;
        }
        this.setPropertiesModified(true);
    }

    public int getDbBasedContentID() {
        return this.dbBasedContentID;
    }

    public void setDbBasedContentID(int dbBasedContentID) {
        this.dbBasedContentID = dbBasedContentID;
    }

    @Override
    public InputStream getContentStream() throws RegistryException {
        if (this.content == null) {
            throw new RegistryException("Resource content is empty.");
        }
        if (this.content instanceof byte[]) {
            return new ByteArrayInputStream((byte[])this.content);
        }
        if (this.content instanceof String) {
            byte[] contentBytes = RegistryUtils.encodeString((String)this.content);
            return new ByteArrayInputStream(contentBytes);
        }
        throw new RegistryException("Cannot return input stream for content of type: " + this.content.getClass().getName());
    }

    @Override
    public void setContentStream(InputStream contentStream) throws RegistryException {
        this.setContentStreamWithNoUpdate(contentStream);
        this.setContentModified(true);
    }

    public void setContentStreamWithNoUpdate(InputStream contentStream) throws RegistryException {
        this.content = RegistryUtils.getByteArray(contentStream);
    }

    @Override
    public Object getContent() throws RegistryException {
        return this.content;
    }

    @Override
    public void setContent(Object content) throws RegistryException {
        this.setContentWithNoUpdate(content);
        this.setContentModified(true);
    }

    public void setContentWithNoUpdate(Object content) throws RegistryException {
        this.content = content;
    }

    public void prepareContentForPut() throws RegistryException {
        if (this.content instanceof String) {
            this.content = RegistryUtils.encodeString((String)this.content);
        } else if (this.content instanceof InputStream) {
            this.content = RegistryUtils.getByteArray((InputStream)this.content);
        }
    }

    private String preparePath(String path) {
        String preparedPath = path;
        if (!path.equals("/") && path.endsWith("/")) {
            preparedPath = path.substring(0, path.length() - "/".length());
        }
        return preparedPath;
    }

    @Override
    public String getLastUpdaterUserName() {
        return this.lastUpdaterUserName;
    }

    public void setLastUpdaterUserName(String lastUpdaterUserName) {
        this.lastUpdaterUserName = lastUpdaterUserName;
    }

    public boolean isContentModified() {
        return this.contentModified;
    }

    public void setContentModified(boolean contentModified) {
        this.contentModified = contentModified;
        this.setLastModified(new Date());
        this.versionableChange = true;
    }

    public boolean isPropertiesModified() {
        return this.propertiesModified;
    }

    public void setPropertiesModified(boolean propertiesModified) {
        this.propertiesModified = propertiesModified;
        this.setLastModified(new Date());
        this.versionableChange = true;
    }

    public void setPropertiesModifiedWithNoUpdate(boolean propertiesModified) {
        this.propertiesModified = propertiesModified;
    }

    @Override
    public boolean isVersionableChange() {
        return this.versionableChange;
    }

    @Override
    public void setVersionableChange(boolean versionableChange) {
        this.setLastModified(new Date());
        this.versionableChange = versionableChange;
    }

    @Override
    public List<String> getAspects() {
        return this.getPropertyValues("registry.Aspects");
    }

    @Override
    public void addAspect(String name) {
        List<String> aspects = this.getPropertyValues("registry.Aspects");
        if (aspects == null) {
            aspects = new ArrayList<String>();
        }
        aspects.add(name);
        this.setProperty("registry.Aspects", aspects);
    }

    @Override
    public void removeAspect(String name) {
        List<String> aspects = this.getPropertyValues("registry.Aspects");
        if (aspects != null) {
            aspects.remove(name);
        }
    }

    @Override
    public void discard() {
    }

    protected void setSessionInformation() {
        CurrentSession.setUser(this.userName);
        CurrentSession.setUserRealm(this.userRealm);
        CurrentSession.setTenantId(this.tenantId);
    }

    protected void clearSessionInformation() {
        CurrentSession.removeUser();
        CurrentSession.removeUserRealm();
        CurrentSession.removeTenantId();
    }

    public int getPathID() {
        return this.pathID;
    }

    public void setPathID(int pathID) {
        this.pathID = pathID;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ResourceIDImpl getResourceIDImpl() {
        ResourceIDImpl resourceIDImpl = new ResourceIDImpl();
        resourceIDImpl.setCollection(this instanceof CollectionImpl);
        resourceIDImpl.setPathID(this.pathID);
        if (this.name == null && !(this instanceof CollectionImpl)) {
            this.name = RegistryUtils.getResourceName(this.path);
        }
        resourceIDImpl.setName(this.name);
        resourceIDImpl.setPath(this.path);
        return resourceIDImpl;
    }

    public ResourceDO getResourceDO() {
        ResourceDO resourceDO = new ResourceDO();
        resourceDO.setPathID(this.getPathID());
        resourceDO.setName(this.name);
        resourceDO.setVersion(this.versionNumber);
        resourceDO.setMediaType(this.mediaType);
        resourceDO.setAuthor(this.authorUserName);
        resourceDO.setCreatedOn(this.createdTime);
        resourceDO.setLastUpdater(this.lastUpdaterUserName);
        resourceDO.setLastUpdatedOn(this.lastModified);
        resourceDO.setDescription(this.description);
        resourceDO.setContentID(this.dbBasedContentID);
        resourceDO.setUUID(this.uuid);
        return resourceDO;
    }

    public ResourceImpl getShallowCopy() throws RegistryException {
        ResourceImpl newResource = new ResourceImpl();
        this.fillResourceCopy(newResource);
        return newResource;
    }

    protected ResourceImpl fillResourceCopy(ResourceImpl resource) throws RegistryException {
        resource.setId(this.id);
        resource.setSnapshotID(this.snapshotID);
        resource.setVersionNumber(this.versionNumber);
        resource.setAuthorUserName(this.authorUserName);
        resource.setCreatedTime(new Date(this.createdTime));
        resource.setDescription(this.description);
        resource.setPath(this.path);
        resource.setMatchingSnapshotID(this.matchingSnapshotID);
        resource.setMediaType(this.mediaType);
        resource.setParentPath(this.parentPath);
        resource.setContentModified(this.contentModified);
        resource.setPropertiesModified(this.propertiesModified);
        resource.setVersionableChange(this.versionableChange);
        resource.setState(this.state);
        resource.setProperties(this.properties);
        resource.setDbBasedContentID(this.dbBasedContentID);
        if (this.content != null) {
            resource.setContent(this.content);
        }
        resource.setDataAccessManager(this.dataAccessManager);
        resource.setUserName(this.userName);
        resource.setTenantId(this.tenantId);
        resource.setUserRealm(this.userRealm);
        resource.setPathID(this.pathID);
        resource.setName(this.name);
        resource.setUUID(this.uuid);
        resource.setLastUpdaterUserName(this.lastUpdaterUserName);
        resource.setLastModified(new Date(this.lastModified));
        return resource;
    }
}

