/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.secpolicy.model;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.neethi.PolicyComponent;
import org.apache.ws.secpolicy.SP11Constants;
import org.apache.ws.secpolicy.SP12Constants;
import org.apache.ws.secpolicy.SPConstants;
import org.apache.ws.secpolicy.model.AbstractSecurityAssertion;
import org.apache.ws.secpolicy.model.Token;
import org.apache.ws.secpolicy.model.TokenWrapper;

public class ProtectionToken
extends AbstractSecurityAssertion
implements TokenWrapper {
    private Token protectionToken;

    public ProtectionToken(int version) {
        this.setVersion(version);
    }

    public Token getProtectionToken() {
        return this.protectionToken;
    }

    public void setProtectionToken(Token protectionToken) {
        this.protectionToken = protectionToken;
    }

    public void setToken(Token tok) {
        this.setProtectionToken(tok);
    }

    public QName getName() {
        if (this.version == 2) {
            return SP12Constants.PROTECTION_TOKEN;
        }
        return SP11Constants.PROTECTION_TOKEN;
    }

    public PolicyComponent normalize() {
        return this;
    }

    public void serialize(XMLStreamWriter writer) throws XMLStreamException {
        String wspPrefix;
        String prefix;
        String localname = this.getName().getLocalPart();
        String namespaceURI = this.getName().getNamespaceURI();
        String writerPrefix = writer.getPrefix(namespaceURI);
        if (writerPrefix == null) {
            prefix = this.getName().getPrefix();
            writer.setPrefix(prefix, namespaceURI);
        } else {
            prefix = writerPrefix;
        }
        writer.writeStartElement(prefix, localname, namespaceURI);
        if (writerPrefix == null) {
            writer.writeNamespace(prefix, namespaceURI);
        }
        String policyLocalName = SPConstants.POLICY.getLocalPart();
        String policyNamespaceURI = SPConstants.POLICY.getNamespaceURI();
        String wspWriterPrefix = writer.getPrefix(policyNamespaceURI);
        if (wspWriterPrefix == null) {
            wspPrefix = SPConstants.POLICY.getPrefix();
            writer.setPrefix(wspPrefix, policyNamespaceURI);
        } else {
            wspPrefix = wspWriterPrefix;
        }
        writer.writeStartElement(wspPrefix, policyLocalName, policyNamespaceURI);
        if (wspWriterPrefix == null) {
            writer.writeNamespace(wspPrefix, policyNamespaceURI);
        }
        if (this.protectionToken == null) {
            throw new RuntimeException("ProtectionToken is not set");
        }
        this.protectionToken.serialize(writer);
        writer.writeEndElement();
        writer.writeEndElement();
    }
}

