/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.indexing;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.indexing.IndexingManager;
import org.wso2.carbon.registry.indexing.Utils;
import org.wso2.carbon.registry.indexing.indexer.Indexer;
import org.wso2.carbon.registry.indexing.indexer.IndexerException;
import org.wso2.carbon.registry.indexing.solr.SolrClient;
import org.wso2.carbon.utils.WaitBeforeShutdownObserver;

public class AsyncIndexer
implements Runnable {
    private static Log log = LogFactory.getLog(AsyncIndexer.class);
    private final SolrClient client;
    private LinkedBlockingQueue<File2Index> queue = new LinkedBlockingQueue();
    private boolean canAcceptFiles = true;

    public void addFile(File2Index file2Index) {
        if (this.canAcceptFiles) {
            this.queue.offer(file2Index);
        } else {
            log.warn((Object)("Can't accept resource for indexing. Shutdown in progress: path=" + file2Index.path));
        }
    }

    protected AsyncIndexer() throws RegistryException {
        try {
            this.client = SolrClient.getInstance();
            Utils.setWaitBeforeShutdownObserver(new WaitBeforeShutdownObserver(){

                public void startingShutdown() {
                    AsyncIndexer.this.canAcceptFiles = false;
                    do {
                        AsyncIndexer.this.indexFile();
                    } while (AsyncIndexer.this.queue.size() != 0);
                }

                public boolean isTaskComplete() {
                    return AsyncIndexer.this.queue.size() <= 0;
                }
            });
        }
        catch (IndexerException e) {
            throw new RegistryException("Error initializing Async Indexer " + e.getMessage(), (Throwable)e);
        }
    }

    public SolrClient getClient() {
        return this.client;
    }

    @Override
    public void run() {
        while (!Thread.currentThread().isInterrupted()) {
            if (this.indexFile()) continue;
            return;
        }
    }

    private boolean indexFile() {
        try {
            if (this.queue.size() > 0) {
                File2Index fileData = this.queue.take();
                Indexer indexer = IndexingManager.getInstance().getIndexerForMediaType(fileData.mediaType);
                try {
                    this.getClient().indexDocument(fileData, indexer);
                }
                catch (Exception e) {
                    log.warn((Object)("Could not index the resource: path=" + fileData.path + ", media type=" + fileData.mediaType));
                }
            }
        }
        catch (Throwable e) {
            if (e instanceof InterruptedException) {
                return false;
            }
            log.error((Object)"Error while indexing.", e);
        }
        return true;
    }

    @SuppressWarnings(value={"EI_EXPOSE_REP", "EI_EXPOSE_REP2"})
    public static class File2Index {
        public byte[] data;
        public String mediaType;
        public String path;
        public int tenantId;

        public File2Index(byte[] data, String mediaType, String path, int tenantId) {
            this.data = data;
            this.mediaType = mediaType;
            this.path = path;
            this.tenantId = tenantId;
        }
    }
}

