/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.application.deployer.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axis2.deployment.DeploymentException;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.wso2.carbon.CarbonException;
import org.wso2.carbon.application.deployer.AppDeployerUtils;
import org.wso2.carbon.application.deployer.CarbonApplication;
import org.wso2.carbon.application.deployer.config.ApplicationConfiguration;
import org.wso2.carbon.application.deployer.config.Artifact;
import org.wso2.carbon.application.deployer.handler.AppDeploymentHandler;
import org.wso2.carbon.application.deployer.internal.AppDeployerServiceComponent;
import org.wso2.carbon.application.deployer.persistence.CarbonAppPersistenceManager;
import org.wso2.carbon.application.deployer.service.ApplicationManagerService;
import org.wso2.carbon.utils.CarbonUtils;

public final class ApplicationManager
implements ApplicationManagerService {
    private static final Log log = LogFactory.getLog(ApplicationManager.class);
    private static ApplicationManager instance = new ApplicationManager();
    private List<AppDeploymentHandler> appDeploymentHandlers;
    private List<PendingApplication> pendingCarbonApps;
    private Map<String, ArrayList<CarbonApplication>> tenantcAppMap = new ConcurrentHashMap<String, ArrayList<CarbonApplication>>();
    private Map<String, CarbonAppPersistenceManager> tenantPMMap = new ConcurrentHashMap<String, CarbonAppPersistenceManager>();
    private Map<String, HashMap<String, Exception>> tenantfaultycAppMap = new ConcurrentHashMap<String, HashMap<String, Exception>>();
    private int initialHandlers;
    private int handlerCount;

    private ApplicationManager() {
        this.appDeploymentHandlers = new ArrayList<AppDeploymentHandler>();
        this.pendingCarbonApps = new ArrayList<PendingApplication>();
        this.initialHandlers = 2 + this.findInitialHandlerCount();
    }

    public static ApplicationManager getInstance() {
        return instance;
    }

    @Override
    public synchronized void registerDeploymentHandler(AppDeploymentHandler handler) {
        this.appDeploymentHandlers.add(handler);
        ++this.handlerCount;
        if (this.handlerCount == this.initialHandlers) {
            for (PendingApplication application : this.pendingCarbonApps) {
                try {
                    this.deployCarbonApp(application.getPath(), application.getAxisConfig());
                }
                catch (Exception e) {
                    log.error((Object)("Error while deploying stored cApp : " + application), (Throwable)e);
                }
            }
            this.pendingCarbonApps.clear();
        }
    }

    @Override
    public synchronized void unregisterDeploymentHandler(AppDeploymentHandler handler) {
        if (this.appDeploymentHandlers.contains(handler)) {
            this.appDeploymentHandlers.remove(handler);
        }
    }

    @Override
    public synchronized void deployCarbonApp(String archPath, AxisConfiguration axisConfig) throws Exception {
        File file;
        if (this.initialHandlers != this.handlerCount) {
            this.pendingCarbonApps.add(new PendingApplication(archPath, axisConfig));
            return;
        }
        CarbonAppPersistenceManager capm = this.getPersistenceManager(axisConfig);
        String tenantId = AppDeployerUtils.getTenantIdString(axisConfig);
        String archPathToProcess = AppDeployerUtils.formatPath(archPath);
        String fileName = archPathToProcess.substring(archPathToProcess.lastIndexOf(47) + 1);
        CarbonApplication existingApp = null;
        for (CarbonApplication carbonApp : this.getCarbonApps(tenantId)) {
            if (!archPathToProcess.equals(carbonApp.getAppFilePath())) continue;
            existingApp = carbonApp;
            break;
        }
        for (String faultyAppPath : this.getFaultyCarbonApps(tenantId).keySet()) {
            if (!archPathToProcess.equals(faultyAppPath)) continue;
            this.removeFaultyCarbonApp(tenantId, faultyAppPath);
            break;
        }
        if (existingApp != null && (file = new File(archPathToProcess)).exists()) {
            String hashValue = CarbonUtils.getMD5((byte[])CarbonUtils.getBytesFromFile((File)file));
            String hashValueFromRegistry = capm.getHashValue(existingApp.getAppName());
            if (hashValueFromRegistry != null && hashValueFromRegistry.equals(hashValue)) {
                existingApp.setDeploymentCompleted(true);
                return;
            }
            log.warn((Object)("Carbon Application : " + fileName + " has been updated. Removing" + " the existing application and redeploying..."));
            this.undeployCarbonApp(existingApp, axisConfig);
        }
        log.info((Object)("Deploying Carbon Application : " + fileName + "..."));
        CarbonApplication currentApp = new CarbonApplication();
        try {
            currentApp.setAppFilePath(archPathToProcess);
            String extractedPath = AppDeployerUtils.extractCarbonApp(archPathToProcess);
            ApplicationConfiguration appConfig = new ApplicationConfiguration(capm, extractedPath + "artifacts.xml");
            if (appConfig.getApplicationArtifact().getDependencies().size() == 0) {
                log.warn((Object)("No artifacts found to be deployed in this server. Ignoring Carbon Application : " + fileName));
                return;
            }
            currentApp.setExtractedPath(extractedPath);
            currentApp.setAppConfig(appConfig);
            String appName = appConfig.getAppName();
            if (appName == null) {
                log.warn((Object)("No application name found in Carbon Application : " + fileName + ". Using " + "the file name as the application name"));
                appName = fileName.substring(0, fileName.lastIndexOf(46));
            }
            if (this.appExists(appName, axisConfig)) {
                String msg = "Carbon Application : " + appName + " already exists. Two applications " + "can't have the same Id. Deployment aborted.";
                log.error((Object)msg);
                throw new Exception(msg);
            }
            currentApp.setAppName(appName);
            String appVersion = appConfig.getAppVersion();
            if (appVersion != null && !"".equals(appVersion)) {
                currentApp.setAppVersion(appVersion);
            }
            this.searchArtifacts(currentApp.getExtractedPath(), currentApp);
            if (this.isArtifactReadyToDeploy(currentApp.getAppConfig().getApplicationArtifact())) {
                for (AppDeploymentHandler handler : this.appDeploymentHandlers) {
                    handler.deployArtifacts(currentApp, axisConfig);
                }
            } else {
                log.error((Object)("Some dependencies in cApp : " + appName + " were not satisfied. Check " + "whether all dependent artifacts are included in cApp file : " + archPathToProcess));
                return;
            }
            capm.persistCarbonApp(currentApp);
            currentApp.setDeploymentCompleted(true);
            this.addCarbonApp(tenantId, currentApp);
            log.info((Object)("Successfully Deployed Carbon Application : " + currentApp.getAppName() + AppDeployerUtils.getTenantIdLogString(AppDeployerUtils.getTenantId(axisConfig))));
        }
        catch (DeploymentException e) {
            log.error((Object)"Error occurred while deploying Carbon Application", (Throwable)e);
            this.addFaultyCarbonApp(tenantId, archPathToProcess, (Exception)((Object)e));
        }
        catch (CarbonException e) {
            log.error((Object)"Error occurred while deploying Carbon Application", (Throwable)e);
            this.addFaultyCarbonApp(tenantId, archPathToProcess, (Exception)((Object)e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void searchArtifacts(String rootDirPath, CarbonApplication parentApp) throws CarbonException {
        File extractedDir = new File(rootDirPath);
        File[] allFiles = extractedDir.listFiles();
        if (allFiles == null) {
            return;
        }
        ArrayList<Artifact> allArtifacts = new ArrayList<Artifact>();
        for (File artifactDirectory : allFiles) {
            String directoryPath;
            String artifactXmlPath;
            File f;
            if (!artifactDirectory.isDirectory() || !(f = new File(artifactXmlPath = (directoryPath = AppDeployerUtils.formatPath(artifactDirectory.getAbsolutePath())) + File.separator + "artifact.xml")).exists()) continue;
            Artifact artifact = null;
            FileInputStream xmlInputStream = null;
            try {
                xmlInputStream = new FileInputStream(f);
                artifact = this.buildAppArtifact(parentApp, xmlInputStream);
            }
            catch (FileNotFoundException e) {
                this.handleException("artifacts.xml File cannot be loaded from " + artifactXmlPath, e);
            }
            finally {
                if (xmlInputStream != null) {
                    try {
                        ((InputStream)xmlInputStream).close();
                    }
                    catch (IOException e) {
                        log.error((Object)"Error while closing input stream.", (Throwable)e);
                    }
                }
            }
            if (artifact == null) {
                return;
            }
            artifact.setExtractedPath(directoryPath);
            allArtifacts.add(artifact);
        }
        Artifact appArtifact = parentApp.getAppConfig().getApplicationArtifact();
        this.buildDependencyTree(appArtifact, allArtifacts);
    }

    public Artifact buildAppArtifact(CarbonApplication parentApp, InputStream artifactXmlStream) throws CarbonException {
        Artifact artifact = null;
        try {
            OMElement artElement = new StAXOMBuilder(artifactXmlStream).getDocumentElement();
            if (!"artifact".equals(artElement.getLocalName())) {
                log.error((Object)("artifact.xml is invalid. Parent Application : " + parentApp.getAppName()));
                return null;
            }
            artifact = AppDeployerUtils.populateArtifact(artElement);
        }
        catch (XMLStreamException e) {
            this.handleException("Error while parsing the artifact.xml file ", e);
        }
        if (artifact == null || artifact.getName() == null) {
            log.error((Object)("Invalid artifact found in Carbon Application : " + parentApp.getAppName()));
            return null;
        }
        return artifact;
    }

    @Override
    public void undeployCarbonApp(CarbonApplication carbonApp, AxisConfiguration axisConfig) {
        log.info((Object)("Undeploying Carbon Application : " + carbonApp.getAppName() + "..."));
        for (AppDeploymentHandler handler : this.appDeploymentHandlers) {
            handler.undeployArtifacts(carbonApp, axisConfig);
        }
        this.removeCarbonApp(AppDeployerUtils.getTenantIdString(axisConfig), carbonApp);
        try {
            CarbonAppPersistenceManager capm = this.getPersistenceManager(axisConfig);
            capm.deleteApplication(carbonApp.getAppName());
        }
        catch (Exception e) {
            log.error((Object)("Can't delete the Application from Registry : " + carbonApp.getAppName()));
        }
        log.info((Object)("Successfully Undeployed Carbon Application : " + carbonApp.getAppName() + AppDeployerUtils.getTenantIdLogString(AppDeployerUtils.getTenantId(axisConfig))));
        if (AppDeployerUtils.hasLibs(carbonApp.getAppConfig().getApplicationArtifact().getDependencies())) {
            log.warn((Object)"Your Carbon Application has installed OSGi bundles into the system. It is recommended to restart the server to completely remove those..");
        }
    }

    @Override
    public ArrayList<CarbonApplication> getCarbonApps(String tenantId) {
        ArrayList<CarbonApplication> cApps = this.tenantcAppMap.get(tenantId);
        if (cApps == null) {
            cApps = new ArrayList();
        }
        return cApps;
    }

    @Override
    public HashMap<String, Exception> getFaultyCarbonApps(String tenantId) {
        HashMap<String, Exception> cApps = this.tenantfaultycAppMap.get(tenantId);
        if (cApps == null) {
            cApps = new HashMap();
        }
        return cApps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFaultyCarbonApp(String tenantId, String carbonApp, Exception error) {
        HashMap<String, Exception> cApps;
        String string = tenantId.intern();
        synchronized (string) {
            cApps = this.tenantfaultycAppMap.get(tenantId);
            if (cApps == null) {
                cApps = new HashMap();
                this.tenantfaultycAppMap.put(tenantId, cApps);
            }
        }
        for (String cApp : cApps.keySet()) {
            String appName = cApp;
            if (appName == null || !appName.equals(carbonApp)) continue;
            return;
        }
        cApps.put(carbonApp, error);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFaultyCarbonApp(String tenantId, String appFilePath) {
        HashMap<String, Exception> faultycApps;
        HashMap<String, Exception> hashMap = faultycApps = this.tenantfaultycAppMap.get(tenantId);
        synchronized (hashMap) {
            if (faultycApps != null) {
                faultycApps.remove(appFilePath);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCarbonApp(String tenantId, CarbonApplication carbonApp) {
        ArrayList<CarbonApplication> cApps;
        String string = tenantId.intern();
        synchronized (string) {
            cApps = this.tenantcAppMap.get(tenantId);
            if (cApps == null) {
                cApps = new ArrayList();
                this.tenantcAppMap.put(tenantId, cApps);
            }
        }
        for (CarbonApplication cApp : cApps) {
            String appName = cApp.getAppName();
            String appVersion = cApp.getAppVersion();
            if (appName == null || !appName.equals(carbonApp.getAppName()) || appVersion == null || !appVersion.equals(carbonApp.getAppVersion())) continue;
            return;
        }
        cApps.add(carbonApp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCarbonApp(String tenantId, CarbonApplication carbonApp) {
        ArrayList<CarbonApplication> cApps;
        ArrayList<CarbonApplication> arrayList = cApps = this.tenantcAppMap.get(tenantId);
        synchronized (arrayList) {
            if (cApps != null && cApps.contains(carbonApp)) {
                cApps.remove(carbonApp);
            }
        }
    }

    private boolean isArtifactReadyToDeploy(Artifact rootArtifact) {
        if (rootArtifact == null) {
            return false;
        }
        boolean isReady = true;
        for (Artifact.Dependency dep : rootArtifact.getDependencies()) {
            isReady = this.isArtifactReadyToDeploy(dep.getArtifact());
            if (isReady) continue;
            return false;
        }
        if (rootArtifact.unresolvedDepCount > 0) {
            isReady = false;
        }
        return isReady;
    }

    public void buildDependencyTree(Artifact rootArtifact, List<Artifact> allArtifacts) {
        for (Artifact.Dependency dep : rootArtifact.getDependencies()) {
            for (Artifact temp : allArtifacts) {
                if (!dep.getName().equals(temp.getName())) continue;
                String depVersion = dep.getVersion();
                String attVersion = temp.getVersion();
                if ((depVersion != null || attVersion != null) && (depVersion == null || !depVersion.equals(attVersion))) continue;
                dep.setArtifact(temp);
                --rootArtifact.unresolvedDepCount;
                break;
            }
            if (dep.getArtifact() == null) continue;
            this.buildDependencyTree(dep.getArtifact(), allArtifacts);
        }
    }

    public CarbonAppPersistenceManager getPersistenceManager(AxisConfiguration axisConfig) {
        String tenantId = AppDeployerUtils.getTenantIdString(axisConfig);
        CarbonAppPersistenceManager capm = this.tenantPMMap.get(tenantId);
        try {
            if (capm == null) {
                capm = new CarbonAppPersistenceManager(axisConfig);
                this.tenantPMMap.put(tenantId, capm);
            }
        }
        catch (Exception e) {
            log.error((Object)("Error while initializing CAppPersistenceManger for tenant : " + tenantId), (Throwable)e);
        }
        return capm;
    }

    private int findInitialHandlerCount() {
        int handlers = 0;
        BundleContext bc = AppDeployerServiceComponent.getBundleContext();
        for (Bundle b : bc.getBundles()) {
            if (!AppDeployerUtils.isAppDeployer(b)) continue;
            ++handlers;
        }
        return handlers;
    }

    private boolean appExists(String newAppName, AxisConfiguration axisConfig) {
        String tenantId = AppDeployerUtils.getTenantIdString(axisConfig);
        CarbonApplication appToRemove = null;
        for (CarbonApplication carbonApp : this.getCarbonApps(tenantId)) {
            if (!newAppName.equals(carbonApp.getAppName())) continue;
            if (carbonApp.isDeploymentCompleted()) {
                return true;
            }
            appToRemove = carbonApp;
            break;
        }
        if (appToRemove != null) {
            this.undeployCarbonApp(appToRemove, axisConfig);
        }
        return false;
    }

    private void handleException(String msg, Exception e) throws CarbonException {
        log.error((Object)msg, (Throwable)e);
        throw new CarbonException(msg, (Throwable)e);
    }

    private final class PendingApplication {
        private String path;
        private AxisConfiguration axisConfig;

        private PendingApplication(String path, AxisConfiguration configCtx) {
            this.path = path;
            this.axisConfig = configCtx;
        }

        public String getPath() {
            return this.path;
        }

        public AxisConfiguration getAxisConfig() {
            return this.axisConfig;
        }
    }
}

