/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.webapp.mgt;

import java.io.File;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.deployment.repository.util.DeploymentFileData;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.CarbonConstants;
import org.wso2.carbon.core.deployment.DeploymentSynchronizer;
import org.wso2.carbon.core.multitenancy.utils.TenantAxisUtils;
import org.wso2.carbon.tomcat.ext.utils.URLMappingHolder;
import org.wso2.carbon.tomcat.ext.valves.CarbonTomcatValve;
import org.wso2.carbon.utils.CarbonUtils;
import org.wso2.carbon.utils.deployment.GhostDeployer;
import org.wso2.carbon.utils.deployment.GhostDeployerUtils;
import org.wso2.carbon.utils.multitenancy.MultitenantUtils;
import org.wso2.carbon.webapp.mgt.DataHolder;
import org.wso2.carbon.webapp.mgt.TomcatUtil;
import org.wso2.carbon.webapp.mgt.WebApplication;
import org.wso2.carbon.webapp.mgt.WebApplicationsHolder;
import org.wso2.carbon.webapp.mgt.utils.GhostWebappDeployerUtils;

public class GhostWebappDeployerValve
implements CarbonTomcatValve {
    private static final Log log = LogFactory.getLog(GhostWebappDeployerValve.class);

    public void invoke(HttpServletRequest request, HttpServletResponse response) {
        ConfigurationContext currentCtx;
        WebApplication deployedWebapp;
        if (!GhostWebappDeployerUtils.isGhostOn()) {
            return;
        }
        String requestURI = request.getRequestURI();
        if (requestURI.contains("/carbon/") && !requestURI.contains("/webapp-list/webapp_info.jsp") || requestURI.contains("favicon.ico") || requestURI.contains("/fileupload/")) {
            return;
        }
        String requestedHostName = request.getServerName();
        String uriOfVirtualHost = URLMappingHolder.getInstance().getApplicationFromUrlMapping(requestedHostName);
        if (TomcatUtil.isVirtualHostRequest(requestedHostName).booleanValue() && uriOfVirtualHost == null) {
            uriOfVirtualHost = DataHolder.getHotUpdateService().getApplicationContextForHost(requestedHostName);
        }
        if (uriOfVirtualHost != null) {
            requestURI = uriOfVirtualHost;
        }
        if ((deployedWebapp = this.getDeployedWebappFromThisURI(requestURI, currentCtx = requestURI.contains("/t/") ? this.getCurrentConfigurationCtxFromURI(requestURI) : DataHolder.getServerConfigContext())) == null) {
            WebApplication transitWebapp = GhostWebappDeployerUtils.dispatchWebAppFromTransitGhosts(requestURI, currentCtx);
            if (transitWebapp != null) {
                String isBeingUnloaded = (String)transitWebapp.getProperty("isBeingUnloaded");
                if (isBeingUnloaded != null && "true".equals(isBeingUnloaded)) {
                    GhostWebappDeployerUtils.waitForWebAppToLeaveTransit(transitWebapp.getContextName(), currentCtx);
                    this.handleWebapp(transitWebapp.getWebappFile().getName(), currentCtx);
                } else {
                    GhostWebappDeployerUtils.waitForWebAppToLeaveTransit(transitWebapp.getContextName(), currentCtx);
                    try {
                        TomcatUtil.remapRequest(request);
                        return;
                    }
                    catch (Exception e) {
                        log.error((Object)("Error when redirecting response to " + requestURI), (Throwable)e);
                    }
                }
            }
        } else if (GhostWebappDeployerUtils.isGhostWebApp(deployedWebapp)) {
            this.handleWebapp(deployedWebapp.getWebappFile().getName(), currentCtx);
            try {
                TomcatUtil.remapRequest(request);
                return;
            }
            catch (Exception e) {
                log.error((Object)("Error when redirecting response to " + requestURI), (Throwable)e);
            }
        } else {
            GhostWebappDeployerUtils.updateLastUsedTime(deployedWebapp);
        }
        if (!requestURI.contains("/webapp-list/webapp_info.jsp")) {
            return;
        }
        String webappFileName = request.getParameter("webappFileName");
        this.handleWebapp(webappFileName, currentCtx);
    }

    private WebApplication getDeployedWebappFromThisURI(String requestURI, ConfigurationContext cfgCtx) {
        String ctxName = requestURI;
        if (requestURI.startsWith("/t/")) {
            String tenantDomain = MultitenantUtils.getTenantDomainFromUrl((String)requestURI);
            if (requestURI.contains("webapps") || requestURI.contains("jaxwebapps") || requestURI.contains("jaggeryapps")) {
                String subCtxName = ctxName.substring(ctxName.indexOf(tenantDomain) + tenantDomain.length() + 1);
                if (subCtxName.contains("/")) {
                    subCtxName = subCtxName.substring(subCtxName.indexOf(47) + 1);
                }
                if (subCtxName.contains("/")) {
                    subCtxName = subCtxName.substring(subCtxName.indexOf(47));
                }
                ctxName = requestURI.substring(0, requestURI.lastIndexOf(subCtxName));
            }
        } else {
            ctxName = requestURI.substring(1);
            ctxName = ctxName.contains("/") ? "/".concat(ctxName.substring(0, ctxName.indexOf(47))) : "/".concat(ctxName);
        }
        WebApplication deployedWebapp = null;
        WebApplicationsHolder webApplicationsHolder = this.getWebApplicationHolder(cfgCtx);
        for (WebApplication webApplication : webApplicationsHolder.getStartedWebapps().values()) {
            if (!ctxName.equals(webApplication.getContextName())) continue;
            deployedWebapp = webApplication;
        }
        return deployedWebapp;
    }

    private WebApplicationsHolder getWebApplicationHolder(ConfigurationContext cfgCtx) {
        WebApplicationsHolder webApplicationsHolder = (WebApplicationsHolder)cfgCtx.getProperty("carbon.webapps.holder");
        return webApplicationsHolder;
    }

    private void handleWebapp(String webappFileName, ConfigurationContext cfgCtx) {
        WebApplication ghostWebapp;
        WebApplicationsHolder webApplicationsHolder;
        if (webappFileName != null && (webApplicationsHolder = this.getWebApplicationHolder(cfgCtx)) != null && (ghostWebapp = webApplicationsHolder.getStartedWebapps().get(webappFileName)) != null) {
            if (CarbonUtils.isWorkerNode()) {
                this.handleDepSynchUpdate(cfgCtx, ghostWebapp, webApplicationsHolder);
            }
            GhostWebappDeployerUtils.deployActualWebApp(ghostWebapp, cfgCtx);
        }
    }

    private ConfigurationContext getCurrentConfigurationCtxFromURI(String uri) {
        return TenantAxisUtils.getTenantConfigurationContextFromUrl((String)uri, (ConfigurationContext)DataHolder.getServerConfigContext());
    }

    private void handleDepSynchUpdate(ConfigurationContext configurationContext, WebApplication webApplication, WebApplicationsHolder webappsHolder) {
        DeploymentSynchronizer depsync;
        String filePath;
        File fileToUpdate;
        String fileName;
        String webappType = (String)webApplication.getProperty("webappFilter");
        String deploymentDir = "webapps";
        if (webappType.equals("jaggeryWebapp")) {
            deploymentDir = "jaggeryapps";
        } else if (webappType.equals("jaxWebapp")) {
            deploymentDir = "jaxwebapps";
        }
        String repoPath = configurationContext.getAxisConfiguration().getRepository().getPath();
        if (repoPath.contains(CarbonConstants.TENANTS_REPO) && GhostWebappDeployerUtils.isGhostWebApp(webApplication) && (fileName = (String)webApplication.getProperty("AppFileName")) != null && !(fileToUpdate = new File(filePath = repoPath + File.separator + deploymentDir + File.separator + fileName)).exists() && (depsync = DataHolder.getDeploymentSynchronizerService()) != null && CarbonUtils.isDepSyncEnabled()) {
            try {
                depsync.update(repoPath, filePath, 3);
                if (fileToUpdate.exists()) {
                    DeploymentFileData dfd = new DeploymentFileData(fileToUpdate);
                    GhostDeployer ghostDeployer = GhostDeployerUtils.getGhostDeployer((AxisConfiguration)configurationContext.getAxisConfiguration());
                    if (ghostDeployer != null && ghostDeployer.getFileData(filePath) == null) {
                        File deployedWebappFile = new File(webApplication.getWebappFile().getName());
                        if (webappsHolder.getStartedWebapps().containsKey(deployedWebappFile.getName())) {
                            webappsHolder.getStartedWebapps().remove(deployedWebappFile.getName());
                        }
                        webApplication.setWebappFile(dfd.getFile());
                        webappsHolder.getStartedWebapps().put(dfd.getFile().getName(), webApplication);
                        ghostDeployer.addFileData(dfd);
                    }
                }
            }
            catch (Throwable t) {
                log.error((Object)"Deployment synchronization update failed", t);
            }
        }
    }
}

