/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.ntask.core.service.impl;

import java.io.File;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.ntask.common.TaskException;
import org.wso2.carbon.ntask.core.TaskManager;
import org.wso2.carbon.ntask.core.TaskManagerFactory;
import org.wso2.carbon.ntask.core.TaskManagerId;
import org.wso2.carbon.ntask.core.TaskUtils;
import org.wso2.carbon.ntask.core.impl.clustered.ClusterGroupCommunicator;
import org.wso2.carbon.ntask.core.impl.clustered.ClusteredTaskManagerFactory;
import org.wso2.carbon.ntask.core.impl.remote.RemoteTaskManagerFactory;
import org.wso2.carbon.ntask.core.impl.standalone.StandaloneTaskManagerFactory;
import org.wso2.carbon.ntask.core.internal.TasksDSComponent;
import org.wso2.carbon.ntask.core.service.TaskService;
import org.wso2.carbon.ntask.core.service.impl.TaskServiceXMLConfiguration;
import org.wso2.carbon.utils.CarbonUtils;

public class TaskServiceImpl
implements TaskService {
    private static final Log log = LogFactory.getLog(TaskServiceImpl.class);
    private Set<String> registeredTaskTypes = new HashSet<String>();
    private boolean serverInit;
    private TaskManagerFactory taskManagerFactory;
    private TaskService.TaskServiceConfiguration taskServerConfiguration = new TaskServiceConfigurationImpl(this.loadTaskServiceXMLConfig());

    public TaskServiceImpl() throws TaskException {
        switch (this.getServerConfiguration().getTaskServerMode()) {
            case CLUSTERED: {
                this.taskManagerFactory = new ClusteredTaskManagerFactory();
                break;
            }
            case REMOTE: {
                this.taskManagerFactory = new RemoteTaskManagerFactory();
                break;
            }
            case STANDALONE: {
                this.taskManagerFactory = new StandaloneTaskManagerFactory();
            }
        }
    }

    private TaskServiceXMLConfiguration loadTaskServiceXMLConfig() throws TaskException {
        String path = CarbonUtils.getCarbonConfigDirPath() + File.separator + "etc" + File.separator + "tasks-config.xml";
        File file = new File(path);
        if (!file.exists()) {
            return null;
        }
        Document doc = TaskUtils.convertToDocument(file);
        TaskUtils.secureResolveDocument(doc);
        try {
            JAXBContext ctx = JAXBContext.newInstance((Class[])new Class[]{TaskServiceXMLConfiguration.class});
            TaskServiceXMLConfiguration taskConfig = (TaskServiceXMLConfiguration)ctx.createUnmarshaller().unmarshal((Node)doc);
            return taskConfig;
        }
        catch (JAXBException e) {
            throw new TaskException(e.getMessage(), TaskException.Code.CONFIG_ERROR, (Exception)((Object)e));
        }
    }

    public boolean isServerInit() {
        return this.serverInit;
    }

    public TaskManagerFactory getTaskManagerFactory() {
        return this.taskManagerFactory;
    }

    @Override
    public Set<String> getRegisteredTaskTypes() {
        return this.registeredTaskTypes;
    }

    private void initTaskManagersForType(String taskType) throws TaskException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Initializing task managers [" + taskType + "]"));
        }
        List<TaskManager> startupTms = this.getTaskManagerFactory().getStartupSchedulingTaskManagersForType(taskType);
        for (TaskManager tm : startupTms) {
            tm.scheduleAllTasks();
        }
    }

    @Override
    public TaskManager getTaskManager(String taskType) throws TaskException {
        int tid = PrivilegedCarbonContext.getCurrentContext().getTenantId();
        return this.getTaskManagerFactory().getTaskManager(new TaskManagerId(tid, taskType));
    }

    @Override
    public List<TaskManager> getAllTenantTaskManagersForType(String taskType) throws TaskException {
        return this.getTaskManagerFactory().getAllTenantTaskManagersForType(taskType);
    }

    @Override
    public synchronized void registerTaskType(String taskType) throws TaskException {
        this.registeredTaskTypes.add(taskType);
        if (this.getServerConfiguration().getTaskServerMode() == TaskService.TaskServerMode.CLUSTERED) {
            ClusterGroupCommunicator.getInstance().newTaskTypeAdded(taskType);
        }
        if (this.isServerInit()) {
            this.initTaskManagersForType(taskType);
        }
    }

    @Override
    public synchronized void serverInitialized() {
        try {
            for (String taskType : this.getRegisteredTaskTypes()) {
                this.initTaskManagersForType(taskType);
            }
            this.serverInit = true;
        }
        catch (TaskException e) {
            String msg = "Error initializing task managers: " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw new RuntimeException(msg, e);
        }
    }

    @Override
    public TaskService.TaskServiceConfiguration getServerConfiguration() {
        return this.taskServerConfiguration;
    }

    private class TaskServiceConfigurationImpl
    implements TaskService.TaskServiceConfiguration {
        private TaskService.TaskServerMode taskServerMode;
        private int taskServerCount = -1;
        private String taskClientDispatchAddress;
        private String remoteServerAddress;
        private String remoteServerUsername;
        private String remoteServerPassword;

        public TaskServiceConfigurationImpl(TaskServiceXMLConfiguration taskXMLConfig) {
            this.processXMLConfig(taskXMLConfig);
            this.processSystemProps();
        }

        private void processXMLConfig(TaskServiceXMLConfiguration taskXMLConfig) {
            if (taskXMLConfig == null) {
                return;
            }
            this.taskClientDispatchAddress = taskXMLConfig.getTaskClientDispatchAddress();
            this.remoteServerAddress = taskXMLConfig.getRemoteServerAddress();
            this.remoteServerUsername = taskXMLConfig.getRemoteServerUsername();
            this.remoteServerPassword = taskXMLConfig.getRemoteServerPassword();
            this.taskServerMode = taskXMLConfig.getTaskServerMode();
            this.taskServerCount = taskXMLConfig.getTaskServerCount();
        }

        private void processSystemProps() {
            this.taskClientDispatchAddress = this.returnSystemPropValueIfValid(this.taskClientDispatchAddress, "task.client.dispatch.address");
            this.remoteServerAddress = this.returnSystemPropValueIfValid(this.remoteServerAddress, "task.server.remote.address");
            this.remoteServerUsername = this.returnSystemPropValueIfValid(this.remoteServerUsername, "task.server.remote.username");
            this.remoteServerPassword = this.returnSystemPropValueIfValid(this.remoteServerPassword, "task.server.remote.password");
            if (this.taskServerMode == null) {
                this.taskServerMode = this.getRemoteServerAddress() != null ? TaskService.TaskServerMode.REMOTE : (TasksDSComponent.getCoordinationService().isEnabled() ? TaskService.TaskServerMode.CLUSTERED : TaskService.TaskServerMode.STANDALONE);
            }
            if (this.taskServerCount == -1) {
                String taskServerCountStr = System.getProperty("task.server.count");
                this.taskServerCount = taskServerCountStr != null ? Integer.parseInt(taskServerCountStr) : -1;
            }
        }

        private String returnSystemPropValueIfValid(String originalValue, String sysPropName) {
            String sysPropValue = System.getProperty(sysPropName);
            if (sysPropValue != null) {
                return sysPropValue;
            }
            return originalValue;
        }

        @Override
        public String getTaskClientDispatchAddress() {
            return this.taskClientDispatchAddress;
        }

        @Override
        public TaskService.TaskServerMode getTaskServerMode() {
            return this.taskServerMode;
        }

        @Override
        public String getRemoteServerAddress() {
            return this.remoteServerAddress;
        }

        @Override
        public String getRemoteServerUsername() {
            return this.remoteServerUsername;
        }

        @Override
        public String getRemoteServerPassword() {
            return this.remoteServerPassword;
        }

        @Override
        public int getTaskServerCount() {
            return this.taskServerCount;
        }
    }
}

