/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.ntask.core.impl.remote;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.axis2.clustering.ClusteringAgent;
import org.apache.axis2.clustering.ClusteringCommand;
import org.apache.axis2.clustering.ClusteringFault;
import org.apache.axis2.clustering.ClusteringMessage;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.ntask.common.TaskException;
import org.wso2.carbon.ntask.core.Task;
import org.wso2.carbon.ntask.core.TaskInfo;
import org.wso2.carbon.ntask.core.TaskManager;
import org.wso2.carbon.ntask.core.TaskRepository;
import org.wso2.carbon.ntask.core.impl.remote.RemoteTaskUtils;
import org.wso2.carbon.ntask.core.internal.TasksDSComponent;
import org.wso2.carbon.remotetasks.stub.admin.common.RemoteTaskAdmin;
import org.wso2.carbon.remotetasks.stub.admin.common.xsd.DeployedTaskInformation;
import org.wso2.carbon.utils.ConfigurationContextService;

public class RemoteTaskManager
implements TaskManager {
    private static final Log log = LogFactory.getLog(RemoteTaskManager.class);
    public static final String REMOTE_TASK_SERVER_ADDRESS = "task.server.remote.address";
    public static final String REMOTE_TASK_SERVER_USERNAME = "task.server.remote.username";
    public static final String REMOTE_TASK_SERVER_PASSWORD = "task.server.remote.password";
    public static final String TASK_CLIENT_DISPATCH_ADDRESS = "task.client.dispatch.address";
    public static final String REMOTE_TASK_ID_REPO_PROP = "REMOTE_TASK_ID_REPO_PROP";
    private TaskRepository taskRepository;
    private RemoteTaskAdmin remoteTaskAdmin;
    private static Map<String, Integer> runningTasksMap = new ConcurrentHashMap<String, Integer>();

    public RemoteTaskManager(TaskRepository taskRepository, RemoteTaskAdmin remoteTaskAdmin) {
        this.taskRepository = taskRepository;
        this.remoteTaskAdmin = remoteTaskAdmin;
    }

    public RemoteTaskAdmin getRemoteTaskAdmin() {
        return this.remoteTaskAdmin;
    }

    public TaskRepository getTaskRepository() {
        return this.taskRepository;
    }

    public int getTenantId() {
        return this.getTaskRepository().getTenantId();
    }

    public String getTaskType() {
        return this.getTaskRepository().getTasksType();
    }

    @Override
    public void scheduleAllTasks() throws TaskException {
        for (TaskInfo taskInfo : this.getAllTasks()) {
            try {
                this.scheduleTask(taskInfo.getName());
            }
            catch (Exception e) {
                log.error((Object)("Error in scheduling task '" + taskInfo.getName() + "': " + e.getMessage()), (Throwable)e);
            }
        }
    }

    @Override
    public void scheduleTask(String taskName) throws TaskException {
        String remoteTaskId = RemoteTaskUtils.createRemoteTaskMapping(this.getTenantId(), this.getTaskType(), taskName);
        this.getTaskRepository().setTaskMetadataProp(taskName, REMOTE_TASK_ID_REPO_PROP, remoteTaskId);
        TaskInfo taskInfo = this.getTaskRepository().getTask(taskName);
        try {
            this.getRemoteTaskAdmin().addRemoteSystemTask(RemoteTaskUtils.convert(taskInfo, this.getTaskType(), remoteTaskId, this.getTenantId()), this.getTenantId());
        }
        catch (Exception e) {
            throw new TaskException(e.getMessage(), TaskException.Code.UNKNOWN, e);
        }
    }

    @Override
    public void rescheduleTask(String taskName) throws TaskException {
        this.deleteTask(taskName, false);
        this.scheduleTask(taskName);
    }

    @Override
    public boolean deleteTask(String taskName) throws TaskException {
        return this.deleteTask(taskName, true);
    }

    private boolean deleteTask(String taskName, boolean removeFromRepo) throws TaskException {
        try {
            boolean result = this.getRemoteTaskAdmin().deleteRemoteSystemTask(RemoteTaskUtils.remoteTaskNameFromTaskInfo(this.getTaskType(), taskName), this.getTenantId());
            String remoteTaskId = this.getTaskRepository().getTaskMetadataProp(taskName, REMOTE_TASK_ID_REPO_PROP);
            if (remoteTaskId != null) {
                RemoteTaskUtils.removeRemoteTaskMapping(remoteTaskId);
            }
            if (removeFromRepo) {
                result &= this.getTaskRepository().deleteTask(taskName);
            }
            return result;
        }
        catch (Exception e) {
            throw new TaskException(e.getMessage(), TaskException.Code.UNKNOWN, e);
        }
    }

    @Override
    public void pauseTask(String taskName) throws TaskException {
        try {
            this.getRemoteTaskAdmin().pauseRemoteSystemTask(RemoteTaskUtils.remoteTaskNameFromTaskInfo(this.getTaskType(), taskName), this.getTenantId());
        }
        catch (Exception e) {
            throw new TaskException(e.getMessage(), TaskException.Code.UNKNOWN, e);
        }
    }

    @Override
    public void resumeTask(String taskName) throws TaskException {
        try {
            this.getRemoteTaskAdmin().resumeRemoteSystemTask(RemoteTaskUtils.remoteTaskNameFromTaskInfo(this.getTaskType(), taskName), this.getTenantId());
        }
        catch (Exception e) {
            throw new TaskException(e.getMessage(), TaskException.Code.UNKNOWN, e);
        }
    }

    @Override
    public void registerTask(TaskInfo taskInfo) throws TaskException {
        this.getTaskRepository().addTask(taskInfo);
    }

    public TaskManager.TaskState getTaskStateRemote(String taskName) throws TaskException {
        try {
            DeployedTaskInformation depTaskInfo = this.getRemoteTaskAdmin().getRemoteSystemTask(RemoteTaskUtils.remoteTaskNameFromTaskInfo(this.getTaskType(), taskName), this.getTenantId());
            if (depTaskInfo == null) {
                return TaskManager.TaskState.NONE;
            }
            TaskManager.TaskState ts = TaskManager.TaskState.valueOf(depTaskInfo.getStatus());
            return ts;
        }
        catch (Exception e) {
            throw new TaskException(e.getMessage(), TaskException.Code.UNKNOWN, e);
        }
    }

    private ClusteringAgent getClusteringAgent() throws TaskException {
        ConfigurationContextService configCtxService = TasksDSComponent.getConfigurationContextService();
        if (configCtxService == null) {
            throw new TaskException("ConfigurationContextService not available for notifying the cluster", TaskException.Code.UNKNOWN);
        }
        ConfigurationContext configCtx = configCtxService.getServerConfigContext();
        ClusteringAgent agent = configCtx.getAxisConfiguration().getClusteringAgent();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Clustering Agent: " + agent));
        }
        return agent;
    }

    private TaskManager.TaskState getTaskStateFromLocalCluster(String taskName) throws TaskException {
        ClusteringAgent agent = this.getClusteringAgent();
        if (agent == null) {
            return TaskManager.TaskState.UNKNOWN;
        }
        TaskStatusMessage msg = new TaskStatusMessage();
        msg.setTaskName(taskName);
        msg.setTaskType(this.getTaskType());
        msg.setTenantId(this.getTenantId());
        try {
            if (this.isTaskRunning(taskName)) {
                return TaskManager.TaskState.BLOCKED;
            }
            List result = agent.sendMessage((ClusteringMessage)msg, true);
            for (ClusteringCommand entry : result) {
                TaskStatusResult status = (TaskStatusResult)entry;
                if (!status.isRunning()) continue;
                return TaskManager.TaskState.BLOCKED;
            }
            return TaskManager.TaskState.NORMAL;
        }
        catch (ClusteringFault e) {
            throw new TaskException(e.getMessage(), TaskException.Code.UNKNOWN, (Exception)((Object)e));
        }
    }

    @Override
    public TaskManager.TaskState getTaskState(String taskName) throws TaskException {
        TaskManager.TaskState taskState = this.getTaskStateRemote(taskName);
        if (taskState == TaskManager.TaskState.NORMAL) {
            taskState = this.getTaskStateFromLocalCluster(taskName);
        }
        return taskState;
    }

    @Override
    public TaskInfo getTask(String taskName) throws TaskException {
        return this.getTaskRepository().getTask(taskName);
    }

    @Override
    public List<TaskInfo> getAllTasks() throws TaskException {
        return this.getTaskRepository().getAllTasks();
    }

    @Override
    public boolean isTaskScheduled(String taskName) throws TaskException {
        return this.getTaskState(taskName) != TaskManager.TaskState.NONE;
    }

    public void runTask(String taskName) throws TaskException {
        TasksDSComponent.executeTask(new TaskExecution(taskName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addRunningTask(String runningTaskId) {
        Map<String, Integer> map = runningTasksMap;
        synchronized (map) {
            Integer value = runningTasksMap.get(runningTaskId);
            if (value != null) {
                Integer n = value;
                Integer n2 = value = Integer.valueOf(value + 1);
            } else {
                value = 1;
            }
            runningTasksMap.put(runningTaskId, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeRunningTask(String runningTaskId) {
        Map<String, Integer> map = runningTasksMap;
        synchronized (map) {
            Integer value = runningTasksMap.get(runningTaskId);
            if (value != null) {
                Integer n = value;
                Integer n2 = value = Integer.valueOf(value - 1);
                if (value <= 0) {
                    runningTasksMap.remove(runningTaskId);
                } else {
                    runningTasksMap.put(runningTaskId, value);
                }
            }
        }
    }

    public static boolean isRunningTaskExist(String runningTaskId) {
        return runningTasksMap.containsKey(runningTaskId);
    }

    public boolean isTaskRunning(String taskName) throws TaskException {
        return RemoteTaskManager.isRunningTaskExist(this.generateRunningTaskId(taskName));
    }

    private String generateRunningTaskId(String taskName) {
        return this.getTenantId() + "#" + this.getTaskType() + "#" + taskName;
    }

    public static class TaskStatusResult
    extends ClusteringCommand {
        private static final long serialVersionUID = 4982249263193601405L;
        private boolean running;

        public boolean isRunning() {
            return this.running;
        }

        public void setRunning(boolean running) {
            this.running = running;
        }

        public void execute(ConfigurationContext ctx) throws ClusteringFault {
        }
    }

    public static class TaskStatusMessage
    extends ClusteringMessage {
        private static final long serialVersionUID = 8904018070655665868L;
        private int tenantId;
        private String taskType;
        private String taskName;
        private TaskStatusResult result;

        public int getTenantId() {
            return this.tenantId;
        }

        public void setTenantId(int tenantId) {
            this.tenantId = tenantId;
        }

        public String getTaskType() {
            return this.taskType;
        }

        public void setTaskType(String taskType) {
            this.taskType = taskType;
        }

        public String getTaskName() {
            return this.taskName;
        }

        public void setTaskName(String taskName) {
            this.taskName = taskName;
        }

        public ClusteringCommand getResponse() {
            return this.result;
        }

        public void execute(ConfigurationContext ctx) throws ClusteringFault {
            try {
                PrivilegedCarbonContext.startTenantFlow();
                PrivilegedCarbonContext.getCurrentContext().setTenantId(this.getTenantId());
                TaskManager tm = TasksDSComponent.getTaskService().getTaskManager(this.getTaskType());
                if (tm instanceof RemoteTaskManager) {
                    this.result = new TaskStatusResult();
                    this.result.setRunning(((RemoteTaskManager)tm).isTaskRunning(this.getTaskName()));
                }
            }
            catch (Exception e) {
                throw new ClusteringFault(e.getMessage(), e);
            }
            finally {
                PrivilegedCarbonContext.endTenantFlow();
            }
        }
    }

    private class TaskExecution
    implements Runnable {
        private String taskName;

        public TaskExecution(String taskName) {
            this.taskName = taskName;
        }

        public String getTaskName() {
            return this.taskName;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            String runningTaskId = RemoteTaskManager.this.generateRunningTaskId(this.getTaskName());
            try {
                TaskInfo taskInfo = RemoteTaskManager.this.getTaskRepository().getTask(this.getTaskName());
                if (taskInfo.getTriggerInfo().isDisallowConcurrentExecution() && RemoteTaskManager.isRunningTaskExist(runningTaskId)) {
                    return;
                }
                try {
                    RemoteTaskManager.addRunningTask(runningTaskId);
                    Task task = (Task)Class.forName(taskInfo.getTaskClass()).newInstance();
                    task.setProperties(taskInfo.getProperties());
                    try {
                        PrivilegedCarbonContext.startTenantFlow();
                        PrivilegedCarbonContext.getCurrentContext().setTenantId(RemoteTaskManager.this.getTenantId());
                        task.init();
                        task.execute();
                    }
                    finally {
                        PrivilegedCarbonContext.endTenantFlow();
                    }
                }
                finally {
                    RemoteTaskManager.removeRunningTask(runningTaskId);
                }
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }
}

