/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.ntask.core.impl.clustered;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.coordination.common.CoordinationException;
import org.wso2.carbon.coordination.core.sync.Group;
import org.wso2.carbon.coordination.core.sync.GroupEventListener;
import org.wso2.carbon.ntask.common.TaskException;
import org.wso2.carbon.ntask.core.TaskManager;
import org.wso2.carbon.ntask.core.impl.clustered.ClusteredTaskManager;
import org.wso2.carbon.ntask.core.internal.TasksDSComponent;
import org.wso2.carbon.ntask.core.service.TaskService;

public class ClusterGroupCommunicator {
    public static final String TASK_SERVER_COUNT_SYS_PROP = "task.server.count";
    public static final String CARBON_TASK_GROUP_BASE = "__CARBON_TASK_GROUP_";
    public static final String CARBON_TASK_SERVER_STARTUP_GROUP = "__CARBON_TASK_GROUP___SERVER_STARTUP_GROUP__";
    private static final Log log = LogFactory.getLog(ClusterGroupCommunicator.class);
    private static ClusterGroupCommunicator instance;
    private Map<String, ClusterGroup> clusterGroupMap;
    private TaskService taskService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ClusterGroupCommunicator getInstance() throws TaskException {
        if (instance != null) return instance;
        Class<ClusterGroupCommunicator> clazz = ClusterGroupCommunicator.class;
        synchronized (ClusterGroupCommunicator.class) {
            if (instance != null) return instance;
            instance = new ClusterGroupCommunicator(TasksDSComponent.getTaskService());
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private ClusterGroupCommunicator(TaskService taskService) throws TaskException {
        this.taskService = taskService;
        this.clusterGroupMap = new HashMap<String, ClusterGroup>();
    }

    public void checkServers() throws CoordinationException {
        int serverCount = this.getTaskService().getServerConfiguration().getTaskServerCount();
        if (serverCount != -1) {
            log.info((Object)("Waiting for " + serverCount + " task servers..."));
            Group group = TasksDSComponent.getCoordinationService().createGroup(CARBON_TASK_SERVER_STARTUP_GROUP);
            group.waitForMemberCount(serverCount);
            log.info((Object)"All task servers activated.");
        }
    }

    public void newTaskTypeAdded(String taskType) throws TaskException {
        this.clusterGroupMap.put(taskType, new ClusterGroup(taskType));
    }

    public TaskService getTaskService() {
        return this.taskService;
    }

    public ClusterGroup getClusterGroup(String taskType) {
        return this.clusterGroupMap.get(taskType);
    }

    public String getLeaderId(String taskType) throws CoordinationException {
        return this.getClusterGroup(taskType).getLeaderId();
    }

    public List<String> getMemberIds(String taskType) throws CoordinationException {
        return this.getClusterGroup(taskType).getMemberIds();
    }

    public String getMemberId(String taskType) throws CoordinationException {
        return this.getClusterGroup(taskType).getMemberId();
    }

    public boolean isLeader(String taskType) throws TaskException {
        return this.getClusterGroup(taskType).isLeader();
    }

    public byte[] sendReceive(int tenantId, String taskType, String memberId, String messageHeader, byte[] payload) throws Exception {
        return this.getClusterGroup(taskType).sendReceive(tenantId, memberId, messageHeader, payload);
    }

    public static byte[] objectToBytes(Object obj) throws Exception {
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        ObjectOutputStream objOut = new ObjectOutputStream(byteOut);
        objOut.writeObject(obj);
        objOut.close();
        return byteOut.toByteArray();
    }

    public static Object bytesToObject(byte[] data) throws Exception {
        ByteArrayInputStream byteIn = new ByteArrayInputStream(data);
        ObjectInputStream objIn = new ObjectInputStream(byteIn);
        Object obj = objIn.readObject();
        objIn.close();
        return obj;
    }

    public static class OperationResponse
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private byte[] payload;

        public OperationResponse(byte[] payload) {
            this.payload = payload;
        }

        public byte[] getPayload() {
            return this.payload;
        }
    }

    public static class OperationRequest
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private int tenantId;
        private String opName;
        private byte[] payload;

        public OperationRequest(int tenantId, String opName, byte[] payload) {
            this.tenantId = tenantId;
            this.opName = opName;
            this.payload = payload;
        }

        public int getTenantId() {
            return this.tenantId;
        }

        public String getOpName() {
            return this.opName;
        }

        public byte[] getPayload() {
            return this.payload;
        }
    }

    public class ClusterGroup
    implements GroupEventListener {
        private String taskType;
        private Group group;
        private boolean leader;

        public ClusterGroup(String taskType) throws TaskException {
            this.taskType = taskType;
            try {
                this.group = TasksDSComponent.getCoordinationService().createGroup(ClusterGroupCommunicator.CARBON_TASK_GROUP_BASE + this.getTaskType());
                this.group.setGroupEventListener((GroupEventListener)this);
                try {
                    this.leader = this.getGroup().getLeaderId().equals(this.getGroup().getMemberId());
                }
                catch (CoordinationException e) {
                    throw new TaskException("Error in creating cluster group: " + e.getMessage(), TaskException.Code.UNKNOWN, (Exception)((Object)e));
                }
            }
            catch (CoordinationException e) {
                throw new TaskException(e.getMessage(), TaskException.Code.UNKNOWN, (Exception)((Object)e));
            }
        }

        public List<String> getMemberIds() throws CoordinationException {
            return this.getGroup().getMemberIds();
        }

        public String getMemberId() throws CoordinationException {
            return this.getGroup().getMemberId();
        }

        public String getLeaderId() throws CoordinationException {
            return this.getGroup().getLeaderId();
        }

        public Group getGroup() {
            return this.group;
        }

        public byte[] sendReceive(int tenantId, String memberId, String messageHeader, byte[] payload) throws Exception {
            OperationRequest req = new OperationRequest(tenantId, messageHeader, payload);
            byte[] result = this.getGroup().sendReceive(memberId, ClusterGroupCommunicator.objectToBytes(req));
            OperationResponse res = (OperationResponse)ClusterGroupCommunicator.bytesToObject(result);
            return res.getPayload();
        }

        public void onLeaderChange(String leaderId) {
            if (log.isDebugEnabled()) {
                log.info((Object)("Task server leader changed [" + this.getTaskType() + "]: " + leaderId));
            }
            this.leader = leaderId.equals(this.getGroup().getMemberId());
            try {
                if (this.isLeader()) {
                    log.info((Object)("Task server leader changed [" + this.getTaskType() + "], rescheduling missing tasks..."));
                    this.scheduleAllMissingTasks();
                }
            }
            catch (TaskException e) {
                log.error((Object)("Error in scheduling missing tasks: " + e.getMessage()), (Throwable)e);
            }
        }

        public boolean isLeader() {
            return this.leader;
        }

        public String getTaskType() {
            return this.taskType;
        }

        public void onGroupMessage(byte[] buff) {
        }

        public void onMemberArrival(String mid) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Task member arrived: " + mid));
            }
        }

        private void scheduleAllMissingTasks() throws TaskException {
            for (TaskManager tm : ClusterGroupCommunicator.this.getTaskService().getAllTenantTaskManagersForType(this.getTaskType())) {
                if (!(tm instanceof ClusteredTaskManager)) continue;
                ((ClusteredTaskManager)tm).scheduleMissingTasks();
            }
        }

        public void onMemberDeparture(String mid) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Task member departed: " + mid));
            }
            try {
                if (this.isLeader()) {
                    log.info((Object)("Task member departed [" + this.getTaskType() + "], rescheduling missing tasks..."));
                    this.scheduleAllMissingTasks();
                }
            }
            catch (TaskException e) {
                log.error((Object)("Error in scheduling missing tasks: " + e.getMessage()), (Throwable)e);
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public byte[] onPeerMessage(byte[] buff) throws CoordinationException {
            try {
                OperationRequest req = (OperationRequest)ClusterGroupCommunicator.bytesToObject(buff);
                try {
                    PrivilegedCarbonContext.startTenantFlow();
                    PrivilegedCarbonContext.getCurrentContext().setTenantId(req.getTenantId());
                    TaskManager tm = ClusterGroupCommunicator.this.getTaskService().getTaskManager(this.getTaskType());
                    if (!(tm instanceof ClusteredTaskManager)) throw new CoordinationException("Invalid task manager type, expected 'clustered' type, got: " + tm, CoordinationException.ExceptionCode.GENERIC_ERROR);
                    OperationResponse res = ((ClusteredTaskManager)tm).onOperationRequest(req);
                    byte[] byArray = ClusterGroupCommunicator.objectToBytes(res);
                    return byArray;
                }
                finally {
                    PrivilegedCarbonContext.endTenantFlow();
                }
            }
            catch (Exception e) {
                throw new CoordinationException(e.getMessage(), CoordinationException.ExceptionCode.GENERIC_ERROR, e);
            }
        }
    }
}

