/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.ntask.core.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.CronScheduleBuilder;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;
import org.quartz.impl.matchers.GroupMatcher;
import org.quartz.spi.OperableTrigger;
import org.wso2.carbon.ntask.common.TaskException;
import org.wso2.carbon.ntask.core.TaskInfo;
import org.wso2.carbon.ntask.core.TaskManager;
import org.wso2.carbon.ntask.core.TaskRepository;
import org.wso2.carbon.ntask.core.TaskUtils;
import org.wso2.carbon.ntask.core.impl.NonConcurrentTaskQuartzJobAdapter;
import org.wso2.carbon.ntask.core.impl.TaskQuartzJobAdapter;
import org.wso2.carbon.ntask.core.internal.TasksDSComponent;

public abstract class AbstractQuartzTaskManager
implements TaskManager {
    private static final Log log = LogFactory.getLog(AbstractQuartzTaskManager.class);
    private TaskRepository taskRepository;
    private Scheduler scheduler;

    public AbstractQuartzTaskManager(TaskRepository taskRepository) throws TaskException {
        this.taskRepository = taskRepository;
        this.scheduler = TasksDSComponent.getScheduler();
    }

    public TaskRepository getTaskRepository() {
        return this.taskRepository;
    }

    protected Scheduler getScheduler() {
        return this.scheduler;
    }

    public int getTenantId() {
        return this.getTaskRepository().getTenantId();
    }

    public String getTaskType() {
        return this.getTaskRepository().getTasksType();
    }

    protected TaskManager.TaskState getLocalTaskState(String taskName) throws TaskException {
        String taskGroup = this.getTenantTaskGroup();
        try {
            return this.triggerStateToTaskState(this.getScheduler().getTriggerState(new TriggerKey(taskName, taskGroup)));
        }
        catch (SchedulerException e) {
            throw new TaskException("Error in checking state of the task with the name: " + taskName, TaskException.Code.UNKNOWN, (Exception)((Object)e));
        }
    }

    protected Map<String, TaskManager.TaskState> getAllLocalTaskStates() throws TaskException {
        try {
            Set keys = this.getScheduler().getTriggerKeys(GroupMatcher.triggerGroupEquals((String)this.getTenantTaskGroup()));
            HashMap<String, TaskManager.TaskState> states = new HashMap<String, TaskManager.TaskState>();
            for (TriggerKey key : keys) {
                states.put(key.getName(), this.triggerStateToTaskState(this.getScheduler().getTriggerState(new TriggerKey(key.getName(), key.getGroup()))));
            }
            return states;
        }
        catch (SchedulerException e) {
            throw new TaskException("Error in retrieving task states", TaskException.Code.UNKNOWN, (Exception)((Object)e));
        }
    }

    protected void registerLocalTask(TaskInfo taskInfo) throws TaskException {
        this.getTaskRepository().addTask(taskInfo);
    }

    private TaskManager.TaskState triggerStateToTaskState(Trigger.TriggerState triggerState) {
        if (triggerState == Trigger.TriggerState.NONE) {
            return TaskManager.TaskState.NONE;
        }
        if (triggerState == Trigger.TriggerState.PAUSED) {
            return TaskManager.TaskState.PAUSED;
        }
        if (triggerState == Trigger.TriggerState.COMPLETE) {
            return TaskManager.TaskState.FINISHED;
        }
        if (triggerState == Trigger.TriggerState.ERROR) {
            return TaskManager.TaskState.ERROR;
        }
        if (triggerState == Trigger.TriggerState.NORMAL) {
            return TaskManager.TaskState.NORMAL;
        }
        if (triggerState == Trigger.TriggerState.BLOCKED) {
            return TaskManager.TaskState.BLOCKED;
        }
        return TaskManager.TaskState.UNKNOWN;
    }

    protected synchronized boolean deleteLocalTask(String taskName, boolean removeRegistration) throws TaskException {
        String taskGroup = this.getTenantTaskGroup();
        boolean result = false;
        try {
            result = this.getScheduler().deleteJob(new JobKey(taskName, taskGroup));
        }
        catch (SchedulerException e) {
            throw new TaskException("Error in deleting task with name: " + taskName, TaskException.Code.UNKNOWN, (Exception)((Object)e));
        }
        if (removeRegistration) {
            result &= this.getTaskRepository().deleteTask(taskName);
        }
        return result;
    }

    protected synchronized void pauseLocalTask(String taskName) throws TaskException {
        String taskGroup = this.getTenantTaskGroup();
        try {
            this.getScheduler().pauseJob(new JobKey(taskName, taskGroup));
        }
        catch (SchedulerException e) {
            throw new TaskException("Error in pausing task with name: " + taskName, TaskException.Code.UNKNOWN, (Exception)((Object)e));
        }
    }

    private String getTenantTaskGroup() {
        return "TENANT_" + this.getTenantId() + "_TYPE_" + this.getTaskType();
    }

    private JobDataMap getJobDataMapFromTaskInfo(TaskInfo taskInfo) {
        JobDataMap dataMap = new JobDataMap();
        dataMap.put("__TASK_CLASS_NAME__", taskInfo.getTaskClass());
        dataMap.put("__TASK_PROPERTIES__", taskInfo.getProperties());
        return dataMap;
    }

    protected synchronized void scheduleLocalAllTasks() throws TaskException {
        List<TaskInfo> tasks = this.getTaskRepository().getAllTasks();
        for (TaskInfo task : tasks) {
            try {
                this.scheduleTask(task.getName());
            }
            catch (Exception e) {
                log.error((Object)("Error in scheduling task: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    protected synchronized void scheduleLocalTask(String taskName) throws TaskException {
        boolean paused = TaskUtils.isTaskPaused(this.getTaskRepository(), taskName);
        this.scheduleLocalTask(taskName, paused);
    }

    protected synchronized void scheduleLocalTask(String taskName, boolean paused) throws TaskException {
        TaskInfo taskInfo = this.getTaskRepository().getTask(taskName);
        String taskGroup = this.getTenantTaskGroup();
        if (taskInfo == null) {
            throw new TaskException("Non-existing task for scheduling with name: " + taskName, TaskException.Code.NO_TASK_EXISTS);
        }
        if (this.containsLocalTask(taskName, taskGroup)) {
            throw new TaskException("The task with name: " + taskName + ", already started.", TaskException.Code.TASK_ALREADY_STARTED);
        }
        Class jobClass = taskInfo.getTriggerInfo().isDisallowConcurrentExecution() ? NonConcurrentTaskQuartzJobAdapter.class : TaskQuartzJobAdapter.class;
        JobDetail job = JobBuilder.newJob(jobClass).withIdentity(taskName, taskGroup).usingJobData(this.getJobDataMapFromTaskInfo(taskInfo)).build();
        Trigger trigger = this.getTriggerFromInfo(taskName, taskGroup, taskInfo.getTriggerInfo());
        try {
            this.getScheduler().scheduleJob(job, trigger);
            if (paused) {
                this.getScheduler().pauseJob(job.getKey());
            }
            log.info((Object)("Task scheduled: [" + this.getTenantId() + "][" + this.getTaskType() + "][" + taskName + "]"));
        }
        catch (SchedulerException e) {
            throw new TaskException("Error in scheduling task with name: " + taskName, TaskException.Code.UNKNOWN, (Exception)((Object)e));
        }
    }

    private Trigger getTriggerFromInfo(String taskName, String taskGroup, TaskInfo.TriggerInfo triggerInfo) throws TaskException {
        TriggerBuilder triggerBuilder = TriggerBuilder.newTrigger().withIdentity(taskName, taskGroup);
        triggerBuilder = triggerInfo.getStartTime() == null ? triggerBuilder.startNow() : triggerBuilder.startAt(triggerInfo.getStartTime());
        if (triggerInfo.getEndTime() != null) {
            triggerBuilder.endAt(triggerInfo.getEndTime());
        }
        Trigger trigger = triggerInfo.getCronExpression() != null ? triggerBuilder.withSchedule((ScheduleBuilder)this.getCronScheduleBuilder(triggerInfo)).build() : (triggerInfo.getRepeatCount() == 0 ? triggerBuilder.build() : triggerBuilder.withSchedule((ScheduleBuilder)this.getSimpleScheduleBuilder(triggerInfo)).build());
        return trigger;
    }

    protected synchronized void rescheduleLocalTask(String taskName) throws TaskException {
        String taskGroup = this.getTenantTaskGroup();
        TaskInfo taskInfo = this.getTaskRepository().getTask(taskName);
        Trigger trigger = this.getTriggerFromInfo(taskName, taskGroup, taskInfo.getTriggerInfo());
        try {
            boolean paused = TaskUtils.isTaskPaused(this.getTaskRepository(), taskName);
            Date resultDate = this.getScheduler().rescheduleJob(new TriggerKey(taskName, taskGroup), trigger);
            if (resultDate == null) {
                this.scheduleLocalTask(taskName, paused);
            } else if (paused) {
                this.pauseLocalTask(taskName);
            }
        }
        catch (SchedulerException e) {
            throw new TaskException("Error in rescheduling task with name: " + taskName, TaskException.Code.UNKNOWN, (Exception)((Object)e));
        }
    }

    protected synchronized void resumeLocalTask(String taskName) throws TaskException {
        String taskGroup = this.getTenantTaskGroup();
        if (!this.containsLocalTask(taskName, taskGroup)) {
            throw new TaskException("Non-existing task for resuming with name: " + taskName, TaskException.Code.NO_TASK_EXISTS);
        }
        try {
            Trigger trigger = this.getScheduler().getTrigger(new TriggerKey(taskName, taskGroup));
            if (trigger instanceof OperableTrigger) {
                ((OperableTrigger)trigger).setNextFireTime(((OperableTrigger)trigger).getFireTimeAfter(null));
            }
            this.getScheduler().resumeJob(new JobKey(taskName, taskGroup));
        }
        catch (SchedulerException e) {
            throw new TaskException("Error in resuming task with name: " + taskName, TaskException.Code.UNKNOWN, (Exception)((Object)e));
        }
    }

    protected synchronized boolean isLocalTaskScheduled(String taskName) throws TaskException {
        String taskGroup = this.getTenantTaskGroup();
        return this.containsLocalTask(taskName, taskGroup);
    }

    protected List<TaskInfo> getAllLocalScheduledTasks() throws TaskException {
        List<TaskInfo> tasks = this.getTaskRepository().getAllTasks();
        ArrayList<TaskInfo> result = new ArrayList<TaskInfo>();
        for (TaskInfo taskInfo : tasks) {
            if (!this.isLocalTaskScheduled(taskInfo.getName())) continue;
            result.add(taskInfo);
        }
        return result;
    }

    private boolean containsLocalTask(String taskName, String taskGroup) throws TaskException {
        try {
            return this.getScheduler().checkExists(new JobKey(taskName, taskGroup));
        }
        catch (SchedulerException e) {
            throw new TaskException("Error in retrieving task details", TaskException.Code.UNKNOWN, (Exception)((Object)e));
        }
    }

    private CronScheduleBuilder getCronScheduleBuilder(TaskInfo.TriggerInfo triggerInfo) throws TaskException {
        CronScheduleBuilder cb = CronScheduleBuilder.cronSchedule((String)triggerInfo.getCronExpression());
        cb = this.handleCronScheduleMisfirePolicy(triggerInfo, cb);
        return cb;
    }

    private CronScheduleBuilder handleCronScheduleMisfirePolicy(TaskInfo.TriggerInfo triggerInfo, CronScheduleBuilder cb) throws TaskException {
        switch (triggerInfo.getMisfirePolicy()) {
            case DEFAULT: {
                return cb;
            }
            case IGNORE_MISFIRES: {
                return cb.withMisfireHandlingInstructionIgnoreMisfires();
            }
            case FIRE_AND_PROCEED: {
                return cb.withMisfireHandlingInstructionFireAndProceed();
            }
            case DO_NOTHING: {
                return cb.withMisfireHandlingInstructionDoNothing();
            }
        }
        throw new TaskException("The task misfire policy '" + triggerInfo.getMisfirePolicy() + "' cannot be used in cron schedule tasks", TaskException.Code.CONFIG_ERROR);
    }

    private SimpleScheduleBuilder getSimpleScheduleBuilder(TaskInfo.TriggerInfo triggerInfo) throws TaskException {
        SimpleScheduleBuilder scheduleBuilder = null;
        if (triggerInfo.getRepeatCount() == -1) {
            scheduleBuilder = SimpleScheduleBuilder.simpleSchedule().repeatForever();
        } else if (triggerInfo.getRepeatCount() > 0) {
            scheduleBuilder = SimpleScheduleBuilder.simpleSchedule().withRepeatCount(triggerInfo.getRepeatCount());
        }
        scheduleBuilder = scheduleBuilder.withIntervalInMilliseconds((long)triggerInfo.getIntervalMillis());
        scheduleBuilder = this.handleSimpleScheduleMisfirePolicy(triggerInfo, scheduleBuilder);
        return scheduleBuilder;
    }

    private SimpleScheduleBuilder handleSimpleScheduleMisfirePolicy(TaskInfo.TriggerInfo triggerInfo, SimpleScheduleBuilder sb) throws TaskException {
        switch (triggerInfo.getMisfirePolicy()) {
            case DEFAULT: {
                return sb;
            }
            case FIRE_NOW: {
                return sb.withMisfireHandlingInstructionFireNow();
            }
            case IGNORE_MISFIRES: {
                return sb.withMisfireHandlingInstructionIgnoreMisfires();
            }
            case NEXT_WITH_EXISTING_COUNT: {
                return sb.withMisfireHandlingInstructionNextWithExistingCount();
            }
            case NEXT_WITH_REMAINING_COUNT: {
                return sb.withMisfireHandlingInstructionNextWithRemainingCount();
            }
            case NOW_WITH_EXISTING_COUNT: {
                return sb.withMisfireHandlingInstructionNowWithExistingCount();
            }
            case NOW_WITH_REMAINING_COUNT: {
                return sb.withMisfireHandlingInstructionNowWithRemainingCount();
            }
        }
        throw new TaskException("The task misfire policy '" + triggerInfo.getMisfirePolicy() + "' cannot be used in simple schedule tasks", TaskException.Code.CONFIG_ERROR);
    }
}

