/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.tomcat.ext.internal;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.catalina.connector.Request;
import org.wso2.carbon.context.ApplicationContext;

public class Utils {
    public static String getTenantDomain(HttpServletRequest request) {
        String requestURI = request.getRequestURI();
        String domain = "carbon.super";
        if (!requestURI.contains("/t/")) {
            HttpSession session = request.getSession(false);
            if (session != null && session.getAttribute("tenantDomain") != null) {
                domain = (String)session.getAttribute("tenantDomain");
            }
        } else {
            String temp = requestURI.substring(requestURI.indexOf("/t/") + 3);
            if (temp.indexOf(47) != -1) {
                domain = temp = temp.substring(0, temp.indexOf(47));
            }
        }
        return domain;
    }

    public static String getServiceName(String requestURI) {
        String serviceName = "";
        if (requestURI.contains("/services/")) {
            String[] temp2;
            String temp = requestURI.substring(requestURI.indexOf("/services/") + 9);
            if (temp.indexOf(47) != -1) {
                serviceName = temp = temp.substring(0, temp.length());
            }
            if (serviceName.contains("/t/") && (temp2 = serviceName.split("/")).length > 3) {
                serviceName = temp2[3];
            }
            if (serviceName.contains(".")) {
                serviceName = serviceName.substring(0, serviceName.indexOf(46));
            } else if (serviceName.contains("?")) {
                serviceName = serviceName.substring(0, serviceName.indexOf(63));
            }
        }
        serviceName = serviceName.replace("/", "");
        return serviceName;
    }

    public static String getAppNameFromRequest(Request request) {
        String appName = null;
        String hostName = request.getHost().getName();
        String appContext = ApplicationContext.getCurrentApplicationContext().getApplicationFromUrlMapping(hostName);
        if (request.getRequestURI().contains("/services/")) {
            return Utils.getServiceName(request.getRequestURI());
        }
        if (!request.getContext().getName().equals("/")) {
            return Utils.getWebappName(request.getRequestURI());
        }
        if (appContext != null) {
            appName = appContext.contains("services") ? Utils.getServiceName(appContext + request.getRequestURI()) : Utils.getWebappName(appContext + request.getRequestURI());
        }
        return appName;
    }

    public static String getWebappName(String uri) {
        String appName;
        if (uri.contains("/webapps/")) {
            String temp = uri.substring(uri.indexOf("/webapps/") + 9, uri.length());
            appName = temp.substring(0, temp.indexOf("/"));
        } else {
            String temp = uri.substring(1, uri.length());
            appName = temp.substring(0, temp.indexOf("/"));
        }
        return appName;
    }
}

