/*
 * Decompiled with CFR 0.152.
 */
package org.jaggeryjs.jaggery.app.mgt;

import java.io.File;
import java.io.IOException;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import org.apache.axis2.AxisFault;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.utils.ArchiveManipulator;
import org.wso2.carbon.webapp.mgt.SessionsWrapper;
import org.wso2.carbon.webapp.mgt.WebApplication;
import org.wso2.carbon.webapp.mgt.WebappAdmin;
import org.wso2.carbon.webapp.mgt.WebappMetadata;
import org.wso2.carbon.webapp.mgt.WebappUploadData;
import org.wso2.carbon.webapp.mgt.WebappsWrapper;

public class JaggeryAppAdmin
extends WebappAdmin {
    private static final int BYTE_BUFFER_SIZE = 8192;
    private static final Log log = LogFactory.getLog(JaggeryAppAdmin.class);

    public JaggeryAppAdmin() {
    }

    public JaggeryAppAdmin(AxisConfiguration axisConfig) throws Exception {
        super(axisConfig);
    }

    public WebappsWrapper getPagedWebappsSummary(String webappSearchString, String webappState, int pageNumber) throws AxisFault {
        return super.getPagedWebappsSummary(webappSearchString, webappState, pageNumber);
    }

    public WebappMetadata getStartedWebapp(String webappFileName) {
        return super.getStartedWebapp(webappFileName);
    }

    public WebappMetadata getStoppedWebapp(String webappFileName) {
        return super.getStoppedWebapp(webappFileName);
    }

    public WebappsWrapper getPagedFaultyWebappsSummary(String webappSearchString, int pageNumber) throws AxisFault {
        return super.getPagedFaultyWebappsSummary(webappSearchString, pageNumber);
    }

    public void deleteStartedWebapps(String[] webappFileNames) throws AxisFault {
        super.deleteStartedWebapps(webappFileNames);
    }

    public void deleteStoppedWebapps(String[] webappFileNames) throws AxisFault {
        super.deleteStoppedWebapps(webappFileNames);
    }

    public void deleteFaultyWebapps(String[] webappFileNames) throws AxisFault {
        super.deleteFaultyWebapps(webappFileNames);
    }

    public void deleteWebapp(String webappFileName) throws AxisFault {
        super.deleteWebapp(webappFileName);
    }

    public void deleteAllStartedWebapps() throws AxisFault {
        super.deleteAllStartedWebapps();
    }

    public void deleteAllStoppedWebapps() throws AxisFault {
        super.deleteAllStoppedWebapps();
    }

    public void deleteAllFaultyWebapps() throws AxisFault {
        super.deleteAllFaultyWebapps();
    }

    public void reloadAllWebapps() {
        super.reloadAllWebapps();
    }

    public void reloadWebapps(String[] webappFileNames) {
        super.reloadWebapps(webappFileNames);
    }

    public void stopAllWebapps() throws AxisFault {
        super.stopAllWebapps();
    }

    public void stopWebapps(String[] webappFileNames) throws AxisFault {
        super.stopWebapps(webappFileNames);
    }

    public void startAllWebapps() throws AxisFault {
        super.startAllWebapps();
    }

    public void startWebapps(String[] webappFileNames) throws AxisFault {
        super.startWebapps(webappFileNames);
    }

    public SessionsWrapper getActiveSessions(String webappFileName, int pageNumber) {
        return super.getActiveSessions(webappFileName, pageNumber);
    }

    public void expireSessionsInAllWebapps() {
        super.expireSessionsInAllWebapps();
    }

    public void expireSessionsInWebapps(String[] webappFileNames) {
        super.expireSessionsInWebapps(webappFileNames);
    }

    public void expireSessionsInWebapp(String webappFileName, long maxSessionLifetimeMillis) {
        super.expireSessionsInWebapp(webappFileName, maxSessionLifetimeMillis);
    }

    public void expireSessions(String webappFileName, String[] sessionIDs) throws AxisFault {
        super.expireSessions(webappFileName, sessionIDs);
    }

    public void expireAllSessions(String webappFileName) {
        super.expireAllSessions(webappFileName);
    }

    public boolean isUnpackWARs() {
        return super.isUnpackWARs();
    }

    protected boolean isWebappRelevant(WebApplication webapp) {
        String filterProp = (String)webapp.getProperty("webappFilter");
        return "jaggeryWebapp".equals(filterProp);
    }

    protected String getWebappDeploymentDirPath() {
        String directory = "jaggeryapps";
        if (System.getProperty("jaggery.home") != null) {
            directory = "apps";
        }
        return this.getAxisConfig().getRepository().getPath() + File.separator + directory;
    }

    public boolean uploadWebapp(WebappUploadData[] webappUploadDataList) throws AxisFault {
        AxisConfiguration axisConfig = this.getAxisConfig();
        String repoPath = axisConfig.getRepository().getPath();
        String jaggeryAppsPath = this.getWebappDeploymentDirPath();
        for (WebappUploadData uploadData : webappUploadDataList) {
            String fName = uploadData.getFileName();
            if (fName.contains(".")) {
                fName = fName.split("\\.")[0];
            }
            File webappsDir = new File(jaggeryAppsPath + File.separator + fName);
            File jaggeryAppsFile = new File(jaggeryAppsPath);
            if (webappsDir.exists()) {
                String msg = "Jaggery app with the same name already exists";
                log.error((Object)msg);
                throw new AxisFault(msg);
            }
            if (!jaggeryAppsFile.exists() && !jaggeryAppsFile.mkdir()) {
                String error = "Jaggery deployment directory not found and cannot be created when uploading";
                log.error((Object)error);
                throw new AxisFault(error);
            }
            ArchiveManipulator archiveManipulator = new ArchiveManipulator();
            try {
                archiveManipulator.extractFromStream(uploadData.getDataHandler().getInputStream(), jaggeryAppsPath + File.separator + fName);
            }
            catch (IOException e) {
                log.error((Object)"Could not unzip the Jaggery App Archive", (Throwable)e);
                throw new AxisFault(e.getMessage(), (Throwable)e);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataHandler downloadWarFileHandler(String fileName) {
        String repoPath = this.getAxisConfig().getRepository().getPath();
        String jaggeryAppsPath = this.getWebappDeploymentDirPath() + File.separator + fileName;
        File webAppFile = new File(jaggeryAppsPath);
        DataHandler handler = null;
        if (webAppFile.isDirectory()) {
            String zipTo = "tmp" + File.separator + fileName + ".zip";
            File fDownload = new File(zipTo);
            ArchiveManipulator archiveManipulator = new ArchiveManipulator();
            JaggeryAppAdmin jaggeryAppAdmin = this;
            synchronized (jaggeryAppAdmin) {
                try {
                    archiveManipulator.archiveDir(zipTo, webAppFile.getAbsolutePath());
                    FileDataSource datasource = new FileDataSource(fDownload);
                    handler = new DataHandler((DataSource)datasource);
                }
                catch (IOException e) {
                    log.error((Object)"Error downloading WAR file.", (Throwable)e);
                }
            }
        }
        FileDataSource datasource = new FileDataSource(new File(repoPath));
        handler = new DataHandler((DataSource)datasource);
        return handler;
    }
}

