/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ciphertool;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.Console;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.InvalidKeyException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.axiom.util.base64.Base64Utils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.wso2.ciphertool.CipherToolException;
import org.xml.sax.SAXException;

public class CipherTool {
    private static Log log = LogFactory.getLog(CipherTool.class);
    private static Map<String, String> aliasXpathMap = new HashMap<String, String>();
    private static Map<String, String> configFileXpathMap = new HashMap<String, String>();
    private static Map<String, String> aliasPasswordMap = new HashMap<String, String>();
    private static String carbonHome;
    private static Cipher cipher;

    public static void main(String[] args) {
        CipherTool.init(args);
        cipher = CipherTool.initCipher();
        if (System.getProperty("configure") != null && System.getProperty("configure").equals("true")) {
            CipherTool.loadXpathValuesAndPasswordDetails();
            CipherTool.writeSecureVaultConfigTokens();
            CipherTool.createEncryptedValues();
            CipherTool.writeEncryptedValues();
            CipherTool.writeConfigurations();
        } else if (System.getProperty("change") != null && System.getProperty("change").equals("true")) {
            CipherTool.changePassword();
        } else {
            CipherTool.createEncryptedValue();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void init(String[] args) {
        String osName = System.getProperty("os.name");
        File file = osName.toLowerCase().indexOf("win") == -1 ? new File("." + File.separator + ".." + File.separator) : new File("." + File.separator);
        try {
            System.setProperty("carbon.home", file.getCanonicalFile().toString());
        }
        catch (IOException e) {
            CipherTool.handleException("IOError while calculating CARBON_HOME directory location ", e);
        }
        for (String arg : args) {
            String property;
            if (arg.equals("-help")) {
                CipherTool.printHelp();
                System.exit(0);
                continue;
            }
            if (arg.equals("-Dchange")) {
                property = arg.substring(2);
                System.setProperty(property, "true");
                continue;
            }
            if (!arg.equals("-Dconfigure")) continue;
            property = arg.substring(2);
            System.setProperty(property, "true");
        }
        carbonHome = System.getProperty("carbon.home");
        if (carbonHome == null || carbonHome.equals("")) {
            System.out.println("\nCARBON_HOME is not properly set. Please Enter CARBON_HOME again : ");
            BufferedReader input = new BufferedReader(new InputStreamReader(System.in));
            try {
                carbonHome = input.readLine();
            }
            catch (IOException e) {
                CipherTool.handleException("IOError reading command line inputs  ", e);
            }
            finally {
                try {
                    input.close();
                }
                catch (IOException e) {
                    log.error((Object)"Error while closing input stream");
                }
            }
        }
    }

    private static void printHelp() {
        System.out.println("\n---------Cipher Tool Help---------\n");
        System.out.println("By default, CipherTool can be used for creating encrypted value for given plaint text\n");
        System.out.println("Options :\n");
        System.out.println("\t-Dconfigure\t\t This option would allow user to secure plain text passwords in carbon configuration files. CipherTool replace all the password listed in cipher-text.properties file with encrypted values and modify related password elements in the configuration files with secret alias names. Also secret-conf.properties file is modified with the default configuration data");
        System.out.println("\t-Dchange\t\t This option would allow user to change the specific password which has been secured\n");
    }

    private static Cipher initCipher() {
        String keyStoreFile = null;
        String keyType = null;
        String aliasName = null;
        String password = null;
        String provider = null;
        Cipher cipher = null;
        keyStoreFile = CipherTool.getPrimaryKeyStoreData("//Server/Security/KeyStore/Location");
        keyStoreFile = carbonHome + keyStoreFile.substring(keyStoreFile.indexOf(125) + 1);
        File keyStore = new File(keyStoreFile);
        if (!keyStore.exists()) {
            CipherTool.handleException("Primary Key Store Can not be found at Default location");
        }
        keyType = CipherTool.getPrimaryKeyStoreData("//Server/Security/KeyStore/Type");
        aliasName = CipherTool.getPrimaryKeyStoreData("//Server/Security/KeyStore/KeyAlias");
        password = CipherTool.carbonKeyPasswordReader();
        try {
            KeyStore primaryKeyStore = CipherTool.getKeyStore(keyStoreFile, password, keyType, provider);
            Certificate certs = primaryKeyStore.getCertificate(aliasName);
            cipher = Cipher.getInstance("RSA");
            cipher.init(1, certs);
        }
        catch (InvalidKeyException e) {
            CipherTool.handleException("Error initializing Cipher ", e);
        }
        catch (NoSuchAlgorithmException e) {
            CipherTool.handleException("Error initializing Cipher ", e);
        }
        catch (KeyStoreException e) {
            CipherTool.handleException("Error initializing Cipher ", e);
        }
        catch (NoSuchPaddingException e) {
            CipherTool.handleException("Error initializing Cipher ", e);
        }
        log.info((Object)"\nPrimary KeyStore of Carbon Server is initialized Successfully\n");
        return cipher;
    }

    private static String doEncryption(Cipher cipher, String plainTextPass) {
        String encodedValue = null;
        try {
            byte[] plainTextPassByte = plainTextPass.getBytes();
            byte[] encryptedPassword = cipher.doFinal(plainTextPassByte);
            encodedValue = Base64Utils.encode((byte[])encryptedPassword);
        }
        catch (BadPaddingException e) {
            CipherTool.handleException("Error encrypting password ", e);
        }
        catch (IllegalBlockSizeException e) {
            CipherTool.handleException("Error encrypting password ", e);
        }
        log.info((Object)"\nEncryption is done Successfully\n");
        return encodedValue;
    }

    private static void createEncryptedValue() {
        char[] password;
        log.info((Object)"By default, CipherTool can be used for creating encrypted value for given plain text. For more options visit help  ./ciphertool.sh -help or ./ciphertool.bat -help\n");
        String firstPassword = null;
        String secondPassword = null;
        Console console = System.console();
        if (console != null && (password = console.readPassword("[%s]", "Enter Plain text value :")) != null) {
            firstPassword = String.valueOf(password);
        }
        if ((console = System.console()) != null && (password = console.readPassword("[%s]", "Please Enter value Again :")) != null) {
            secondPassword = String.valueOf(password);
        }
        if (firstPassword != null && secondPassword != null && !firstPassword.equals("") && firstPassword.equals(secondPassword)) {
            String encryptedText = CipherTool.doEncryption(cipher, firstPassword);
            System.out.println("\nEncrypted value is : \n" + encryptedText + "\n");
        } else {
            CipherTool.handleException("Error : Password does not match");
        }
    }

    private static String getPrimaryKeyStoreData(String xpath) {
        String nodeValue = null;
        try {
            String carbonConfigFile = carbonHome + File.separator + "repository" + File.separator + "conf" + File.separator + "carbon.xml";
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
            Document doc = docBuilder.parse(carbonConfigFile);
            XPathFactory xpf = XPathFactory.newInstance();
            XPath xp = xpf.newXPath();
            XPathExpression xpathEx = xp.compile(xpath);
            Node text = (Node)xpathEx.evaluate(doc.getDocumentElement(), XPathConstants.NODE);
            if (text != null) {
                nodeValue = text.getTextContent();
            }
        }
        catch (ParserConfigurationException e) {
            CipherTool.handleException("Error reading primary key Store details from carbon.xml file ", e);
        }
        catch (SAXException e) {
            CipherTool.handleException("Error reading primary key Store details from carbon.xml file ", e);
        }
        catch (XPathExpressionException e) {
            CipherTool.handleException("Error reading primary key Store details from carbon.xml file ", e);
        }
        catch (IOException e) {
            CipherTool.handleException("IOError reading primary key Store details from carbon.xml file ", e);
        }
        return nodeValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static KeyStore getKeyStore(String location, String storePassword, String storeType, String provider) {
        File keyStoreFile = new File(location);
        if (!keyStoreFile.exists()) {
            CipherTool.handleException("KeyStore can not be found at ' " + keyStoreFile + " '");
        }
        if (storePassword == null) {
            CipherTool.handleException("KeyStore password can not be null");
        }
        if (storeType == null) {
            CipherTool.handleException("KeyStore Type can not be null");
        }
        BufferedInputStream bufferedInputStream = null;
        try {
            bufferedInputStream = new BufferedInputStream(new FileInputStream(keyStoreFile));
            KeyStore keyStore = provider != null ? KeyStore.getInstance(storeType, provider) : KeyStore.getInstance(storeType);
            keyStore.load(bufferedInputStream, storePassword.toCharArray());
            KeyStore keyStore2 = keyStore;
            return keyStore2;
        }
        catch (KeyStoreException e) {
            CipherTool.handleException("Error loading keyStore from ' " + location + " ' ", e);
        }
        catch (IOException e) {
            CipherTool.handleException("IOError loading keyStore from ' " + location + " ' ", e);
        }
        catch (NoSuchAlgorithmException e) {
            CipherTool.handleException("Error loading keyStore from ' " + location + " ' ", e);
        }
        catch (CertificateException e) {
            CipherTool.handleException("Error loading keyStore from ' " + location + " ' ", e);
        }
        catch (NoSuchProviderException e) {
            CipherTool.handleException("Error loading keyStore from ' " + location + " ' ", e);
        }
        finally {
            if (bufferedInputStream != null) {
                try {
                    bufferedInputStream.close();
                }
                catch (IOException ignored) {
                    log.error((Object)"Error while closing input stream");
                }
            }
        }
        return null;
    }

    private static void writeSecureVaultConfigTokens() {
        for (String key : configFileXpathMap.keySet()) {
            String XPath2;
            String unprocessedXpath = configFileXpathMap.get(key);
            boolean capitalLetter = false;
            String fileName = unprocessedXpath.substring(0, unprocessedXpath.indexOf("//"));
            if (unprocessedXpath.indexOf(",") > 0) {
                if (unprocessedXpath.substring(unprocessedXpath.indexOf(",") + 1).trim().equals("true")) {
                    capitalLetter = true;
                }
                XPath2 = unprocessedXpath.substring(unprocessedXpath.indexOf("//"), unprocessedXpath.indexOf(","));
            } else {
                XPath2 = unprocessedXpath.substring(unprocessedXpath.indexOf("//"));
            }
            CipherTool.writeTokenToConfigFile(fileName, XPath2, key, capitalLetter);
        }
    }

    private static void writeTokenToConfigFile(String fileName, String xPath, String secretAlias, boolean capitalLetter) {
        if (xPath != null && !xPath.equals("") && secretAlias != null && !secretAlias.equals("")) {
            try {
                XPathFactory xpf;
                XPath xp;
                XPathExpression xpathEx;
                Node securedNode;
                String filePath = carbonHome + File.separator + "repository" + File.separator + "conf" + File.separator + "security" + File.separator + fileName;
                File configFile = new File(filePath);
                if (!configFile.exists()) {
                    filePath = carbonHome + fileName;
                }
                if (!(configFile = new File(filePath)).exists()) {
                    return;
                }
                DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
                Document doc = docBuilder.parse(filePath);
                Element rootNode = doc.getDocumentElement();
                Attr secretNamespaceNode = doc.createAttribute("xmlns:svns");
                secretNamespaceNode.setTextContent("http://org.wso2.securevault/configuration");
                rootNode.getAttributes().setNamedItem(secretNamespaceNode);
                Attr secretProviderNode = doc.createAttribute("provider");
                secretProviderNode.setTextContent("org.wso2.securevault.secret.handler.SecretManagerSecretCallbackHandler");
                Element secretVaultNode = capitalLetter ? doc.createElement("svns:SecureVault") : doc.createElement("svns:secureVault");
                secretVaultNode.getAttributes().setNamedItem(secretProviderNode);
                if (!CipherTool.isSecureVaultNodeExist(rootNode, capitalLetter)) {
                    rootNode.appendChild(secretVaultNode);
                }
                if ((securedNode = (Node)(xpathEx = (xp = (xpf = XPathFactory.newInstance()).newXPath()).compile(xPath)).evaluate(doc.getDocumentElement(), XPathConstants.NODE)) != null) {
                    Attr secretAliasNode = doc.createAttribute("svns:secretAlias");
                    secretAliasNode.setTextContent(secretAlias);
                    securedNode.setTextContent("password");
                    securedNode.getAttributes().setNamedItem(secretAliasNode);
                } else {
                    CipherTool.handleException("Element for secret alias '" + secretAlias + "' can not be found in " + fileName + " file or You have entered invalid Xpath value");
                }
                TransformerFactory transformerFactory = TransformerFactory.newInstance();
                Transformer transformer = transformerFactory.newTransformer();
                DOMSource source = new DOMSource(doc);
                StreamResult result = new StreamResult(new File(filePath));
                transformer.transform(source, result);
            }
            catch (ParserConfigurationException e) {
                CipherTool.handleException("Error writing protected token to " + fileName + " file ", e);
            }
            catch (TransformerException e) {
                CipherTool.handleException("Error writing protected token to " + fileName + " file ", e);
            }
            catch (SAXException e) {
                CipherTool.handleException("Error writing protected token to " + fileName + " file ", e);
            }
            catch (IOException e) {
                CipherTool.handleException("IOError writing protected token to " + fileName + " file ", e);
            }
            catch (XPathExpressionException e) {
                CipherTool.handleException("IOError writing protected token to " + fileName + " file ", e);
            }
            log.info((Object)("Protected Token is updated in " + fileName + " successfully\n"));
        }
    }

    private static String passwordReader(String key) {
        char[] password;
        String firstPassword = null;
        String secondPassword = null;
        Console console = System.console();
        if (console != null && (password = console.readPassword("[%s]", "Enter Password of Secret Alias - '" + key + "' :")) != null) {
            firstPassword = String.valueOf(password);
        }
        if ((console = System.console()) != null && (password = console.readPassword("[%s]", "Please Enter Password Again :")) != null) {
            secondPassword = String.valueOf(password);
        }
        if (firstPassword != null && secondPassword != null && !firstPassword.equals("") && firstPassword.equals(secondPassword)) {
            return firstPassword;
        }
        return null;
    }

    protected static String carbonKeyPasswordReader() {
        char[] password;
        Console console = System.console();
        if (console != null && (password = console.readPassword("[%s]", "Please Enter Primary KeyStore Password of Carbon Server : ")) != null) {
            return String.valueOf(password);
        }
        return null;
    }

    private static boolean isSecureVaultNodeExist(Node firstNode, boolean capitalLetter) {
        for (int i = 0; i < firstNode.getChildNodes().getLength(); ++i) {
            if (!(capitalLetter ? firstNode.getChildNodes().item(i).getNodeName().equals("svns:SecureVault") : firstNode.getChildNodes().item(i).getNodeName().equals("svns:secureVault"))) continue;
            return true;
        }
        return false;
    }

    private static void createEncryptedValues() {
        for (String key : aliasPasswordMap.keySet()) {
            String value = aliasPasswordMap.get(key);
            if (value != null && !value.equals("")) {
                if (value.indexOf("[") < 0 || value.indexOf("]") <= 0) continue;
                value = value.substring(value.indexOf("[") + 1, value.indexOf("]"));
                aliasPasswordMap.put(key, CipherTool.doEncryption(cipher, value));
                continue;
            }
            value = CipherTool.passwordReader(key);
            if (value != null) {
                aliasPasswordMap.put(key, CipherTool.doEncryption(cipher, value));
                continue;
            }
            CipherTool.handleException("Error : Password does not match");
        }
    }

    private static void writeEncryptedValues() {
        Properties properties = new Properties();
        for (String key : aliasPasswordMap.keySet()) {
            properties.setProperty(key, aliasPasswordMap.get(key));
        }
        CipherTool.writeProperties(properties, "cipher-text.properties");
    }

    private static void writeConfigurations() {
        Properties properties = new Properties();
        String keyStoreFile = CipherTool.getPrimaryKeyStoreData("//Server/Security/KeyStore/Location");
        keyStoreFile = carbonHome + keyStoreFile.substring(keyStoreFile.indexOf(125) + 1);
        String keyType = CipherTool.getPrimaryKeyStoreData("//Server/Security/KeyStore/Type");
        String aliasName = CipherTool.getPrimaryKeyStoreData("//Server/Security/KeyStore/KeyAlias");
        properties.setProperty("secretRepositories", "file");
        properties.setProperty("secretRepositories.file.provider", "org.wso2.securevault.secret.repository.FileBaseSecretRepositoryProvider");
        properties.setProperty("secretRepositories.file.location", "repository" + File.separator + "conf" + File.separator + "security" + File.separator + "cipher-text.properties");
        properties.setProperty("keystore.identity.location", keyStoreFile);
        properties.setProperty("keystore.identity.type", keyType);
        properties.setProperty("keystore.identity.alias", aliasName);
        properties.setProperty("keystore.identity.store.password", "identity.store.password");
        properties.setProperty("keystore.identity.store.secretProvider", "org.wso2.carbon.securevault.DefaultSecretCallbackHandler");
        properties.setProperty("keystore.identity.key.password", "identity.key.password");
        properties.setProperty("keystore.identity.key.secretProvider", "org.wso2.carbon.securevault.DefaultSecretCallbackHandler");
        CipherTool.writeProperties(properties, "secret-conf.properties");
        log.info((Object)"Secret Configurations are written to the property file successfully");
    }

    private static void loadXpathValuesAndPasswordDetails() {
        aliasXpathMap.put("transports.https.keystorePass", "mgt-transports.xml//transports/transport[@name='https']/parameter[@name='keystorePass'],false");
        aliasXpathMap.put("Carbon.Security.KeyStore.KeyPassword", "carbon.xml//Server/Security/KeyStore/KeyPassword,true");
        aliasXpathMap.put("Carbon.Security.KeyStore.Password", "carbon.xml//Server/Security/KeyStore/Password,true");
        aliasXpathMap.put("Carbon.Security.TrustStore.Password", "carbon.xml//Server/Security/TrustStore/Password,true");
        aliasXpathMap.put("Axis2.Https.Listener.KeyStore.KeyPassword", "axis2.xml//axisconfig/transportReceiver[@name='https']/parameter[@name='keystore']/KeyStore/KeyPassword,false");
        aliasXpathMap.put("Axis2.Https.Listener.TrustStore.Password", "axis2.xml//axisconfig/transportReceiver[@name='https']/parameter[@name='truststore']/TrustStore/Password,false");
        aliasXpathMap.put("Axis2.Https.Listener.KeyStore.Password", "axis2.xml//axisconfig/transportReceiver[@name='https']/parameter[@name='keystore']/KeyStore/Password,false");
        aliasXpathMap.put("Axis2.Https.Sender.KeyStore.KeyPassword", "axis2.xml//axisconfig/transportSender[@name='https']/parameter[@name='keystore']/KeyStore/KeyPassword,false");
        aliasXpathMap.put("Axis2.Https.Sender.KeyStore.Password", "axis2.xml//axisconfig/transportSender[@name='https']/parameter[@name='keystore']/KeyStore/Password,false");
        aliasXpathMap.put("Axis2.Https.Sender.TrustStore.Password", "axis2.xml//axisconfig/transportSender[@name='https']/parameter[@name='truststore']/TrustStore/Password,false");
        aliasXpathMap.put("UserManager.Configuration.Property.password", "user-mgt.xml//UserManager/Realm/Configuration/Property[@name='password'],true");
        aliasXpathMap.put("UserStoreManager.Property.ConnectionPassword", "user-mgt.xml//UserManager/Realm/UserStoreManager/Property[@name='ConnectionPassword'],true");
        aliasXpathMap.put("UserManager.AdminUser.Password", "user-mgt.xml//UserManager/Realm/Configuration/AdminUser/Password,true");
        aliasXpathMap.put("Axis2.Mailto.Parameter.Password", "axis2.xml//axisconfig/transportSender[@name='mailto']/parameter[@name='mail.smtp.password'],false");
        Properties cipherToolProperties = CipherTool.loadProperties("cipher-tool.properties");
        for (Object key : cipherToolProperties.keySet()) {
            String passwordAlias = (String)key;
            aliasXpathMap.put(passwordAlias, cipherToolProperties.getProperty(passwordAlias));
        }
        Properties cipherTextProperties = CipherTool.loadProperties("cipher-text.properties");
        for (Object key : cipherTextProperties.keySet()) {
            String passwordAlias = (String)key;
            if (aliasXpathMap.containsKey(passwordAlias)) {
                String unprocessedXpath = aliasXpathMap.get(passwordAlias);
                configFileXpathMap.put(passwordAlias, unprocessedXpath);
                aliasPasswordMap.put(passwordAlias, cipherTextProperties.getProperty(passwordAlias));
                continue;
            }
            if (passwordAlias.startsWith("wso2registry")) {
                String dbConfigName = passwordAlias.substring(passwordAlias.indexOf(".") + 1);
                dbConfigName = dbConfigName.substring(0, dbConfigName.indexOf("."));
                String registryXpath = "//wso2registry/dbConfig[@name='" + dbConfigName + "']/password";
                configFileXpathMap.put(passwordAlias, "registry.xml" + registryXpath);
                aliasPasswordMap.put(passwordAlias, cipherTextProperties.getProperty(passwordAlias));
                continue;
            }
            System.out.println("XPath value for secret alias '" + passwordAlias + "' can not be found " + "Please enter XPath manually : ");
            String buffer1 = null;
            String buffer2 = null;
            BufferedReader input1 = new BufferedReader(new InputStreamReader(System.in));
            try {
                buffer1 = input1.readLine();
            }
            catch (IOException e) {
                CipherTool.handleException("IOError reading command line inputs  ", e);
            }
            System.out.println("Please enter configuration file : ");
            BufferedReader input2 = new BufferedReader(new InputStreamReader(System.in));
            try {
                buffer2 = input2.readLine();
            }
            catch (IOException e) {
                CipherTool.handleException("IOError reading command line inputs  ", e);
            }
            if (buffer1 == null || buffer1.trim().equals("") || buffer2 == null || buffer2.trim().equals("")) continue;
            configFileXpathMap.put(passwordAlias, buffer1.trim() + buffer2.trim());
            aliasPasswordMap.put(passwordAlias, cipherTextProperties.getProperty(passwordAlias));
        }
    }

    private static void changePassword() {
        Properties cipherTextProperties = CipherTool.loadProperties("cipher-text.properties");
        ArrayList<String> keyValueList = new ArrayList<String>();
        int i = 1;
        for (Object key : cipherTextProperties.keySet()) {
            String passwordAlias = (String)key;
            aliasPasswordMap.put(passwordAlias, cipherTextProperties.getProperty(passwordAlias));
            keyValueList.add(passwordAlias);
            System.out.println("[" + i + "] " + passwordAlias);
            ++i;
        }
        while (true) {
            System.out.println("\nPlease enter the Number which is corresponding to the Password that is needed be changed [Press Enter to Skip] :");
            String buffer = null;
            BufferedReader input = new BufferedReader(new InputStreamReader(System.in));
            try {
                buffer = input.readLine();
            }
            catch (IOException e) {
                CipherTool.handleException("IOError reading command line inputs  ", e);
            }
            if (buffer == null || buffer.trim().equals("")) break;
            String selectedPasswordAlias = (String)keyValueList.get(Integer.parseInt(buffer.trim()) - 1);
            String value = CipherTool.passwordReader(selectedPasswordAlias);
            if (value != null) {
                aliasPasswordMap.put(selectedPasswordAlias, CipherTool.doEncryption(cipher, value));
                continue;
            }
            CipherTool.handleException("Error : Password does not match");
        }
        CipherTool.writeEncryptedValues();
        System.exit(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties loadProperties(String fileName) {
        Properties properties = new Properties();
        String filePath = carbonHome + File.separator + "repository" + File.separator + "conf" + File.separator + "security" + File.separator + fileName;
        File dataSourceFile = new File(filePath);
        if (!dataSourceFile.exists()) {
            return properties;
        }
        FileInputStream in = null;
        try {
            in = new FileInputStream(dataSourceFile);
            properties.load(in);
        }
        catch (IOException e) {
            String msg = "Error loading properties from a file at :" + filePath;
            log.warn((Object)msg, (Throwable)e);
            Properties properties2 = properties;
            return properties2;
        }
        finally {
            if (in != null) {
                try {
                    ((InputStream)in).close();
                }
                catch (IOException ignored) {
                    log.error((Object)"Error while closing input stream");
                }
            }
        }
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeProperties(Properties properties, String fileName) {
        String filePath = carbonHome + File.separator + "repository" + File.separator + "conf" + File.separator + "security" + File.separator + fileName;
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(filePath);
            properties.store(fileOutputStream, null);
        }
        catch (IOException e) {
            String msg = "Error loading properties from a file at :" + filePath;
            log.warn((Object)msg, (Throwable)e);
        }
        finally {
            try {
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
            }
            catch (IOException e) {
                log.error((Object)"Error while closing output stream");
            }
        }
    }

    protected static void handleException(String msg, Exception e) {
        log.error((Object)msg, (Throwable)e);
        throw new CipherToolException(msg, e);
    }

    protected static void handleException(String msg) {
        log.error((Object)msg);
        throw new CipherToolException(msg);
    }
}

