/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.user.core.common;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Map;
import javax.sql.DataSource;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;
import org.wso2.carbon.caching.core.realm.RealmCache;
import org.wso2.carbon.user.api.RealmConfiguration;
import org.wso2.carbon.user.api.TenantMgtConfiguration;
import org.wso2.carbon.user.core.UserRealm;
import org.wso2.carbon.user.core.UserStoreException;
import org.wso2.carbon.user.core.claim.builder.ClaimBuilder;
import org.wso2.carbon.user.core.config.RealmConfigXMLProcessor;
import org.wso2.carbon.user.core.config.TenantMgtXMLProcessor;
import org.wso2.carbon.user.core.config.multitenancy.MultiTenantRealmConfigBuilder;
import org.wso2.carbon.user.core.ldap.LDAPConnectionContext;
import org.wso2.carbon.user.core.profile.builder.ProfileConfigurationBuilder;
import org.wso2.carbon.user.core.service.RealmService;
import org.wso2.carbon.user.core.tenant.TenantManager;
import org.wso2.carbon.user.core.util.DatabaseUtil;
import org.wso2.carbon.utils.CarbonUtils;
import org.wso2.carbon.utils.dbcreator.DatabaseCreator;

public class DefaultRealmService
implements RealmService {
    private RealmCache realmCache = RealmCache.getInstance();
    private BundleContext bc;
    private RealmConfiguration bootstrapRealmConfig;
    private TenantMgtConfiguration tenantMgtConfiguration;
    private DataSource dataSource;
    private LDAPConnectionContext ldapConnectionSource = null;
    private OMElement parentElement;
    private TenantManager tenantManager;
    private UserRealm bootstrapRealm;
    private MultiTenantRealmConfigBuilder multiTenantBuilder = null;
    private static final String TENANT_MGT_XML = "tenant-mgt.xml";
    private static final Log log = LogFactory.getLog(DefaultRealmService.class);
    private static final String PRIMARY_TENANT_REALM = "primary";
    private static final String DB_CHECK_SQL = "select * from UM_USER";
    private static boolean isFirstInitialization = true;
    private Map<String, Object> properties = new Hashtable<String, Object>();

    public DefaultRealmService(BundleContext bc, RealmConfiguration realmConfig) throws Exception {
        this.bootstrapRealmConfig = realmConfig != null ? realmConfig : this.buildBootStrapRealmConfig();
        this.tenantMgtConfiguration = this.buildTenantMgtConfig(bc);
        this.dataSource = DatabaseUtil.getRealmDataSource(this.bootstrapRealmConfig);
        this.initializeDatabase(this.dataSource);
        this.properties.put("um.datasource", this.dataSource);
        this.properties.put("FistStartupCheck", isFirstInitialization);
        if (this.bootstrapRealmConfig.getUserStoreProperty("ConnectionURL") != null) {
            this.ldapConnectionSource = new LDAPConnectionContext(this.bootstrapRealmConfig);
            this.properties.put("ldapConnectionSource", this.ldapConnectionSource);
        }
        this.tenantManager = this.initializeTenantManger(this.tenantMgtConfiguration);
        this.tenantManager.setBundleContext(bc);
        this.tenantManager.initializeExistingPartitions();
        this.bc = bc;
        this.bootstrapRealm = this.initializeRealm(this.bootstrapRealmConfig, -1234);
        Hashtable<String, String> dictionary = new Hashtable<String, String>();
        ((Dictionary)dictionary).put("RealmGenre", "Delegating");
        if (bc != null) {
            bc.registerService(UserRealm.class.getName(), (Object)this.bootstrapRealm, dictionary);
        }
    }

    public DefaultRealmService(BundleContext bc) throws Exception {
        this(bc, null);
    }

    public DefaultRealmService(RealmConfiguration realmConfig, TenantManager tenantManager) throws Exception {
        this.bootstrapRealmConfig = realmConfig;
        this.dataSource = DatabaseUtil.getRealmDataSource(this.bootstrapRealmConfig);
        this.properties.put("um.datasource", this.dataSource);
        if (this.bootstrapRealmConfig.getUserStoreProperty("ConnectionURL") != null) {
            this.ldapConnectionSource = new LDAPConnectionContext(this.bootstrapRealmConfig);
            this.properties.put("ldapConnectionSource", this.ldapConnectionSource);
        }
        this.tenantManager = tenantManager;
        this.bootstrapRealm = this.initializeRealm(this.bootstrapRealmConfig, -1234);
    }

    private RealmConfiguration buildBootStrapRealmConfig() throws UserStoreException {
        this.parentElement = this.getConfigurationElement();
        OMElement realmElement = this.parentElement.getFirstChildWithName(new QName("Realm"));
        RealmConfigXMLProcessor rmProcessor = new RealmConfigXMLProcessor();
        rmProcessor.setSecretResolver(this.parentElement);
        return rmProcessor.buildRealmConfiguration(realmElement);
    }

    private TenantMgtConfiguration buildTenantMgtConfig(BundleContext bc) throws UserStoreException {
        TenantMgtXMLProcessor tenantMgtXMLProcessor = new TenantMgtXMLProcessor();
        tenantMgtXMLProcessor.setBundleContext(bc);
        return tenantMgtXMLProcessor.buildTenantMgtConfigFromFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public org.wso2.carbon.user.api.UserRealm getTenantUserRealm(int tenantId) throws org.wso2.carbon.user.api.UserStoreException {
        UserRealm userRealm;
        block8: {
            if (tenantId == -1234) {
                return this.bootstrapRealm;
            }
            userRealm = this.getCachedUserRealm(tenantId);
            if (userRealm != null) {
                return userRealm;
            }
            try {
                if (this.tenantManager.getTenant(tenantId) == null) break block8;
                RealmConfiguration tenantRealmConfig = this.tenantManager.getTenant(tenantId).getRealmConfig();
                MultiTenantRealmConfigBuilder realmConfigBuilder = this.getMultiTenantRealmConfigBuilder();
                if (realmConfigBuilder != null) {
                    tenantRealmConfig = realmConfigBuilder.getRealmConfigForTenantToCreateRealm(this.bootstrapRealmConfig, tenantRealmConfig, tenantId);
                }
                userRealm = this.initializeRealm(tenantRealmConfig, tenantId);
                DefaultRealmService defaultRealmService = this;
                synchronized (defaultRealmService) {
                    this.realmCache.addToCache(tenantId, PRIMARY_TENANT_REALM, (org.wso2.carbon.user.api.UserRealm)userRealm);
                }
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                throw new org.wso2.carbon.user.api.UserStoreException(e.getMessage(), (Throwable)e);
            }
        }
        return userRealm;
    }

    @Override
    public UserRealm getCachedUserRealm(int tenantId) throws UserStoreException {
        return (UserRealm)this.realmCache.getUserRealm(tenantId, PRIMARY_TENANT_REALM);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UserRealm getUserRealm(RealmConfiguration tenantRealmConfig) throws UserStoreException {
        UserRealm userRealm = null;
        int tenantId = tenantRealmConfig.getTenantId();
        if (tenantId == -1234) {
            return this.bootstrapRealm;
        }
        userRealm = (UserRealm)this.realmCache.getUserRealm(tenantId, PRIMARY_TENANT_REALM);
        if (userRealm == null) {
            MultiTenantRealmConfigBuilder realmConfigBuilder = this.getMultiTenantRealmConfigBuilder();
            if (realmConfigBuilder != null) {
                tenantRealmConfig = realmConfigBuilder.getRealmConfigForTenantToCreateRealm(this.bootstrapRealmConfig, tenantRealmConfig, tenantId);
            }
            DefaultRealmService defaultRealmService = this;
            synchronized (defaultRealmService) {
                userRealm = this.initializeRealm(tenantRealmConfig, tenantId);
                this.realmCache.addToCache(tenantId, PRIMARY_TENANT_REALM, (org.wso2.carbon.user.api.UserRealm)userRealm);
            }
        }
        return userRealm;
    }

    public UserRealm initializeRealm(RealmConfiguration realmConfig, int tenantId) throws UserStoreException {
        ClaimBuilder.setBundleContext(this.bc);
        ProfileConfigurationBuilder.setBundleContext(this.bc);
        UserRealm userRealm = null;
        try {
            Class<?> clazz = Class.forName(realmConfig.getRealmClassName());
            userRealm = (UserRealm)clazz.newInstance();
            userRealm.init(realmConfig, this.properties, tenantId);
        }
        catch (Exception e) {
            String msg = "Cannot initialize the realm.";
            log.error((Object)msg, (Throwable)e);
            throw new UserStoreException(msg, e);
        }
        return userRealm;
    }

    private OMElement getConfigurationElement() throws UserStoreException {
        try {
            String userMgt = CarbonUtils.getUserMgtXMLPath();
            InputStream inStream = null;
            if (userMgt != null) {
                File userMgtXml = new File(userMgt);
                if (!userMgtXml.exists()) {
                    String msg = "Instance of a WSO2 User Manager has not been created. user-mgt.xml is not found.";
                    throw new FileNotFoundException(msg);
                }
                inStream = new FileInputStream(userMgtXml);
            } else {
                inStream = this.getClass().getClassLoader().getResourceAsStream("repository/conf/user-mgt.xml");
                if (inStream == null) {
                    String msg = "Instance of a WSO2 User Manager has not been created. user-mgt.xml is not found. Please set the carbon.home";
                    throw new FileNotFoundException(msg);
                }
            }
            StAXOMBuilder builder = new StAXOMBuilder(inStream);
            return builder.getDocumentElement();
        }
        catch (FileNotFoundException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new UserStoreException(e.getMessage(), e);
        }
        catch (XMLStreamException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new UserStoreException(e.getMessage(), e);
        }
    }

    private void initializeDatabase(DataSource ds) throws Exception {
        String value = System.getProperty("setup");
        if (value != null) {
            DatabaseCreator databaseCreator = new DatabaseCreator(ds);
            try {
                if (!databaseCreator.isDatabaseStructureCreated(DB_CHECK_SQL)) {
                    databaseCreator.createRegistryDatabase();
                } else {
                    isFirstInitialization = false;
                    log.info((Object)"Database already exists. Not creating a new database.");
                }
            }
            catch (Exception e) {
                String msg = "Error in creating the database";
                throw new Exception(msg, e);
            }
        }
    }

    private TenantManager initializeTenantManger(TenantMgtConfiguration tenantMgtConfiguration) throws Exception {
        TenantManager tenantManager = null;
        String className = tenantMgtConfiguration.getTenantManagerClass();
        Class<?> clazz = Class.forName(className);
        Constructor<?> constructor = clazz.getConstructor(OMElement.class, Map.class);
        this.properties.put("tenantMgtConfiguration", tenantMgtConfiguration);
        this.properties.put("userMgtConfiguration", this.bootstrapRealmConfig);
        Object newObject = constructor.newInstance(null, this.properties);
        tenantManager = (TenantManager)newObject;
        return tenantManager;
    }

    @Override
    public RealmConfiguration getBootstrapRealmConfiguration() {
        return this.bootstrapRealmConfig;
    }

    @Override
    public UserRealm getBootstrapRealm() throws UserStoreException {
        return this.bootstrapRealm;
    }

    public void setTenantManager(org.wso2.carbon.user.api.TenantManager tenantManager) throws org.wso2.carbon.user.api.UserStoreException {
        this.setTenantManager((TenantManager)tenantManager);
    }

    @Override
    public TenantManager getTenantManager() {
        return this.tenantManager;
    }

    @Override
    public void setTenantManager(TenantManager tenantManager) {
        this.tenantManager = tenantManager;
    }

    public TenantMgtConfiguration getTenantMgtConfiguration() {
        return this.tenantMgtConfiguration;
    }

    @Override
    public MultiTenantRealmConfigBuilder getMultiTenantRealmConfigBuilder() throws UserStoreException {
        try {
            if (this.multiTenantBuilder == null) {
                String clazzName = this.bootstrapRealmConfig.getRealmProperty("MultiTenantRealmConfigBuilder");
                if (clazzName != null) {
                    Class<?> clazz = Class.forName(clazzName);
                    MultiTenantRealmConfigBuilder multiConfigBuilder = (MultiTenantRealmConfigBuilder)clazz.newInstance();
                    return multiConfigBuilder;
                }
                return null;
            }
            return this.multiTenantBuilder;
        }
        catch (ClassNotFoundException e) {
            this.errorEncountered(e);
        }
        catch (InstantiationException e) {
            this.errorEncountered(e);
        }
        catch (IllegalAccessException e) {
            this.errorEncountered(e);
        }
        return null;
    }

    private void errorEncountered(Exception e) throws UserStoreException {
        String msg = "Exception while creating multi tenant builder " + e.getMessage();
        log.error((Object)msg, (Throwable)e);
        throw new UserStoreException(msg, e);
    }

    private OMElement getTenantConfigurationElement(BundleContext bundleContext) throws Exception {
        InputStream inStream = null;
        File claimConfigXml = new File(CarbonUtils.getCarbonConfigDirPath(), TENANT_MGT_XML);
        if (claimConfigXml.exists()) {
            inStream = new FileInputStream(claimConfigXml);
        }
        String warningMessage = "";
        if (inStream == null) {
            URL url;
            if (bundleContext != null) {
                url = bundleContext.getBundle().getResource(TENANT_MGT_XML);
                if (url != null) {
                    inStream = url.openStream();
                } else {
                    warningMessage = "Bundle context could not find resource tenant-mgt.xml or user does not have sufficient permission to access the resource.";
                }
            } else {
                url = this.getClass().getClassLoader().getResource(TENANT_MGT_XML);
                if (url != null) {
                    inStream = url.openStream();
                } else {
                    warningMessage = "ClaimBuilder could not find resource tenant-mgt.xml or user does not have sufficient permission to access the resource.";
                }
            }
        }
        if (inStream == null) {
            String message = "Tenant configuration not found. Cause - " + warningMessage;
            if (log.isDebugEnabled()) {
                log.debug((Object)message);
            }
            throw new FileNotFoundException(message);
        }
        StAXOMBuilder builder = new StAXOMBuilder(inStream);
        OMElement documentElement = builder.getDocumentElement();
        return documentElement;
    }
}

