/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.caching.infinispan;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.sf.jsr107cache.Cache;
import net.sf.jsr107cache.CacheEntry;
import net.sf.jsr107cache.CacheException;
import net.sf.jsr107cache.CacheFactory;
import net.sf.jsr107cache.CacheListener;
import net.sf.jsr107cache.CacheManager;
import net.sf.jsr107cache.CacheStatistics;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.infinispan.AdvancedCache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.interceptors.CacheMgmtInterceptor;
import org.infinispan.interceptors.base.CommandInterceptor;
import org.infinispan.lifecycle.ComponentStatus;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.stats.Stats;
import org.wso2.carbon.base.CarbonBaseUtils;
import org.wso2.carbon.caching.core.CacheConfiguration;
import org.wso2.carbon.caching.core.CarbonCacheManager;

public class InfinispanCacheManager
extends CacheManager
implements CarbonCacheManager {
    private EmbeddedCacheManager cacheManager;
    private static final long DEFAULT_EXPIRATION = 900000L;
    private static final long DEFAULT_EXPIRATION_L1 = 600000L;
    private static final String DEFAULT_CLUSTER_NAME = "wso2carbon-cache";
    private ConfigurationBuilder configBuilder = null;
    private final Map<String, Cache> caches = Collections.synchronizedMap(new HashMap());
    private static final Log log = LogFactory.getLog(InfinispanCacheManager.class);

    @Override
    public void initialize(String carbonHome) {
        CarbonBaseUtils.checkSecurity();
        log.debug((Object)"Starting Cache Manager initialization");
        String clusterName = DEFAULT_CLUSTER_NAME;
        CacheMode cacheMode = CacheMode.LOCAL;
        boolean isSync = true;
        long maxExpirationMillis = 900000L;
        long maxIdleExpirationMillis = 900000L;
        long l1LifeSpan = 900000L;
        boolean l1Enabled = true;
        String configurationFile = null;
        boolean isClusteringEnabled = false;
        CacheConfiguration cacheConfiguration = CacheConfiguration.getInstance();
        String cacheModeString = cacheConfiguration.getProperty("configuration.cacheMode") == null ? "local" : cacheConfiguration.getProperty("configuration.cacheMode");
        maxExpirationMillis = cacheConfiguration.getProperty("configuration.maxExpirationMillis") == null ? 900000L : Long.parseLong(cacheConfiguration.getProperty("configuration.maxExpirationMillis"));
        long l = maxIdleExpirationMillis = cacheConfiguration.getProperty("configuration.maxIdleExpirationMillis") == null ? 900000L : Long.parseLong(cacheConfiguration.getProperty("configuration.maxIdleExpirationMillis"));
        if (cacheConfiguration.getProperty("configuration.file") != null) {
            String path = cacheConfiguration.getProperty("configuration.file");
            try {
                this.cacheManager = new DefaultCacheManager(path);
                Configuration dcc = this.cacheManager.getDefaultCacheConfiguration();
                this.configBuilder = new ConfigurationBuilder().read(dcc);
            }
            catch (IOException e) {
                log.error((Object)("Infinispan configuration file cannot be read " + e.getMessage()), (Throwable)e);
            }
        } else if (!cacheModeString.equals("local")) {
            isClusteringEnabled = true;
            isSync = cacheConfiguration.getProperty("configuration.sync") == null ? true : Boolean.parseBoolean(cacheConfiguration.getProperty("configuration.sync"));
            l1Enabled = cacheConfiguration.getProperty("configuration.l1.enabled") == null ? true : Boolean.parseBoolean(cacheConfiguration.getProperty("configuration.l1.enabled"));
            l1LifeSpan = cacheConfiguration.getProperty("configuration.l1.lifespan") == null ? 600000L : Long.parseLong(cacheConfiguration.getProperty("configuration.l1.lifespan"));
            clusterName = cacheConfiguration.getProperty("configuration.clusterName") == null ? DEFAULT_CLUSTER_NAME : cacheConfiguration.getProperty("configuration.clusterName");
            configurationFile = cacheConfiguration.getProperty("configuration.jgroupConfigFile");
            if ("replicated".equals(cacheModeString)) {
                cacheMode = isSync ? CacheMode.REPL_SYNC : CacheMode.REPL_ASYNC;
            } else if ("distributed".equals(cacheModeString)) {
                cacheMode = isSync ? CacheMode.DIST_SYNC : CacheMode.DIST_ASYNC;
            } else if ("invalidation".equals(cacheModeString)) {
                cacheMode = isSync ? CacheMode.INVALIDATION_SYNC : CacheMode.INVALIDATION_ASYNC;
            } else {
                log.error((Object)"Invalid cache mode provided. The available values are local, replicated, distributed and invalidation");
            }
            GlobalConfigurationBuilder builder = new GlobalConfigurationBuilder();
            builder = builder.clusteredDefault();
            if (configurationFile == null) {
                builder.transport().clusterName(clusterName);
            } else {
                builder.transport().clusterName(clusterName).addProperty("configurationFile", configurationFile);
            }
            this.cacheManager = new DefaultCacheManager(builder.build());
            Configuration dcc = this.cacheManager.getDefaultCacheConfiguration();
            this.configBuilder = new ConfigurationBuilder().read(dcc);
            this.configBuilder.clustering().cacheMode(cacheMode);
            if (isSync) {
                this.configBuilder.clustering().sync();
            }
            if (l1Enabled) {
                this.configBuilder.clustering().l1().lifespan(l1LifeSpan);
            }
        } else {
            GlobalConfigurationBuilder builder = new GlobalConfigurationBuilder();
            this.cacheManager = new DefaultCacheManager(builder.nonClusteredDefault().build());
            Configuration dcc = this.cacheManager.getDefaultCacheConfiguration();
            this.configBuilder = new ConfigurationBuilder().read(dcc);
            this.configBuilder.expiration().lifespan(maxExpirationMillis);
            this.configBuilder.expiration().maxIdle(maxIdleExpirationMillis);
        }
        log.debug((Object)"Successfully Initialized Infinispan Cache Manager");
    }

    @Override
    public String getDefaultCacheName() {
        return "___defaultcache";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Cache getCache(String cacheName) {
        Cache cache = null;
        if (cacheName == null || cacheName.equals("___defaultcache")) {
            org.infinispan.Cache infinispanCache = this.cacheManager.getCache("___defaultcache");
            cache = new InfinispanJCacheWrapper(infinispanCache);
            return cache;
        }
        cache = this.caches.get(cacheName);
        if (cache == null) {
            ClassLoader tccl = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(InfinispanCacheManager.class.getClassLoader());
                this.cacheManager.defineConfiguration(cacheName, this.configBuilder.build());
                org.infinispan.Cache infinispanCache = this.cacheManager.getCache(cacheName);
                cache = new InfinispanJCacheWrapper(infinispanCache);
                this.registerCache(cacheName, cache);
            }
            finally {
                Thread.currentThread().setContextClassLoader(tccl);
            }
        }
        return cache;
    }

    @Override
    public void registerCache(String cacheName, Cache cache) {
        if (cache == null) {
            org.infinispan.Cache original;
            Cache removedCache = this.caches.remove(cacheName);
            if (removedCache != null && removedCache instanceof InfinispanJCacheWrapper && (original = ((InfinispanJCacheWrapper)removedCache).getOriginal()).getStatus() == ComponentStatus.RUNNING) {
                original.stop();
            }
        } else if (this.caches.get(cacheName) == null) {
            this.caches.put(cacheName, cache);
        }
    }

    @Override
    public CacheFactory getCacheFactory() throws CacheException {
        throw new CacheException("The InfinispanCacheManager does not provide an in-built nor look-up a CacheFactory.");
    }

    private static class InfinispanJCacheWrapper
    implements Cache {
        private org.infinispan.Cache cache;

        public InfinispanJCacheWrapper(org.infinispan.Cache cache) {
            if (cache.getStatus() == ComponentStatus.TERMINATED || cache.getStatus() == ComponentStatus.INSTANTIATED) {
                cache.start();
            } else if (cache.getStatus() == ComponentStatus.FAILED) {
                throw new RuntimeException("Failed to start the cache: " + cache.getName());
            }
            this.cache = cache;
        }

        private void logInvalidCacheStatus(String method) {
            log.info((Object)("InfinispanJCacheWrapper Error: Cache is terminated: " + method));
        }

        public org.infinispan.Cache getOriginal() {
            return this.cache;
        }

        public boolean containsKey(Object o) {
            boolean result = false;
            try {
                result = this.cache.containsKey(o);
            }
            catch (IllegalStateException e) {
                this.logInvalidCacheStatus("containsKey");
                return false;
            }
            return result;
        }

        public boolean containsValue(Object o) {
            boolean result = false;
            try {
                result = this.cache.containsValue(o);
            }
            catch (IllegalStateException e) {
                this.logInvalidCacheStatus("containsValue");
                return false;
            }
            return result;
        }

        public Set entrySet() {
            Set result = null;
            try {
                result = this.cache.entrySet();
            }
            catch (IllegalStateException e) {
                this.logInvalidCacheStatus("entrySet");
                return null;
            }
            return result;
        }

        public boolean equals(Object o) {
            return o instanceof InfinispanJCacheWrapper && ((InfinispanJCacheWrapper)o).cache.equals(this.cache);
        }

        public int hashCode() {
            return (int)((long)this.cache.hashCode() + (long)this.getClass().getCanonicalName().hashCode());
        }

        public boolean isEmpty() {
            boolean result = false;
            try {
                result = this.cache.isEmpty();
            }
            catch (IllegalStateException e) {
                this.logInvalidCacheStatus("isEmpty");
                return true;
            }
            return result;
        }

        public Set keySet() {
            Set result = null;
            try {
                result = this.cache.keySet();
            }
            catch (IllegalStateException e) {
                this.logInvalidCacheStatus("keySet");
                return null;
            }
            return result;
        }

        public void putAll(Map map) {
            try {
                this.cache.putAll(map);
            }
            catch (IllegalStateException e) {
                this.logInvalidCacheStatus("putAll");
            }
        }

        public int size() {
            int result = 0;
            try {
                result = this.cache.size();
            }
            catch (IllegalStateException e) {
                this.logInvalidCacheStatus("size");
                return 0;
            }
            return result;
        }

        public Collection values() {
            Collection result = null;
            try {
                result = this.cache.values();
            }
            catch (IllegalStateException e) {
                this.logInvalidCacheStatus("values");
                return null;
            }
            return result;
        }

        public Object get(Object o) {
            Object result = null;
            try {
                result = this.cache.get(o);
            }
            catch (IllegalStateException e) {
                this.logInvalidCacheStatus("get");
                return null;
            }
            return result;
        }

        public Map getAll(Collection collection) throws CacheException {
            ConcurrentHashMap output = new ConcurrentHashMap();
            try {
                for (Object o : collection) {
                    output.put(o, this.get(o));
                }
            }
            catch (IllegalStateException e) {
                this.logInvalidCacheStatus("getAll");
                return null;
            }
            return output;
        }

        public void load(Object o) throws CacheException {
            for (Object listener : this.cache.getListeners()) {
                if (!(listener instanceof CacheListener)) continue;
                ((CacheListener)listener).onLoad(o);
            }
        }

        public void loadAll(Collection collection) throws CacheException {
            for (Object o : collection) {
                this.load(o);
            }
        }

        public Object peek(Object o) {
            Object result = null;
            try {
                result = this.cache.getAdvancedCache().get(o);
            }
            catch (IllegalStateException e) {
                this.logInvalidCacheStatus("peek");
                return null;
            }
            return result;
        }

        public Object put(Object o, Object o1) {
            Object result = null;
            try {
                result = this.cache.put(o, o1);
            }
            catch (IllegalStateException e) {
                this.logInvalidCacheStatus("put");
                return null;
            }
            return result;
        }

        public CacheEntry getCacheEntry(Object o) {
            InfinispanJCacheEntry result = null;
            try {
                result = new InfinispanJCacheEntry(this.cache.getAdvancedCache().getDataContainer().get(o));
            }
            catch (IllegalStateException e) {
                this.logInvalidCacheStatus("getCacheEntry");
                return null;
            }
            return result;
        }

        public CacheStatistics getCacheStatistics() {
            return new InfinispanJCacheStatistics(this.cache.getAdvancedCache());
        }

        public Object remove(Object o) {
            try {
                return this.cache.remove(o);
            }
            catch (IllegalStateException e) {
                this.logInvalidCacheStatus("remove");
                return null;
            }
        }

        public void clear() {
            try {
                this.cache.clear();
            }
            catch (IllegalStateException e) {
                this.logInvalidCacheStatus("clear");
            }
        }

        public void evict() {
            this.cache.getAdvancedCache().getEvictionManager().processEviction();
        }

        public void addListener(CacheListener cacheListener) {
            this.cache.addListener((Object)cacheListener);
        }

        public void removeListener(CacheListener cacheListener) {
            this.cache.removeListener((Object)cacheListener);
        }
    }

    private static class InfinispanJCacheStatistics
    implements CacheStatistics {
        private Stats stats;
        private CacheMgmtInterceptor interceptor;

        private InfinispanJCacheStatistics(AdvancedCache cache) {
            this.stats = cache.getStats();
            this.interceptor = null;
            try {
                List chain = cache.getInterceptorChain();
                for (CommandInterceptor i : chain) {
                    if (!(i instanceof CacheMgmtInterceptor)) continue;
                    this.interceptor = (CacheMgmtInterceptor)i;
                    break;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public int getStatisticsAccuracy() {
            throw new UnsupportedOperationException("This version of Infinispan does not provide details on accuracy of statistics.");
        }

        public int getObjectCount() {
            return this.stats.getCurrentNumberOfEntries();
        }

        public int getCacheHits() {
            return (int)this.stats.getHits();
        }

        public int getCacheMisses() {
            return (int)this.stats.getMisses();
        }

        public void clearStatistics() {
            if (this.interceptor != null) {
                this.interceptor.resetStatistics();
            }
        }
    }

    private static class InfinispanJCacheEntry
    implements CacheEntry {
        private InternalCacheEntry cacheEntry;

        private InfinispanJCacheEntry(InternalCacheEntry cacheEntry) {
            this.cacheEntry = cacheEntry;
        }

        public int getHits() {
            throw new UnsupportedOperationException("Infinispan does not allow to find the number of hits on a per-entry basis.");
        }

        public long getLastAccessTime() {
            if (this.cacheEntry == null) {
                return 0L;
            }
            return this.cacheEntry.getLastUsed();
        }

        public long getLastUpdateTime() {
            if (this.cacheEntry == null) {
                return 0L;
            }
            return this.cacheEntry.getLastUsed();
        }

        public long getCreationTime() {
            if (this.cacheEntry == null) {
                return 0L;
            }
            return this.cacheEntry.getCreated();
        }

        public long getExpirationTime() {
            if (this.cacheEntry == null) {
                return 0L;
            }
            return this.cacheEntry.getExpiryTime();
        }

        public long getVersion() {
            return this.cacheEntry.getCreated();
        }

        public boolean isValid() {
            return this.cacheEntry.isValid();
        }

        public long getCost() {
            return 0L;
        }

        public Object getKey() {
            return this.cacheEntry != null ? this.cacheEntry.getKey() : null;
        }

        public Object getValue() {
            return this.cacheEntry != null ? this.cacheEntry.getValue() : null;
        }

        public Object setValue(Object o) {
            return this.cacheEntry != null ? this.cacheEntry.setValue(o) : null;
        }
    }
}

