/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.caching.core.authorization;

import java.util.Set;
import net.sf.jsr107cache.Cache;
import net.sf.jsr107cache.CacheManager;
import net.sf.jsr107cache.CacheStatistics;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.caching.core.authorization.AuthorizationCacheException;
import org.wso2.carbon.caching.core.authorization.AuthorizationKey;
import org.wso2.carbon.caching.core.authorization.AuthorizeCacheEntry;

public class AuthorizationCache {
    private static Log log = LogFactory.getLog(AuthorizationCache.class);
    public static final String AUTHORIZATION_CACHE = "AUTHORIZATION_CACHE";
    protected Cache cache = CacheManager.getInstance().getCache("AUTHORIZATION_CACHE");
    private static AuthorizationCache authorizationCache = new AuthorizationCache();

    private AuthorizationCache() {
    }

    private boolean isCacheNull() {
        if (this.cache == null) {
            if (log.isDebugEnabled()) {
                StackTraceElement[] elemets = Thread.currentThread().getStackTrace();
                String traceString = "";
                for (int i = 1; i < elemets.length; ++i) {
                    traceString = traceString + elemets[i] + System.getProperty("line.separator");
                }
                log.debug((Object)("AUTHORIZATION_CACHE doesn't exist in CacheManager:\n" + traceString));
            }
            return true;
        }
        return false;
    }

    public static AuthorizationCache getInstance() {
        return authorizationCache;
    }

    public void addToCache(int tenantId, String userName, String resourceId, String action, boolean isAuthorized) {
        if (this.isCacheNull()) {
            return;
        }
        AuthorizationKey key = new AuthorizationKey(tenantId, userName, resourceId, action);
        if (this.cache.containsKey((Object)key)) {
            this.cache.remove((Object)key);
        }
        AuthorizeCacheEntry cacheEntry = new AuthorizeCacheEntry(isAuthorized);
        this.cache.put((Object)key, (Object)cacheEntry);
    }

    public boolean isUserAuthorized(int tenantId, String userName, String resourceId, String action) throws AuthorizationCacheException {
        if (this.isCacheNull()) {
            throw new AuthorizationCacheException("Authorization information not found in the cache.");
        }
        AuthorizationKey key = new AuthorizationKey(tenantId, userName, resourceId, action);
        if (!this.cache.containsKey((Object)key)) {
            throw new AuthorizationCacheException("Authorization information not found in the cache.");
        }
        AuthorizeCacheEntry entry = (AuthorizeCacheEntry)this.cache.get((Object)key);
        return entry.isUserAuthorized();
    }

    public void clearCache() {
        if (this.isCacheNull()) {
            return;
        }
        this.cache.clear();
    }

    public void clearCacheEntry(int tenantId, String userName, String resourceId, String action) {
        if (this.isCacheNull()) {
            return;
        }
        AuthorizationKey key = new AuthorizationKey(tenantId, userName, resourceId, action);
        if (this.cache.containsKey((Object)key)) {
            this.cache.remove((Object)key);
        }
    }

    public void clearCacheByUser(int tenantId, String userName) {
        if (this.isCacheNull()) {
            return;
        }
        Set objectSect = this.cache.keySet();
        for (Object anObjectSect : objectSect) {
            AuthorizationKey key = (AuthorizationKey)anObjectSect;
            if (key.getTenantId() != tenantId || !key.getUserName().equals(userName)) continue;
            this.cache.remove((Object)key);
        }
    }

    public double hitRate() {
        if (this.isCacheNull()) {
            return 0.0;
        }
        CacheStatistics stats = this.cache.getCacheStatistics();
        return (double)stats.getCacheHits() / (double)(stats.getCacheHits() + stats.getCacheMisses());
    }

    public void clearCacheByTenant(int tenantId) {
        if (this.isCacheNull()) {
            return;
        }
        Set cacheKeySet = this.cache.keySet();
        for (Object cacheKey : cacheKeySet) {
            AuthorizationKey authzKey = (AuthorizationKey)cacheKey;
            if (tenantId != authzKey.getTenantId()) continue;
            this.cache.remove((Object)authzKey);
        }
    }

    public void clearCacheByResource(int tenantID, String resourceID) {
        if (this.isCacheNull()) {
            return;
        }
        Set cacheKeySet = this.cache.keySet();
        for (Object cacheKey : cacheKeySet) {
            AuthorizationKey authzKey = (AuthorizationKey)cacheKey;
            if (tenantID != authzKey.getTenantId() || !resourceID.equals(authzKey.getResourceId())) continue;
            this.cache.remove((Object)authzKey);
        }
    }
}

