/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.coordination.core.internal;

import java.io.File;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.ComponentContext;
import org.wso2.carbon.coordination.core.services.CoordinationService;
import org.wso2.carbon.coordination.core.services.impl.ZKCoordinationService;
import org.wso2.carbon.utils.CarbonUtils;

public class CoordinationClientDSComponent {
    private Log log = LogFactory.getLog(CoordinationClientDSComponent.class);
    private CoordinationService service = null;

    private CoordinationService getService() {
        return this.service;
    }

    protected void activate(ComponentContext ctx) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Starting Coordination component initialization..");
        }
        try {
            if (this.getService() == null) {
                String configPath = CarbonUtils.getCarbonConfigDirPath() + File.separator + "etc" + File.separator + "coordination-client-config.xml";
                this.service = new ZKCoordinationService(configPath);
            }
            BundleContext bundleContext = ctx.getBundleContext();
            bundleContext.registerService(CoordinationService.class.getName(), (Object)this.getService(), null);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"Coordination component initialized");
            }
        }
        catch (Throwable e) {
            this.log.error((Object)("Eror in initializing Coordination component: " + e.getMessage()), e);
        }
    }

    protected void deactivate(ComponentContext ctx) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Coordination component deactivation start..");
        }
        try {
            this.getService().close();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"Coordination component deactivated");
            }
        }
        catch (Exception e) {
            this.log.error((Object)("Eror in deactivating Coordination component: " + e.getMessage()), (Throwable)e);
        }
    }
}

