/*
 * Decompiled with CFR 0.152.
 */
package org.jaggeryjs.jaggery.core.task;

import java.io.File;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jaggeryjs.jaggery.core.internal.JaggeryCoreServiceComponent;
import org.jaggeryjs.jaggery.core.manager.CommonManager;
import org.jaggeryjs.scriptengine.engine.RhinoEngine;
import org.jaggeryjs.scriptengine.exceptions.ScriptException;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.wso2.carbon.ntask.core.AbstractTask;

public class JaggeryTask
extends AbstractTask {
    private static final Log log = LogFactory.getLog(JaggeryTask.class);

    public void execute() {
        try {
            Map<String, Object> taskMap = JaggeryCoreServiceComponent.getTaskMap();
            String taskName = (String)this.getProperties().get("taskName");
            if (taskName == null) {
                return;
            }
            Map taskProperties = (Map)taskMap.get(taskName);
            if (taskProperties == null) {
                return;
            }
            Object[] parameters = (Object[])taskProperties.get("jsfunctionarguments");
            Object jsFunction = taskProperties.get("jsfunction");
            Context context = RhinoEngine.enterContext();
            String jaggeryDir = System.getProperty("jaggery.home");
            if (jaggeryDir == null) {
                jaggeryDir = System.getProperty("carbon.home");
            }
            if (jaggeryDir == null) {
                log.error((Object)"Unable to find jaggery.home or carbon.home system properties");
                return;
            }
            jaggeryDir = jaggeryDir + File.separator + "modules";
            RhinoEngine engine = new CommonManager(jaggeryDir).getEngine();
            ScriptableObject scope = engine.getRuntimeScope();
            if (jsFunction instanceof Function) {
                Object[] args = parameters != null ? parameters : new Object[]{};
                Function function = (Function)jsFunction;
                function.call(context, (Scriptable)scope, (Scriptable)scope, args);
            } else if (jsFunction instanceof String) {
                String jsString = (String)jsFunction;
                context.evaluateString((Scriptable)scope, jsString, "Load JavaScriptString", 0, null);
            }
            RhinoEngine.exitContext();
        }
        catch (ScriptException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }
}

