/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.webapp.deployer;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.deployment.AbstractDeployer;
import org.apache.axis2.deployment.DeploymentException;
import org.apache.axis2.deployment.repository.util.DeploymentFileData;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.CarbonException;
import org.wso2.carbon.core.multitenancy.SuperTenantCarbonContext;
import org.wso2.carbon.webapp.mgt.TomcatGenericWebappsDeployer;
import org.wso2.carbon.webapp.mgt.WebApplication;
import org.wso2.carbon.webapp.mgt.WebApplicationsHolder;
import org.wso2.carbon.webapp.mgt.WebContextParameter;
import org.wso2.carbon.webapp.mgt.utils.GhostWebappDeployerUtils;

public class WebappDeployer
extends AbstractDeployer {
    private static final Log log = LogFactory.getLog(WebappDeployer.class);
    protected String webappsDir;
    protected TomcatGenericWebappsDeployer tomcatWebappDeployer;
    protected final List<WebContextParameter> servletContextParameters = new ArrayList<WebContextParameter>();
    protected ConfigurationContext configContext;
    protected AxisConfiguration axisConfig;
    protected WebApplicationsHolder webappsHolder;

    public void init(ConfigurationContext configCtx) {
        this.configContext = configCtx;
        this.axisConfig = configCtx.getAxisConfiguration();
        String repoPath = configCtx.getAxisConfiguration().getRepository().getPath();
        File webappsDirFile = new File(repoPath + File.separator + this.webappsDir);
        if (!webappsDirFile.exists() && !webappsDirFile.mkdirs()) {
            log.warn((Object)("Could not create directory " + webappsDirFile.getAbsolutePath()));
        }
        SuperTenantCarbonContext carbonContext = SuperTenantCarbonContext.getCurrentContext((ConfigurationContext)configCtx);
        int tenantId = carbonContext.getTenantId();
        String tenantDomain = carbonContext.getTenantDomain();
        String webContextPrefix = tenantDomain != null ? "/t/" + tenantDomain + "/" + "webapps" + "/" : "";
        this.webappsHolder = (WebApplicationsHolder)configCtx.getProperty("carbon.webapps.holder");
        if (this.webappsHolder == null) {
            this.webappsHolder = new WebApplicationsHolder(new File(this.webappsDir));
            configCtx.setProperty("carbon.webapps.holder", (Object)this.webappsHolder);
        }
        configCtx.setProperty("servlet.context.parameters.list", this.servletContextParameters);
        this.tomcatWebappDeployer = new TomcatGenericWebappsDeployer(webContextPrefix, tenantId, tenantDomain, this.webappsHolder, this.configContext);
        configCtx.setProperty("tomcatGenericWebappsDeplyer", (Object)this.tomcatWebappDeployer);
    }

    public void deploy(DeploymentFileData deploymentFileData) throws DeploymentException {
        if (!this.isUnpackedWebapp(deploymentFileData.getFile())) {
            if (!GhostWebappDeployerUtils.isGhostOn()) {
                this.deployThisWebApp(deploymentFileData);
            } else {
                String absoluteFilePath = deploymentFileData.getAbsolutePath();
                File ghostFile = GhostWebappDeployerUtils.getGhostFile((String)absoluteFilePath, (AxisConfiguration)this.axisConfig);
                if (ghostFile == null || !ghostFile.exists()) {
                    this.deployThisWebApp(deploymentFileData);
                    WebApplication webApplication = GhostWebappDeployerUtils.findDeployedWebapp((ConfigurationContext)this.configContext, (String)absoluteFilePath);
                    if (webApplication != null) {
                        GhostWebappDeployerUtils.updateLastUsedTime((WebApplication)webApplication);
                        GhostWebappDeployerUtils.serializeWebApp((WebApplication)webApplication, (AxisConfiguration)this.axisConfig, (String)absoluteFilePath);
                    }
                } else {
                    WebApplication ghostWebApplication = GhostWebappDeployerUtils.createGhostWebApp((File)ghostFile, (File)deploymentFileData.getFile(), (AxisConfiguration)this.axisConfig);
                    ghostWebApplication.setServletContextParameters(this.servletContextParameters);
                    String ghostWebappFileName = deploymentFileData.getFile().getName();
                    WebApplicationsHolder webappsHolder = (WebApplicationsHolder)this.configContext.getProperty("carbon.webapps.holder");
                    log.info((Object)("Deploying Ghost WebApp : " + ghostWebappFileName));
                    webappsHolder.getStartedWebapps().put(ghostWebappFileName, ghostWebApplication);
                    webappsHolder.getFaultyWebapps().remove(ghostWebappFileName);
                }
            }
        }
    }

    private void deployThisWebApp(DeploymentFileData deploymentFileData) throws DeploymentException {
        try {
            ArrayList listeners = new ArrayList(1);
            this.tomcatWebappDeployer.deploy(deploymentFileData.getFile(), (List)((ArrayList)this.configContext.getProperty("servlet.context.parameters.list")), listeners);
            super.deploy(deploymentFileData);
        }
        catch (Exception e) {
            String msg = "Error occurred while deploying webapp " + deploymentFileData.getFile().getAbsolutePath();
            log.error((Object)msg, (Throwable)e);
            throw new DeploymentException(msg, (Throwable)e);
        }
    }

    public void setDirectory(String repoDir) {
        this.webappsDir = repoDir;
    }

    public void setExtension(String extension) {
    }

    public void undeploy(String fileName) throws DeploymentException {
        try {
            this.tomcatWebappDeployer.undeploy(new File(fileName));
            if (GhostWebappDeployerUtils.isGhostOn()) {
                File ghostFile = GhostWebappDeployerUtils.getGhostFile((String)fileName, (AxisConfiguration)this.axisConfig);
                File dummyContextDir = GhostWebappDeployerUtils.getDummyContextFile((String)fileName, (AxisConfiguration)this.axisConfig);
                if (ghostFile != null && ghostFile.exists() && !ghostFile.delete()) {
                    log.error((Object)("Error while deleting ghost webapp file : " + ghostFile.getAbsolutePath()));
                }
                if (dummyContextDir != null && dummyContextDir.exists() && !dummyContextDir.delete()) {
                    log.error((Object)("Error while deleting dummy context file : " + dummyContextDir.getAbsolutePath()));
                }
            }
        }
        catch (CarbonException e) {
            String msg = "Error occurred during undeploying webapp: " + fileName;
            log.error((Object)msg, (Throwable)e);
            throw new DeploymentException(msg, (Throwable)e);
        }
        super.undeploy(fileName);
    }

    public void cleanup() throws DeploymentException {
        for (String filePath : this.deploymentFileDataMap.keySet()) {
            try {
                this.tomcatWebappDeployer.lazyUnload(new File(filePath));
            }
            catch (CarbonException e) {
                String msg = "Error occurred during cleaning up webapps";
                log.error((Object)msg, (Throwable)e);
                throw new DeploymentException(msg, (Throwable)e);
            }
        }
        if (GhostWebappDeployerUtils.isGhostOn() && this.webappsHolder != null) {
            for (WebApplication webApplication : this.webappsHolder.getStartedWebapps().values()) {
                try {
                    this.tomcatWebappDeployer.lazyUnload(webApplication.getWebappFile());
                }
                catch (CarbonException e) {
                    String msg = "Error occurred during cleaning up webapps";
                    log.error((Object)msg, (Throwable)e);
                    throw new DeploymentException(msg, (Throwable)e);
                }
            }
        }
    }

    private boolean isUnpackedWebapp(File webappFile) {
        boolean isExploded = false;
        File warFile = new File(webappFile.getPath() + ".war");
        if (webappFile.isDirectory() && warFile.exists()) {
            isExploded = true;
        }
        return isExploded;
    }
}

