/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.ui;

import java.net.MalformedURLException;
import java.net.URL;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.equinox.http.helper.BundleEntryHttpContext;
import org.osgi.framework.Bundle;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.ui.CarbonUIAuthenticator;
import org.wso2.carbon.ui.UIResourceRegistry;
import org.wso2.carbon.ui.tracker.AuthenticatorRegistry;

public class SecuredComponentEntryHttpContext
extends BundleEntryHttpContext {
    private String bundlePath;
    protected Registry registry;
    protected UIResourceRegistry uiResourceRegistry;
    protected Log log = LogFactory.getLog(((Object)((Object)this)).getClass());

    public SecuredComponentEntryHttpContext(Bundle bundle) {
        super(bundle);
    }

    public SecuredComponentEntryHttpContext(Bundle bundle, String bundlePath, UIResourceRegistry uiResourceRegistry) {
        super(bundle, bundlePath);
        this.bundlePath = bundlePath;
        this.uiResourceRegistry = uiResourceRegistry;
    }

    public SecuredComponentEntryHttpContext(Bundle bundle, String s, Registry registry) {
        super(bundle, s);
        this.registry = registry;
    }

    public URL getResource(String resourceName) {
        URL url = super.getResource(resourceName);
        if (url != null) {
            return url;
        }
        url = this.uiResourceRegistry.getUIResource(resourceName);
        if (url != null) {
            return url;
        }
        int lastSlash = resourceName.lastIndexOf(47);
        if (lastSlash == -1) {
            return null;
        }
        String file = resourceName.substring(lastSlash + 1);
        if (file.endsWith(".js") && this.isListed(file)) {
            try {
                return new URL("carbon://generate/" + file);
            }
            catch (MalformedURLException e) {
                return null;
            }
        }
        return null;
    }

    protected CarbonUIAuthenticator getAuthenticator(HttpServletRequest request) {
        return AuthenticatorRegistry.getCarbonAuthenticator(request);
    }

    private boolean isListed(String file) {
        return "global-params.js".equals(file);
    }
}

