/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.ui;

import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.xml.namespace.QName;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.OperationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.authenticator.proxy.AuthenticationAdminClient;
import org.wso2.carbon.core.common.AuthenticationException;
import org.wso2.carbon.core.commons.stub.loggeduserinfo.ExceptionException;
import org.wso2.carbon.core.commons.stub.loggeduserinfo.LoggedUserInfo;
import org.wso2.carbon.core.commons.stub.loggeduserinfo.LoggedUserInfoAdminStub;
import org.wso2.carbon.ui.AbstractCarbonUIAuthenticator;
import org.wso2.carbon.ui.CarbonUIUtil;
import org.wso2.carbon.ui.util.CarbonUIAuthenticationUtil;
import org.wso2.carbon.utils.CarbonUtils;

public class DefaultCarbonAuthenticator
extends AbstractCarbonUIAuthenticator {
    protected static final Log log = LogFactory.getLog(DefaultCarbonAuthenticator.class);
    private static final String AUTHENTICATOR_NAME = "DefaultCarbonAuthenticator";

    @Override
    public boolean reAuthenticateOnSessionExpire(Object object) throws AuthenticationException {
        boolean isValidRememberMe = false;
        try {
            Cookie[] cookies;
            HttpServletRequest request = (HttpServletRequest)object;
            for (Cookie cookie : cookies = request.getCookies()) {
                if (!cookie.getName().equals("wso2.carbon.rememberme")) continue;
                isValidRememberMe = this.authenticate(cookie, request);
            }
        }
        catch (AxisFault e) {
            log.debug((Object)"Unable to authenticate with the cookie", (Throwable)e);
            QName errorCode = e.getFaultCode();
            if (errorCode != null) {
                throw new AuthenticationException(e.getMessage(), (Throwable)e, errorCode.getLocalPart());
            }
            throw new AuthenticationException(e.getMessage(), (Throwable)e);
        }
        return isValidRememberMe;
    }

    protected boolean authenticate(Cookie cookie, HttpServletRequest request) throws AxisFault {
        try {
            this.retrieveUserAuthorizationData(cookie, request);
            return true;
        }
        catch (AxisFault axisFault) {
            throw axisFault;
        }
        catch (RemoteException e) {
            throw new AxisFault("Unable to access backend server", (Throwable)e);
        }
        catch (Exception e) {
            throw new AxisFault("Exception occurred", (Throwable)e);
        }
    }

    @Override
    public boolean isHandle(Object object) {
        return true;
    }

    @Override
    public boolean authenticate(Object object) throws AuthenticationException {
        boolean isAuthenticated;
        HttpServletRequest request = (HttpServletRequest)object;
        String userName = request.getParameter("username");
        String password = request.getParameter("password");
        String value = request.getParameter("rememberMe");
        boolean isRememberMe = false;
        if (value != null && value.equals("rememberMe")) {
            isRememberMe = true;
        }
        try {
            isAuthenticated = this.authenticate(request, userName, password, isRememberMe);
        }
        catch (AxisFault e) {
            log.debug((Object)"Unable to authenticate with the cookie", (Throwable)e);
            QName errorCode = e.getFaultCode();
            if (errorCode != null) {
                throw new AuthenticationException(e.getMessage(), (Throwable)e, errorCode.getLocalPart());
            }
            throw new AuthenticationException(e.getMessage(), (Throwable)e);
        }
        catch (RemoteException e) {
            throw new AuthenticationException(e.getMessage(), (Throwable)e);
        }
        return isAuthenticated;
    }

    @Override
    public void unauthenticate(Object object) throws Exception {
        try {
            this.getAuthenticationAdminCient((HttpServletRequest)object).logout();
        }
        catch (Exception ignored) {
            String msg = "Configuration context is null.";
            log.error((Object)msg);
            throw new Exception(msg);
        }
    }

    protected boolean authenticate(HttpServletRequest request, String userName, String password, boolean isRememberMe) throws RemoteException {
        try {
            String userNameWithDomain = userName;
            String domainName = (String)request.getAttribute("tenantDomain");
            if (domainName != null) {
                userNameWithDomain = userNameWithDomain + "@" + domainName;
            }
            userNameWithDomain = userNameWithDomain.trim();
            this.retrieveUserAuthorizationData(userNameWithDomain, password, isRememberMe, request);
            return true;
        }
        catch (AxisFault axisFault) {
            throw axisFault;
        }
        catch (RemoteException e) {
            throw e;
        }
        catch (Exception e) {
            throw new AxisFault("Exception occurred", (Throwable)e);
        }
    }

    private LoggedUserInfoAdminStub getLoggedUserInfoAdminStub(String backendServerURL, HttpSession session) throws AxisFault {
        ServletContext servletContext = session.getServletContext();
        ConfigurationContext configContext = (ConfigurationContext)servletContext.getAttribute("ConfigurationContext");
        if (configContext == null) {
            String msg = "Configuration context is null.";
            log.error((Object)msg);
            throw new AxisFault(msg);
        }
        return new LoggedUserInfoAdminStub(configContext, backendServerURL + "LoggedUserInfoAdmin");
    }

    private void retrieveUserAuthorizationData(String userName, String password, boolean rememberMe, HttpServletRequest request) throws AxisFault {
        String backendServerURL = this.getBackendUrl(request);
        HttpSession session = request.getSession();
        LoggedUserInfoAdminStub stub = this.getLoggedUserInfoAdminStub(backendServerURL, session);
        try {
            ServiceClient client = stub._getServiceClient();
            CarbonUtils.setBasicAccessSecurityHeaders((String)userName, (String)password, (boolean)rememberMe, (ServiceClient)client);
            this.setUserAuthorizationInfo(stub, session);
            this.setAdminCookie(session, client, null);
            if (rememberMe) {
                this.processRememberMeData(client, request);
            }
        }
        catch (AxisFault axisFault) {
            throw axisFault;
        }
        catch (RemoteException e) {
            throw new AxisFault(e.getMessage(), (Throwable)e);
        }
        catch (ExceptionException e) {
            throw new AxisFault("Exception occurred while accessing user authorization info", (Throwable)e);
        }
    }

    private void retrieveUserAuthorizationData(Cookie rememberMeCookie, HttpServletRequest request) throws AxisFault {
        String backendServerURL = this.getBackendUrl(request);
        HttpSession session = request.getSession();
        LoggedUserInfoAdminStub stub = this.getLoggedUserInfoAdminStub(backendServerURL, session);
        try {
            ServiceClient client = stub._getServiceClient();
            CarbonUIAuthenticationUtil.setCookieHeaders(rememberMeCookie, client);
            this.setUserAuthorizationInfo(stub, session);
            this.setAdminCookie(session, client, rememberMeCookie.getValue());
        }
        catch (AxisFault axisFault) {
            throw axisFault;
        }
        catch (RemoteException e) {
            throw new AxisFault(e.getMessage(), (Throwable)e);
        }
        catch (ExceptionException e) {
            throw new AxisFault("Exception occurred while accessing user authorization info", (Throwable)e);
        }
    }

    private void setUserAuthorizationInfo(LoggedUserInfoAdminStub loggedUserInfoAdminStub, HttpSession session) throws ExceptionException, RemoteException {
        ServiceClient client = loggedUserInfoAdminStub._getServiceClient();
        Options options = client.getOptions();
        options.setManageSession(true);
        LoggedUserInfo userInfo = loggedUserInfoAdminStub.getUserInfo();
        String[] permissionArray = userInfo.getUIPermissionOfUser();
        ArrayList list = new ArrayList();
        Collections.addAll(list, permissionArray);
        session.setAttribute("user-permissions", list);
        if (userInfo.getPasswordExpiration() != null) {
            session.setAttribute("passwordExpires", (Object)userInfo.getPasswordExpiration());
        }
    }

    private void processRememberMeData(ServiceClient serviceClient, HttpServletRequest httpServletRequest) throws AxisFault {
        OperationContext operationContext = serviceClient.getLastOperationContext();
        MessageContext inMessageContext = operationContext.getMessageContext("In");
        Map transportHeaders = (Map)inMessageContext.getProperty("TRANSPORT_HEADERS");
        String cookieValue = (String)transportHeaders.get("RememberMeCookieValue");
        String cookieAge = (String)transportHeaders.get("RememberMeCookieAge");
        if (cookieValue == null || cookieAge == null) {
            throw new AxisFault("Unable to load remember me date from response. Cookie value or cookie age or both are null");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Cookie value returned " + cookieValue + " cookie age " + cookieAge));
        }
        httpServletRequest.setAttribute("wso2.carbon.rememberme.value", (Object)cookieValue);
        httpServletRequest.setAttribute("wso2.carbon.rememberme.age", (Object)cookieAge);
    }

    private void setAdminCookie(HttpSession session, ServiceClient serviceClient, String rememberMeCookie) throws AxisFault {
        String cookie = (String)serviceClient.getServiceContext().getProperty("Cookie");
        if (rememberMeCookie != null) {
            cookie = cookie + "; " + rememberMeCookie;
        }
        if (session != null) {
            session.setAttribute("wso2carbon.admin.service.cookie", (Object)cookie);
        }
    }

    @Override
    public String getAuthenticatorName() {
        return AUTHENTICATOR_NAME;
    }

    public String getBackendUrl(HttpServletRequest request) {
        HttpSession session = request.getSession();
        ServletContext servletContext = session.getServletContext();
        String backendServerURL = request.getParameter("backendURL");
        if (backendServerURL == null) {
            backendServerURL = CarbonUIUtil.getServerURL(servletContext, request.getSession());
        }
        session.setAttribute("ServerURL", (Object)backendServerURL);
        return backendServerURL;
    }

    protected AuthenticationAdminClient getAuthenticationAdminCient(HttpServletRequest request) throws AxisFault {
        HttpSession session = request.getSession();
        ServletContext servletContext = session.getServletContext();
        String backendServerURL = request.getParameter("backendURL");
        if (backendServerURL == null) {
            backendServerURL = CarbonUIUtil.getServerURL(servletContext, request.getSession());
        }
        session.setAttribute("ServerURL", (Object)backendServerURL);
        ConfigurationContext configContext = (ConfigurationContext)servletContext.getAttribute("ConfigurationContext");
        String cookie = (String)session.getAttribute("wso2carbon.admin.service.cookie");
        return new AuthenticationAdminClient(configContext, backendServerURL, cookie, session, true);
    }
}

