/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.ntask.core.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.ntask.common.TaskException;
import org.wso2.carbon.ntask.core.TaskInfo;
import org.wso2.carbon.ntask.core.TaskRepository;
import org.wso2.carbon.ntask.core.TaskUtils;
import org.wso2.carbon.ntask.core.service.impl.RegistryTaskAvailabilityManager;
import org.wso2.carbon.registry.api.Collection;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;

public class RegistryBasedTaskRepository
implements TaskRepository {
    private Log log = LogFactory.getLog(RegistryBasedTaskRepository.class);
    public static final String REG_TASK_REPO_BASE_PATH = "/repository/components/org.wso2.carbon.tasks/types";
    private Registry registry;
    private String taskType;
    private Marshaller taskMarshaller;
    private Unmarshaller taskUnmarshaller;
    private int tid;
    private RegistryTaskAvailabilityManager taskAvailabilityManager;

    public RegistryBasedTaskRepository(int tid, String taskType, RegistryTaskAvailabilityManager taskAvailabilityManager) throws TaskException {
        this.tid = tid;
        this.taskType = taskType;
        this.taskAvailabilityManager = taskAvailabilityManager;
        try {
            JAXBContext ctx = JAXBContext.newInstance((Class[])new Class[]{TaskInfo.class});
            this.taskMarshaller = ctx.createMarshaller();
            this.taskUnmarshaller = ctx.createUnmarshaller();
        }
        catch (JAXBException e) {
            throw new TaskException("Error creating task marshaller/unmarshaller", TaskException.Code.CONFIG_ERROR, (Exception)((Object)e));
        }
    }

    public RegistryTaskAvailabilityManager getTaskAvailabilityManager() {
        return this.taskAvailabilityManager;
    }

    public int getTenantId() {
        return this.tid;
    }

    public Marshaller getTaskMarshaller() {
        return this.taskMarshaller;
    }

    public Unmarshaller getTaskUnmarshaller() {
        return this.taskUnmarshaller;
    }

    public synchronized Registry getRegistry() throws TaskException {
        if (this.registry == null) {
            this.registry = TaskUtils.getGovRegistryForTenant(this.getTenantId());
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Retrieving the governance registry for tenant: " + this.getTenantId()));
            }
        }
        return this.registry;
    }

    public String getTaskType() {
        return this.taskType;
    }

    @Override
    public List<TaskInfo> getAllTasks() throws TaskException {
        ArrayList<TaskInfo> result = new ArrayList<TaskInfo>();
        String tasksPath = this.getMyTasksPath();
        try {
            this.getRegistry().beginTransaction();
            if (this.getRegistry().resourceExists(tasksPath)) {
                String[] taskPaths;
                Collection tasksCollection = (Collection)this.getRegistry().get(tasksPath);
                for (String taskPath : taskPaths = tasksCollection.getChildren()) {
                    TaskInfo taskInfo = this.getTaskInfoRegistryPath(taskPath);
                    result.add(taskInfo);
                }
            }
            this.getRegistry().commitTransaction();
            return result;
        }
        catch (Exception e) {
            try {
                this.getRegistry().rollbackTransaction();
            }
            catch (RegistryException e2) {
                this.log.error((Object)e2);
            }
            throw new TaskException("Error in getting all tasks from repository", TaskException.Code.CONFIG_ERROR, e);
        }
    }

    private int getTaskCount() throws TaskException {
        String tasksPath = this.getMyTasksPath();
        try {
            if (this.getRegistry().resourceExists(tasksPath)) {
                Collection tasksCollection = (Collection)this.getRegistry().get(tasksPath);
                return tasksCollection.getChildCount();
            }
            return 0;
        }
        catch (Exception e) {
            throw new TaskException("Error in getting task count from repository", TaskException.Code.CONFIG_ERROR, e);
        }
    }

    @Override
    public TaskInfo getTask(String taskName) throws TaskException {
        String tasksPath = this.getMyTasksPath();
        String currentTaskPath = tasksPath + "/" + taskName;
        try {
            this.getRegistry().beginTransaction();
            if (!this.getRegistry().resourceExists(currentTaskPath)) {
                throw new TaskException("The task with name: " + taskName + " doesn't exist in the repository for reload", TaskException.Code.NO_TASK_EXISTS);
            }
            TaskInfo taskInfo = this.getTaskInfoRegistryPath(currentTaskPath);
            this.getRegistry().commitTransaction();
            return taskInfo;
        }
        catch (Exception e) {
            try {
                this.getRegistry().rollbackTransaction();
            }
            catch (RegistryException e2) {
                this.log.error((Object)e2);
            }
            throw new TaskException("Error in reloading task '" + taskName + "' from registry", TaskException.Code.CONFIG_ERROR, e);
        }
    }

    @Override
    public synchronized void addTask(TaskInfo taskInfo) throws TaskException {
        String tasksPath = this.getMyTasksPath();
        String currentTaskPath = tasksPath + "/" + taskInfo.getName();
        try {
            this.getRegistry().beginTransaction();
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            this.getTaskMarshaller().marshal((Object)taskInfo, (OutputStream)out);
            ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
            Resource resource = this.getRegistry().newResource();
            resource.setContentStream((InputStream)in);
            this.getRegistry().put(currentTaskPath, (org.wso2.carbon.registry.api.Resource)resource);
            this.getTaskAvailabilityManager().setTasksAvailable(this.getTenantId(), true);
            this.getRegistry().commitTransaction();
        }
        catch (Exception e) {
            try {
                this.getRegistry().rollbackTransaction();
                this.processTasksAvailable();
            }
            catch (RegistryException e2) {
                this.log.error((Object)e2);
            }
            throw new TaskException("Error in adding task '" + taskInfo.getName() + "' to the repository: " + e.getMessage(), TaskException.Code.CONFIG_ERROR, e);
        }
    }

    private void processTasksAvailable() throws TaskException {
        if (this.getTaskCount() == 0) {
            this.getTaskAvailabilityManager().setTasksAvailable(this.getTenantId(), false);
        }
    }

    @Override
    public synchronized void deleteTask(String taskName) throws TaskException {
        String tasksPath = this.getMyTasksPath();
        String currentTaskPath = tasksPath + "/" + taskName;
        try {
            this.getRegistry().beginTransaction();
            if (!this.getRegistry().resourceExists(currentTaskPath)) {
                throw new TaskException("The task with name: " + taskName + " doesn't exist in the repository for deletion", TaskException.Code.NO_TASK_EXISTS);
            }
            this.getRegistry().delete(currentTaskPath);
            this.getRegistry().commitTransaction();
            this.processTasksAvailable();
        }
        catch (RegistryException e) {
            try {
                this.getRegistry().rollbackTransaction();
            }
            catch (RegistryException e2) {
                this.log.error((Object)e2);
            }
            throw new TaskException("Error in deleting task '" + taskName + "' in the repository", TaskException.Code.CONFIG_ERROR, (Exception)((Object)e));
        }
    }

    private String getMyTasksPath() {
        return "/repository/components/org.wso2.carbon.tasks/types/" + this.getTasksType();
    }

    private TaskInfo getTaskInfoRegistryPath(String path) throws Exception {
        Resource resource = this.getRegistry().get(path);
        InputStream in = resource.getContentStream();
        TaskInfo taskInfo = (TaskInfo)this.getTaskUnmarshaller().unmarshal(in);
        in.close();
        taskInfo.getProperties().put("__TENANT_ID_PROP__", String.valueOf(this.getTenantId()));
        return taskInfo;
    }

    @Override
    public String getTasksType() {
        return this.taskType;
    }
}

