/*
 * Decompiled with CFR 0.152.
 */
package org.jaggeryjs.jaggery.app.mgt.ui;

import java.io.IOException;
import java.io.InputStream;
import java.rmi.RemoteException;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.activation.DataHandler;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jaggeryjs.jaggery.app.mgt.stub.JaggeryAppAdminStub;
import org.jaggeryjs.jaggery.app.mgt.stub.types.carbon.SessionsWrapper;
import org.jaggeryjs.jaggery.app.mgt.stub.types.carbon.WebappMetadata;
import org.jaggeryjs.jaggery.app.mgt.stub.types.carbon.WebappUploadData;
import org.jaggeryjs.jaggery.app.mgt.stub.types.carbon.WebappsWrapper;

public class JaggeryAdminClient {
    private static final String CANNOT_EXPIRE_ALL_SESSIONS_IN_WEBAPPS = "cannot.expire.all.sessions.in.webapps";
    private static final String CANNOT_DELETE_WEBAPPS = "cannot.delete.webapps";
    public static final String BUNDLE = "org.jaggeryjs.jaggery.app.mgt.ui.i18n.Resources";
    private static final Log log = LogFactory.getLog(JaggeryAdminClient.class);
    private ResourceBundle bundle;
    private JaggeryAppAdminStub stub;

    public JaggeryAdminClient(String cookie, String backendServerURL, ConfigurationContext configCtx, Locale locale) throws AxisFault {
        String serviceURL = backendServerURL + "JaggeryAppAdmin";
        this.bundle = ResourceBundle.getBundle(BUNDLE, locale);
        this.stub = new JaggeryAppAdminStub(configCtx, serviceURL);
        ServiceClient client = this.stub._getServiceClient();
        Options option = client.getOptions();
        option.setManageSession(true);
        option.setProperty("Cookie", (Object)cookie);
        option.setProperty("enableMTOM", (Object)"true");
    }

    public WebappsWrapper getPagedWebappsSummary(String webappSearchString, String webappState, int pageNumber) throws AxisFault {
        try {
            return this.stub.getPagedWebappsSummary(webappSearchString, webappState, pageNumber);
        }
        catch (RemoteException e) {
            this.handleException("cannot.get.webapp.data", e);
            return null;
        }
    }

    public WebappMetadata getStartedWebapp(String webappFileName) throws AxisFault {
        try {
            return this.stub.getStartedWebapp(webappFileName);
        }
        catch (RemoteException e) {
            this.handleException("cannot.get.started.webapp.data", e);
            return null;
        }
    }

    public WebappMetadata getStoppedWebapp(String webappFileName) throws AxisFault {
        try {
            return this.stub.getStoppedWebapp(webappFileName);
        }
        catch (RemoteException e) {
            this.handleException("cannot.get.stopped.webapp.data", e);
            return null;
        }
    }

    public void deleteAllStartedWebapps() throws AxisFault {
        try {
            this.stub.deleteAllStartedWebapps();
        }
        catch (RemoteException e) {
            this.handleException(CANNOT_DELETE_WEBAPPS, e);
        }
    }

    public void deleteAllStoppedWebapps() throws AxisFault {
        try {
            this.stub.deleteAllStoppedWebapps();
        }
        catch (RemoteException e) {
            this.handleException(CANNOT_DELETE_WEBAPPS, e);
        }
    }

    public void deleteStartedWebapps(String[] webappFileNames) throws AxisFault {
        try {
            this.stub.deleteStartedWebapps(webappFileNames);
        }
        catch (RemoteException e) {
            this.handleException(CANNOT_DELETE_WEBAPPS, e);
        }
    }

    public void deleteStoppedWebapps(String[] webappFileNames) throws AxisFault {
        try {
            this.stub.deleteStoppedWebapps(webappFileNames);
        }
        catch (RemoteException e) {
            this.handleException(CANNOT_DELETE_WEBAPPS, e);
        }
    }

    public WebappsWrapper getPagedFaultyWebappsSummary(String webappSearchString, int pageNumber) throws AxisFault {
        try {
            return this.stub.getPagedFaultyWebappsSummary(webappSearchString, pageNumber);
        }
        catch (RemoteException e) {
            this.handleException("cannot.get.webapp.data", e);
            return null;
        }
    }

    public void deleteFaultyWebapps(String[] webappFileNames) throws AxisFault {
        try {
            this.stub.deleteFaultyWebapps(webappFileNames);
        }
        catch (RemoteException e) {
            this.handleException("cannot.delete.all.faulty.webapps", e);
        }
    }

    public void deleteAllFaultyWebapps() throws AxisFault {
        try {
            this.stub.deleteAllFaultyWebapps();
        }
        catch (RemoteException e) {
            this.handleException("cannot.delete.all.faulty.webapps", e);
        }
    }

    public void reloadAllWebapps() throws AxisFault {
        try {
            this.stub.reloadAllWebapps();
        }
        catch (RemoteException e) {
            this.handleException("cannot.reload.webapps", e);
        }
    }

    public void reloadWebapps(String[] webappFileNames) throws AxisFault {
        try {
            this.stub.reloadWebapps(webappFileNames);
        }
        catch (RemoteException e) {
            this.handleException("cannot.reload.webapps", e);
        }
    }

    public void stopAllWebapps() throws AxisFault {
        try {
            this.stub.stopAllWebapps();
        }
        catch (RemoteException e) {
            this.handleException("cannot.stop.webapps", e);
        }
    }

    public void stopWebapps(String[] webappFileNames) throws AxisFault {
        try {
            this.stub.stopWebapps(webappFileNames);
        }
        catch (RemoteException e) {
            this.handleException("cannot.stop.webapps", e);
        }
    }

    public void startAllWebapps() throws AxisFault {
        try {
            this.stub.startAllWebapps();
        }
        catch (RemoteException e) {
            this.handleException("cannot.start.webapps", e);
        }
    }

    public void startWebapps(String[] webappFileNames) throws AxisFault {
        try {
            this.stub.startWebapps(webappFileNames);
        }
        catch (RemoteException e) {
            this.handleException("cannot.start.webapps", e);
        }
    }

    public SessionsWrapper getActiveSessionsInWebapp(String webappFileName, int pageNumber) throws AxisFault {
        try {
            return this.stub.getActiveSessions(webappFileName, pageNumber);
        }
        catch (RemoteException e) {
            this.handleException("cannot.get.active.sessions", e);
            return null;
        }
    }

    public void expireSessionsInWebapps(String[] webappFileNames) throws AxisFault {
        try {
            this.stub.expireSessionsInWebapps(webappFileNames);
        }
        catch (RemoteException e) {
            this.handleException(CANNOT_EXPIRE_ALL_SESSIONS_IN_WEBAPPS, e);
        }
    }

    public void expireSessionsInWebapp(String webappFileName, long maxSessionLifetimeMillis) throws AxisFault {
        try {
            this.stub.expireSessionsInWebapp(webappFileName, maxSessionLifetimeMillis);
        }
        catch (RemoteException e) {
            this.handleException(CANNOT_EXPIRE_ALL_SESSIONS_IN_WEBAPPS, e);
        }
    }

    public void expireSessionsInWebapp(String webappFileName, String[] sessionIDs) throws AxisFault {
        try {
            this.stub.expireSessions(webappFileName, sessionIDs);
        }
        catch (RemoteException e) {
            this.handleException(CANNOT_EXPIRE_ALL_SESSIONS_IN_WEBAPPS, e);
        }
    }

    public void expireSessionsInAllWebapps() throws AxisFault {
        try {
            this.stub.expireSessionsInAllWebapps();
        }
        catch (RemoteException e) {
            this.handleException(CANNOT_EXPIRE_ALL_SESSIONS_IN_WEBAPPS, e);
        }
    }

    public void expireAllSessionsInWebapp(String webappFileName) throws AxisFault {
        try {
            this.stub.expireAllSessions(webappFileName);
        }
        catch (RemoteException e) {
            this.handleException(CANNOT_EXPIRE_ALL_SESSIONS_IN_WEBAPPS, e);
        }
    }

    public void uploadWebapp(WebappUploadData[] webappUploadDataList) throws AxisFault {
        try {
            this.stub.uploadWebapp(webappUploadDataList);
        }
        catch (RemoteException e) {
            this.handleException("cannot.upload.webapps", e);
        }
    }

    private void handleException(String msgKey, Exception e) throws AxisFault {
        String msg = this.bundle.getString(msgKey);
        log.error((Object)msg, (Throwable)e);
        throw new AxisFault(msg, (Throwable)e);
    }

    public void downloadWarFileHandler(String fileName, HttpServletResponse response) throws AxisFault {
        try {
            ServletOutputStream out = response.getOutputStream();
            DataHandler handler = this.stub.downloadWarFileHandler(fileName);
            if (handler != null) {
                int nextChar;
                response.setHeader("Content-Disposition", "fileName=" + fileName);
                response.setContentType(handler.getContentType());
                InputStream in = handler.getDataSource().getInputStream();
                while ((nextChar = in.read()) != -1) {
                    out.write((int)((char)nextChar));
                }
                out.flush();
                in.close();
            } else {
                out.write("The requested Jaggery app was not found on the server".getBytes());
            }
        }
        catch (RemoteException e) {
            this.handleException("error.downloading.war", e);
        }
        catch (IOException e) {
            this.handleException("error.downloading.war", e);
        }
    }
}

